# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeviceMetadata(BaseModel):
    """
    DeviceMetadata
    """ # noqa: E501
    device_id: Optional[StrictStr] = Field(default=None, description="Relatively stable ID for the device. Will update on app uninstall and reinstall")
    klaviyo_sdk: Optional[StrictStr] = Field(default=None, description="The name of the SDK used to create the push token.")
    sdk_version: Optional[StrictStr] = Field(default=None, description="The version of the SDK used to create the push token")
    device_model: Optional[StrictStr] = Field(default=None, description="The model of the device")
    os_name: Optional[StrictStr] = Field(default=None, description="The name of the operating system on the device.")
    os_version: Optional[StrictStr] = Field(default=None, description="The version of the operating system on the device")
    manufacturer: Optional[StrictStr] = Field(default=None, description="The manufacturer of the device")
    app_name: Optional[StrictStr] = Field(default=None, description="The name of the app that created the push token")
    app_version: Optional[StrictStr] = Field(default=None, description="The version of the app that created the push token")
    app_build: Optional[StrictStr] = Field(default=None, description="The build of the app that created the push token")
    app_id: Optional[StrictStr] = Field(default=None, description="The ID of the app that created the push token")
    environment: Optional[StrictStr] = Field(default=None, description="The environment in which the push token was created")
    __properties: ClassVar[List[str]] = ["device_id", "klaviyo_sdk", "sdk_version", "device_model", "os_name", "os_version", "manufacturer", "app_name", "app_version", "app_build", "app_id", "environment"]

    @field_validator('klaviyo_sdk')
    def klaviyo_sdk_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['android', 'flutter_community', 'react_native', 'swift']):
            raise ValueError("must be one of enum values ('android', 'flutter_community', 'react_native', 'swift')")
        return value

    @field_validator('os_name')
    def os_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['android', 'ios', 'ipados', 'macos', 'tvos']):
            raise ValueError("must be one of enum values ('android', 'ios', 'ipados', 'macos', 'tvos')")
        return value

    @field_validator('environment')
    def environment_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['debug', 'release']):
            raise ValueError("must be one of enum values ('debug', 'release')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if device_id (nullable) is None
        # and model_fields_set contains the field
        if self.device_id is None and "device_id" in self.model_fields_set:
            _dict['device_id'] = None

        # set to None if klaviyo_sdk (nullable) is None
        # and model_fields_set contains the field
        if self.klaviyo_sdk is None and "klaviyo_sdk" in self.model_fields_set:
            _dict['klaviyo_sdk'] = None

        # set to None if sdk_version (nullable) is None
        # and model_fields_set contains the field
        if self.sdk_version is None and "sdk_version" in self.model_fields_set:
            _dict['sdk_version'] = None

        # set to None if device_model (nullable) is None
        # and model_fields_set contains the field
        if self.device_model is None and "device_model" in self.model_fields_set:
            _dict['device_model'] = None

        # set to None if os_name (nullable) is None
        # and model_fields_set contains the field
        if self.os_name is None and "os_name" in self.model_fields_set:
            _dict['os_name'] = None

        # set to None if os_version (nullable) is None
        # and model_fields_set contains the field
        if self.os_version is None and "os_version" in self.model_fields_set:
            _dict['os_version'] = None

        # set to None if manufacturer (nullable) is None
        # and model_fields_set contains the field
        if self.manufacturer is None and "manufacturer" in self.model_fields_set:
            _dict['manufacturer'] = None

        # set to None if app_name (nullable) is None
        # and model_fields_set contains the field
        if self.app_name is None and "app_name" in self.model_fields_set:
            _dict['app_name'] = None

        # set to None if app_version (nullable) is None
        # and model_fields_set contains the field
        if self.app_version is None and "app_version" in self.model_fields_set:
            _dict['app_version'] = None

        # set to None if app_build (nullable) is None
        # and model_fields_set contains the field
        if self.app_build is None and "app_build" in self.model_fields_set:
            _dict['app_build'] = None

        # set to None if app_id (nullable) is None
        # and model_fields_set contains the field
        if self.app_id is None and "app_id" in self.model_fields_set:
            _dict['app_id'] = None

        # set to None if environment (nullable) is None
        # and model_fields_set contains the field
        if self.environment is None and "environment" in self.model_fields_set:
            _dict['environment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "device_id": obj.get("device_id"),
            "klaviyo_sdk": obj.get("klaviyo_sdk"),
            "sdk_version": obj.get("sdk_version"),
            "device_model": obj.get("device_model"),
            "os_name": obj.get("os_name"),
            "os_version": obj.get("os_version"),
            "manufacturer": obj.get("manufacturer"),
            "app_name": obj.get("app_name"),
            "app_version": obj.get("app_version"),
            "app_build": obj.get("app_build"),
            "app_id": obj.get("app_id"),
            "environment": obj.get("environment")
        })
        return _obj


