# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.custom_metric_condition import CustomMetricCondition
from typing import Optional, Set
from typing_extensions import Self

class CustomMetricGroup(BaseModel):
    """
    CustomMetricGroup
    """ # noqa: E501
    metric_id: StrictStr = Field(description="The ID of the metric that composes the custom metric.")
    metric_filters: Optional[List[CustomMetricCondition]] = Field(default=None, description="An optional array of objects for filtering on properties of the metric.")
    value_property: Optional[StrictStr] = Field(default=None, description=" If the custom metric has a `value` aggregation method, the `value_property` of each `metric_group` of the `definition` should specify the property to calculate the conversion value. If null, the default `$value` property will be used. ")
    __properties: ClassVar[List[str]] = ["metric_id", "metric_filters", "value_property"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomMetricGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in metric_filters (list)
        _items = []
        if self.metric_filters:
            for _item in self.metric_filters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['metric_filters'] = _items
        # set to None if metric_filters (nullable) is None
        # and model_fields_set contains the field
        if self.metric_filters is None and "metric_filters" in self.model_fields_set:
            _dict['metric_filters'] = None

        # set to None if value_property (nullable) is None
        # and model_fields_set contains the field
        if self.value_property is None and "value_property" in self.model_fields_set:
            _dict['value_property'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomMetricGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metric_id": obj.get("metric_id"),
            "metric_filters": [CustomMetricCondition.from_dict(_item) for _item in obj["metric_filters"]] if obj.get("metric_filters") is not None else None,
            "value_property": obj.get("value_property")
        })
        return _obj


