# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CatalogItemCreateQueryResourceObjectAttributes(BaseModel):
    """
    CatalogItemCreateQueryResourceObjectAttributes
    """ # noqa: E501
    external_id: StrictStr = Field(description="The ID of the catalog item in an external system.")
    integration_type: Optional[StrictStr] = Field(default='$custom', description="The integration type. Currently only \"$custom\" is supported.")
    title: StrictStr = Field(description="The title of the catalog item.")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="This field can be used to set the price on the catalog item, which is what gets displayed for the item when included in emails. For most price-update use cases, you will also want to update the `price` on any child variants, using the [Update Catalog Variant Endpoint](https://developers.klaviyo.com/en/reference/update_catalog_variant).")
    catalog_type: Optional[StrictStr] = Field(default='$default', description="The type of catalog. Currently only \"$default\" is supported.")
    description: StrictStr = Field(description="A description of the catalog item.")
    url: StrictStr = Field(description="URL pointing to the location of the catalog item on your website.")
    image_full_url: Optional[StrictStr] = Field(default=None, description="URL pointing to the location of a full image of the catalog item.")
    image_thumbnail_url: Optional[StrictStr] = Field(default=None, description="URL pointing to the location of an image thumbnail of the catalog item")
    images: Optional[List[StrictStr]] = Field(default=None, description="List of URLs pointing to the locations of images of the catalog item.")
    custom_metadata: Optional[Dict[str, Any]] = Field(default=None, description="Flat JSON blob to provide custom metadata about the catalog item. May not exceed 100kb.")
    published: Optional[StrictBool] = Field(default=True, description="Boolean value indicating whether the catalog item is published.")
    __properties: ClassVar[List[str]] = ["external_id", "integration_type", "title", "price", "catalog_type", "description", "url", "image_full_url", "image_thumbnail_url", "images", "custom_metadata", "published"]

    @field_validator('integration_type')
    def integration_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['$custom']):
            raise ValueError("must be one of enum values ('$custom')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CatalogItemCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if integration_type (nullable) is None
        # and model_fields_set contains the field
        if self.integration_type is None and "integration_type" in self.model_fields_set:
            _dict['integration_type'] = None

        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if catalog_type (nullable) is None
        # and model_fields_set contains the field
        if self.catalog_type is None and "catalog_type" in self.model_fields_set:
            _dict['catalog_type'] = None

        # set to None if image_full_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_full_url is None and "image_full_url" in self.model_fields_set:
            _dict['image_full_url'] = None

        # set to None if image_thumbnail_url (nullable) is None
        # and model_fields_set contains the field
        if self.image_thumbnail_url is None and "image_thumbnail_url" in self.model_fields_set:
            _dict['image_thumbnail_url'] = None

        # set to None if images (nullable) is None
        # and model_fields_set contains the field
        if self.images is None and "images" in self.model_fields_set:
            _dict['images'] = None

        # set to None if custom_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.custom_metadata is None and "custom_metadata" in self.model_fields_set:
            _dict['custom_metadata'] = None

        # set to None if published (nullable) is None
        # and model_fields_set contains the field
        if self.published is None and "published" in self.model_fields_set:
            _dict['published'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CatalogItemCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "external_id": obj.get("external_id"),
            "integration_type": obj.get("integration_type") if obj.get("integration_type") is not None else '$custom',
            "title": obj.get("title"),
            "price": obj.get("price"),
            "catalog_type": obj.get("catalog_type") if obj.get("catalog_type") is not None else '$default',
            "description": obj.get("description"),
            "url": obj.get("url"),
            "image_full_url": obj.get("image_full_url"),
            "image_thumbnail_url": obj.get("image_thumbnail_url"),
            "images": obj.get("images"),
            "custom_metadata": obj.get("custom_metadata"),
            "published": obj.get("published") if obj.get("published") is not None else True
        })
        return _obj


