# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Set, Tuple, Union
from typing_extensions import Annotated

import inspect

from enum import EnumMeta

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from openapi_client.models.custom_metric_create_query import CustomMetricCreateQuery
from openapi_client.models.custom_metric_partial_update_query import CustomMetricPartialUpdateQuery
from openapi_client.models.get_custom_metric_metrics_relationships_response_collection import GetCustomMetricMetricsRelationshipsResponseCollection
from openapi_client.models.get_custom_metric_response import GetCustomMetricResponse
from openapi_client.models.get_custom_metric_response_collection_compound_document import GetCustomMetricResponseCollectionCompoundDocument
from openapi_client.models.get_custom_metric_response_compound_document import GetCustomMetricResponseCompoundDocument
from openapi_client.models.get_flow_response_collection import GetFlowResponseCollection
from openapi_client.models.get_mapped_metric_custom_metric_relationship_response import GetMappedMetricCustomMetricRelationshipResponse
from openapi_client.models.get_mapped_metric_metric_relationship_response import GetMappedMetricMetricRelationshipResponse
from openapi_client.models.get_mapped_metric_response_collection_compound_document import GetMappedMetricResponseCollectionCompoundDocument
from openapi_client.models.get_mapped_metric_response_compound_document import GetMappedMetricResponseCompoundDocument
from openapi_client.models.get_metric_flow_triggers_relationships_response_collection import GetMetricFlowTriggersRelationshipsResponseCollection
from openapi_client.models.get_metric_properties_relationships_response_collection import GetMetricPropertiesRelationshipsResponseCollection
from openapi_client.models.get_metric_property_metric_relationship_response import GetMetricPropertyMetricRelationshipResponse
from openapi_client.models.get_metric_property_response_collection import GetMetricPropertyResponseCollection
from openapi_client.models.get_metric_property_response_compound_document import GetMetricPropertyResponseCompoundDocument
from openapi_client.models.get_metric_response import GetMetricResponse
from openapi_client.models.get_metric_response_collection import GetMetricResponseCollection
from openapi_client.models.get_metric_response_collection_compound_document import GetMetricResponseCollectionCompoundDocument
from openapi_client.models.get_metric_response_compound_document import GetMetricResponseCompoundDocument
from openapi_client.models.mapped_metric_partial_update_query import MappedMetricPartialUpdateQuery
from openapi_client.models.metric_aggregate_query import MetricAggregateQuery
from openapi_client.models.patch_custom_metric_response import PatchCustomMetricResponse
from openapi_client.models.patch_mapped_metric_response import PatchMappedMetricResponse
from openapi_client.models.post_custom_metric_response import PostCustomMetricResponse
from openapi_client.models.post_metric_aggregate_response import PostMetricAggregateResponse

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType
from openapi_client.api_arg_options import USE_DICTIONARY_FOR_RESPONSE_DATA


class MetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_custom_metric(        
        self,
        custom_metric_create_query: Annotated[CustomMetricCreateQuery, Field(description="Create a custom metric.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCustomMetricResponse, Dict[str, object]]:
        """Create Custom Metric

        Create a new custom metric.  Custom metric objects must include a `name` and `definition`.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param custom_metric_create_query: Create a custom metric. (required)
        :type custom_metric_create_query: CustomMetricCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_metric_serialize(
            custom_metric_create_query=custom_metric_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def create_custom_metric_with_http_info(        
        self,
        custom_metric_create_query: Annotated[CustomMetricCreateQuery, Field(description="Create a custom metric.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCustomMetricResponse]:
        """Create Custom Metric

        Create a new custom metric.  Custom metric objects must include a `name` and `definition`.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param custom_metric_create_query: Create a custom metric. (required)
        :type custom_metric_create_query: CustomMetricCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_metric_serialize(
            custom_metric_create_query=custom_metric_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_custom_metric_without_preload_content(
        self,
        custom_metric_create_query: Annotated[CustomMetricCreateQuery, Field(description="Create a custom metric.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Create Custom Metric

        Create a new custom metric.  Custom metric objects must include a `name` and `definition`.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param custom_metric_create_query: Create a custom metric. (required)
        :type custom_metric_create_query: CustomMetricCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_custom_metric_serialize(
            custom_metric_create_query=custom_metric_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _create_custom_metric_serialize(
        self,
        custom_metric_create_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if custom_metric_create_query is not None:
            _body_params = custom_metric_create_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/custom-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_custom_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> None:
        """Delete Custom Metric

        Delete a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def delete_custom_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[None]:
        """Delete Custom Metric

        Delete a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_custom_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Delete Custom Metric

        Delete a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _delete_custom_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/custom-metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_custom_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCustomMetricResponseCompoundDocument, Dict[str, object]]:
        """Get Custom Metric

        Get a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_custom_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCustomMetricResponseCompoundDocument]:
        """Get Custom Metric

        Get a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_custom_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Custom Metric

        Get a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_custom_metric_serialize(
        self,
        id,
        fields_custom_metric,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[custom-metric]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_custom_metric is not None:
            
            if isinstance(fields_custom_metric, EnumMeta):
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            else:
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/custom-metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_custom_metric_for_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCustomMetricResponse, Dict[str, object]]:
        """Get Custom Metric for Mapped Metric

        Get the custom metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_for_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_custom_metric_for_mapped_metric
    get_mapped_metric_custom_metric = get_custom_metric_for_mapped_metric

    @validate_call
    def get_custom_metric_for_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCustomMetricResponse]:
        """Get Custom Metric for Mapped Metric

        Get the custom metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_for_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_custom_metric_for_mapped_metric_with_http_info`
    get_mapped_metric_custom_metric_with_http_info = get_custom_metric_for_mapped_metric_with_http_info

    @validate_call
    def get_custom_metric_for_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Custom Metric for Mapped Metric

        Get the custom metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_for_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_custom_metric_for_mapped_metric_without_preload_content`
    get_mapped_metric_custom_metric_without_preload_content = get_custom_metric_for_mapped_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_custom_metric_for_mapped_metric_serialize(
        self,
        id,
        fields_custom_metric,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[custom-metric]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_custom_metric is not None:
            
            if isinstance(fields_custom_metric, EnumMeta):
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            else:
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics/{id}/custom-metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_custom_metric_for_mapped_metric_serialize`
    _get_mapped_metric_custom_metric_serialize = _get_custom_metric_for_mapped_metric_serialize



    @validate_call
    def get_custom_metric_id_for_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMappedMetricCustomMetricRelationshipResponse, Dict[str, object]]:
        """Get Custom Metric ID for Mapped Metric

        Get the ID of the custom metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricCustomMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_custom_metric_id_for_mapped_metric
    get_mapped_metric_relationships_custom_metric = get_custom_metric_id_for_mapped_metric

    @validate_call
    def get_custom_metric_id_for_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMappedMetricCustomMetricRelationshipResponse]:
        """Get Custom Metric ID for Mapped Metric

        Get the ID of the custom metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricCustomMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_custom_metric_id_for_mapped_metric_with_http_info`
    get_mapped_metric_relationships_custom_metric_with_http_info = get_custom_metric_id_for_mapped_metric_with_http_info

    @validate_call
    def get_custom_metric_id_for_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Custom Metric ID for Mapped Metric

        Get the ID of the custom metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricCustomMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_custom_metric_id_for_mapped_metric_without_preload_content`
    get_mapped_metric_relationships_custom_metric_without_preload_content = get_custom_metric_id_for_mapped_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_custom_metric_id_for_mapped_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics/{id}/relationships/custom-metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_custom_metric_id_for_mapped_metric_serialize`
    _get_mapped_metric_relationships_custom_metric_serialize = _get_custom_metric_id_for_mapped_metric_serialize



    @validate_call
    def get_custom_metrics(        
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCustomMetricResponseCollectionCompoundDocument, Dict[str, object]]:
        """Get Custom Metrics

        Get all custom metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_custom_metrics_with_http_info(        
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCustomMetricResponseCollectionCompoundDocument]:
        """Get Custom Metrics

        Get all custom metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_custom_metrics_without_preload_content(
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Custom Metrics

        Get all custom metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_custom_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_custom_metrics_serialize(
        self,
        fields_custom_metric,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[custom-metric]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if fields_custom_metric is not None:
            
            if isinstance(fields_custom_metric, EnumMeta):
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            else:
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/custom-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_flows_triggered_by_metric(        
        self,
        id: StrictStr,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetFlowResponseCollection, Dict[str, object]]:
        """Get Flows Triggered by Metric

        Get all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_flows_triggered_by_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFlowResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_flows_triggered_by_metric
    get_flow_triggers_for_metric = get_flows_triggered_by_metric

    # alias of get_flows_triggered_by_metric
    get_metric_flow_triggers = get_flows_triggered_by_metric

    @validate_call
    def get_flows_triggered_by_metric_with_http_info(        
        self,
        id: StrictStr,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetFlowResponseCollection]:
        """Get Flows Triggered by Metric

        Get all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_flows_triggered_by_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFlowResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_flows_triggered_by_metric_with_http_info`
    get_flow_triggers_for_metric_with_http_info = get_flows_triggered_by_metric_with_http_info

    # alias of `get_flows_triggered_by_metric_with_http_info`
    get_metric_flow_triggers_with_http_info = get_flows_triggered_by_metric_with_http_info

    @validate_call
    def get_flows_triggered_by_metric_without_preload_content(
        self,
        id: StrictStr,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Flows Triggered by Metric

        Get all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_flows_triggered_by_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFlowResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_flows_triggered_by_metric_without_preload_content`
    get_flow_triggers_for_metric_without_preload_content = get_flows_triggered_by_metric_without_preload_content

    # alias of `get_flows_triggered_by_metric_without_preload_content`
    get_metric_flow_triggers_without_preload_content = get_flows_triggered_by_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_flows_triggered_by_metric_serialize(
        self,
        id,
        fields_flow,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[flow]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_flow is not None:
            
            if isinstance(fields_flow, EnumMeta):
                _query_params.append(('fields[flow]', fields_flow))
            else:
                _query_params.append(('fields[flow]', fields_flow))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics/{id}/flow-triggers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_flows_triggered_by_metric_serialize`
    _get_flow_triggers_for_metric_serialize = _get_flows_triggered_by_metric_serialize

    # alias of `_get_flows_triggered_by_metric_serialize`
    _get_metric_flow_triggers_serialize = _get_flows_triggered_by_metric_serialize



    @validate_call
    def get_ids_for_flows_triggered_by_metric(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricFlowTriggersRelationshipsResponseCollection, Dict[str, object]]:
        """Get IDs for Flows Triggered by Metric

        Get the IDs of all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ids_for_flows_triggered_by_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricFlowTriggersRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_ids_for_flows_triggered_by_metric
    get_flow_trigger_ids_for_metric = get_ids_for_flows_triggered_by_metric

    # alias of get_ids_for_flows_triggered_by_metric
    get_metric_relationships_flow_triggers = get_ids_for_flows_triggered_by_metric

    @validate_call
    def get_ids_for_flows_triggered_by_metric_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricFlowTriggersRelationshipsResponseCollection]:
        """Get IDs for Flows Triggered by Metric

        Get the IDs of all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ids_for_flows_triggered_by_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricFlowTriggersRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_ids_for_flows_triggered_by_metric_with_http_info`
    get_flow_trigger_ids_for_metric_with_http_info = get_ids_for_flows_triggered_by_metric_with_http_info

    # alias of `get_ids_for_flows_triggered_by_metric_with_http_info`
    get_metric_relationships_flow_triggers_with_http_info = get_ids_for_flows_triggered_by_metric_with_http_info

    @validate_call
    def get_ids_for_flows_triggered_by_metric_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get IDs for Flows Triggered by Metric

        Get the IDs of all flows where the given metric is being used as the trigger.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `flows:read` `metrics:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_ids_for_flows_triggered_by_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricFlowTriggersRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_ids_for_flows_triggered_by_metric_without_preload_content`
    get_flow_trigger_ids_for_metric_without_preload_content = get_ids_for_flows_triggered_by_metric_without_preload_content

    # alias of `get_ids_for_flows_triggered_by_metric_without_preload_content`
    get_metric_relationships_flow_triggers_without_preload_content = get_ids_for_flows_triggered_by_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_ids_for_flows_triggered_by_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics/{id}/relationships/flow-triggers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_ids_for_flows_triggered_by_metric_serialize`
    _get_flow_trigger_ids_for_metric_serialize = _get_ids_for_flows_triggered_by_metric_serialize

    # alias of `_get_ids_for_flows_triggered_by_metric_serialize`
    _get_metric_relationships_flow_triggers_serialize = _get_ids_for_flows_triggered_by_metric_serialize



    @validate_call
    def get_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMappedMetricResponseCompoundDocument, Dict[str, object]]:
        """Get Mapped Metric

        Get the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMappedMetricResponseCompoundDocument]:
        """Get Mapped Metric

        Get the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Mapped Metric

        Get the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metric_serialize(
            id=id,
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_mapped_metric_serialize(
        self,
        id,
        fields_custom_metric,
        fields_mapped_metric,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[custom-metric]': 'csv',
            'fields[mapped-metric]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_custom_metric is not None:
            
            if isinstance(fields_custom_metric, EnumMeta):
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            else:
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            
        if fields_mapped_metric is not None:
            
            if isinstance(fields_mapped_metric, EnumMeta):
                _query_params.append(('fields[mapped-metric]', fields_mapped_metric))
            else:
                _query_params.append(('fields[mapped-metric]', fields_mapped_metric))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_mapped_metrics(        
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMappedMetricResponseCollectionCompoundDocument, Dict[str, object]]:
        """Get Mapped Metrics

        Get all mapped metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_mapped_metrics_with_http_info(        
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMappedMetricResponseCollectionCompoundDocument]:
        """Get Mapped Metrics

        Get all mapped metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_mapped_metrics_without_preload_content(
        self,
        fields_custom_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_mapped_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Mapped Metrics

        Get all mapped metrics in an account.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param fields_custom_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_custom_metric: List[str]
        :param fields_mapped_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_mapped_metric: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_mapped_metrics_serialize(
            fields_custom_metric=fields_custom_metric,
            fields_mapped_metric=fields_mapped_metric,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_mapped_metrics_serialize(
        self,
        fields_custom_metric,
        fields_mapped_metric,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[custom-metric]': 'csv',
            'fields[mapped-metric]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if fields_custom_metric is not None:
            
            if isinstance(fields_custom_metric, EnumMeta):
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            else:
                _query_params.append(('fields[custom-metric]', fields_custom_metric))
            
        if fields_mapped_metric is not None:
            
            if isinstance(fields_mapped_metric, EnumMeta):
                _query_params.append(('fields[mapped-metric]', fields_mapped_metric))
            else:
                _query_params.append(('fields[mapped-metric]', fields_mapped_metric))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_metric(        
        self,
        id: Annotated[StrictStr, Field(description="Metric ID")],
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricResponseCompoundDocument, Dict[str, object]]:
        """Get Metric

        Get a metric with the given metric ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param id: Metric ID (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="Metric ID")],
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricResponseCompoundDocument]:
        """Get Metric

        Get a metric with the given metric ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param id: Metric ID (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Metric ID")],
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric

        Get a metric with the given metric ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param id: Metric ID (required)
        :type id: str
        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_serialize(
            id=id,
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_serialize(
        self,
        id,
        fields_flow,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[flow]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_flow is not None:
            
            if isinstance(fields_flow, EnumMeta):
                _query_params.append(('fields[flow]', fields_flow))
            else:
                _query_params.append(('fields[flow]', fields_flow))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_metric_for_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricResponse, Dict[str, object]]:
        """Get Metric for Mapped Metric

        Get the metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_mapped_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metric_for_mapped_metric
    get_mapped_metric_metric = get_metric_for_mapped_metric

    @validate_call
    def get_metric_for_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricResponse]:
        """Get Metric for Mapped Metric

        Get the metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_mapped_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metric_for_mapped_metric_with_http_info`
    get_mapped_metric_metric_with_http_info = get_metric_for_mapped_metric_with_http_info

    @validate_call
    def get_metric_for_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric for Mapped Metric

        Get the metric for the given mapped metric ID (if applicable).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_mapped_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metric_for_mapped_metric_without_preload_content`
    get_mapped_metric_metric_without_preload_content = get_metric_for_mapped_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_for_mapped_metric_serialize(
        self,
        id,
        fields_metric,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[metric]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics/{id}/metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metric_for_mapped_metric_serialize`
    _get_mapped_metric_metric_serialize = _get_metric_for_mapped_metric_serialize



    @validate_call
    def get_metric_for_metric_property(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricResponse, Dict[str, object]]:
        """Get Metric for Metric Property

        Get the metric for the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_metric_property_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metric_for_metric_property
    get_metric_property_metric = get_metric_for_metric_property

    @validate_call
    def get_metric_for_metric_property_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricResponse]:
        """Get Metric for Metric Property

        Get the metric for the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_metric_property_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metric_for_metric_property_with_http_info`
    get_metric_property_metric_with_http_info = get_metric_for_metric_property_with_http_info

    @validate_call
    def get_metric_for_metric_property_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric for Metric Property

        Get the metric for the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_for_metric_property_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metric_for_metric_property_without_preload_content`
    get_metric_property_metric_without_preload_content = get_metric_for_metric_property_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_for_metric_property_serialize(
        self,
        id,
        fields_metric,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[metric]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metric-properties/{id}/metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metric_for_metric_property_serialize`
    _get_metric_property_metric_serialize = _get_metric_for_metric_property_serialize



    @validate_call
    def get_metric_id_for_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMappedMetricMetricRelationshipResponse, Dict[str, object]]:
        """Get Metric ID for Mapped Metric

        Get the ID of the metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metric_id_for_mapped_metric
    get_mapped_metric_relationships_metric = get_metric_id_for_mapped_metric

    @validate_call
    def get_metric_id_for_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMappedMetricMetricRelationshipResponse]:
        """Get Metric ID for Mapped Metric

        Get the ID of the metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metric_id_for_mapped_metric_with_http_info`
    get_mapped_metric_relationships_metric_with_http_info = get_metric_id_for_mapped_metric_with_http_info

    @validate_call
    def get_metric_id_for_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric ID for Mapped Metric

        Get the ID of the metric for the given mapped metric.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The type of mapping. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_mapped_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMappedMetricMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metric_id_for_mapped_metric_without_preload_content`
    get_mapped_metric_relationships_metric_without_preload_content = get_metric_id_for_mapped_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_id_for_mapped_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/mapped-metrics/{id}/relationships/metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metric_id_for_mapped_metric_serialize`
    _get_mapped_metric_relationships_metric_serialize = _get_metric_id_for_mapped_metric_serialize



    @validate_call
    def get_metric_id_for_metric_property(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricPropertyMetricRelationshipResponse, Dict[str, object]]:
        """Get Metric ID for Metric Property

        Get the ID of the metric for the given metric property.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_metric_property_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metric_id_for_metric_property
    get_metric_property_relationships_metric = get_metric_id_for_metric_property

    @validate_call
    def get_metric_id_for_metric_property_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricPropertyMetricRelationshipResponse]:
        """Get Metric ID for Metric Property

        Get the ID of the metric for the given metric property.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_metric_property_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metric_id_for_metric_property_with_http_info`
    get_metric_property_relationships_metric_with_http_info = get_metric_id_for_metric_property_with_http_info

    @validate_call
    def get_metric_id_for_metric_property_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric ID for Metric Property

        Get the ID of the metric for the given metric property.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_id_for_metric_property_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyMetricRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metric_id_for_metric_property_without_preload_content`
    get_metric_property_relationships_metric_without_preload_content = get_metric_id_for_metric_property_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_id_for_metric_property_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metric-properties/{id}/relationships/metric',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metric_id_for_metric_property_serialize`
    _get_metric_property_relationships_metric_serialize = _get_metric_id_for_metric_property_serialize



    @validate_call
    def get_metric_ids_for_custom_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCustomMetricMetricsRelationshipsResponseCollection, Dict[str, object]]:
        """Get Metric IDs for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_ids_for_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricMetricsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metric_ids_for_custom_metric
    get_custom_metric_relationships_metrics = get_metric_ids_for_custom_metric

    @validate_call
    def get_metric_ids_for_custom_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCustomMetricMetricsRelationshipsResponseCollection]:
        """Get Metric IDs for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_ids_for_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricMetricsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metric_ids_for_custom_metric_with_http_info`
    get_custom_metric_relationships_metrics_with_http_info = get_metric_ids_for_custom_metric_with_http_info

    @validate_call
    def get_metric_ids_for_custom_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric IDs for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_ids_for_custom_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCustomMetricMetricsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metric_ids_for_custom_metric_without_preload_content`
    get_custom_metric_relationships_metrics_without_preload_content = get_metric_ids_for_custom_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_ids_for_custom_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/custom-metrics/{id}/relationships/metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metric_ids_for_custom_metric_serialize`
    _get_custom_metric_relationships_metrics_serialize = _get_metric_ids_for_custom_metric_serialize



    @validate_call
    def get_metric_property(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricPropertyResponseCompoundDocument, Dict[str, object]]:
        """Get Metric Property

        Get a metric property with the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_property_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_metric_property_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricPropertyResponseCompoundDocument]:
        """Get Metric Property

        Get a metric property with the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_property_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_metric_property_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric property")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metric Property

        Get a metric property with the given metric property ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric property (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metric_property_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            fields_metric=fields_metric,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metric_property_serialize(
        self,
        id,
        additional_fields_metric_property,
        fields_metric_property,
        fields_metric,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'additional-fields[metric-property]': 'csv',
            'fields[metric-property]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if additional_fields_metric_property is not None:
            
            if isinstance(additional_fields_metric_property, EnumMeta):
                _query_params.append(('additional-fields[metric-property]', additional_fields_metric_property))
            else:
                _query_params.append(('additional-fields[metric-property]', additional_fields_metric_property))
            
        if fields_metric_property is not None:
            
            if isinstance(fields_metric_property, EnumMeta):
                _query_params.append(('fields[metric-property]', fields_metric_property))
            else:
                _query_params.append(('fields[metric-property]', fields_metric_property))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metric-properties/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_metrics(        
        self,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricResponseCollectionCompoundDocument, Dict[str, object]]:
        """Get Metrics

        Get all metrics in an account.  Requests can be filtered by the following fields: integration `name`, integration `category`  Returns a maximum of 200 results per page.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`
        :type filter: str
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            filter=filter,
            include=include,
            page_cursor=page_cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_metrics_with_http_info(        
        self,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricResponseCollectionCompoundDocument]:
        """Get Metrics

        Get all metrics in an account.  Requests can be filtered by the following fields: integration `name`, integration `category`  Returns a maximum of 200 results per page.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`
        :type filter: str
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            filter=filter,
            include=include,
            page_cursor=page_cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_metrics_without_preload_content(
        self,
        fields_flow: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metrics

        Get all metrics in an account.  Requests can be filtered by the following fields: integration `name`, integration `category`  Returns a maximum of 200 results per page.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `metrics:read`

        :param fields_flow: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_flow: List[str]
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`integration.name`: `equals`<br>`integration.category`: `equals`
        :type filter: str
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_serialize(
            fields_flow=fields_flow,
            fields_metric=fields_metric,
            filter=filter,
            include=include,
            page_cursor=page_cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metrics_serialize(
        self,
        fields_flow,
        fields_metric,
        filter,
        include,
        page_cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[flow]': 'csv',
            'fields[metric]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if fields_flow is not None:
            
            if isinstance(fields_flow, EnumMeta):
                _query_params.append(('fields[flow]', fields_flow))
            else:
                _query_params.append(('fields[flow]', fields_flow))
            
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        if filter is not None:
            
            if isinstance(filter, EnumMeta):
                _query_params.append(('filter', filter))
            else:
                _query_params.append(('filter', filter))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        if page_cursor is not None:
            
            if isinstance(page_cursor, EnumMeta):
                _query_params.append(('page[cursor]', page_cursor))
            else:
                _query_params.append(('page[cursor]', page_cursor))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_metrics_for_custom_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricResponseCollection, Dict[str, object]]:
        """Get Metrics for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_for_custom_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_metrics_for_custom_metric
    get_custom_metric_metrics = get_metrics_for_custom_metric

    @validate_call
    def get_metrics_for_custom_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricResponseCollection]:
        """Get Metrics for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_for_custom_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_metrics_for_custom_metric_with_http_info`
    get_custom_metric_metrics_with_http_info = get_metrics_for_custom_metric_with_http_info

    @validate_call
    def get_metrics_for_custom_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        fields_metric: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Metrics for Custom Metric

        Get all metrics for the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param fields_metric: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_metrics_for_custom_metric_serialize(
            id=id,
            fields_metric=fields_metric,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_metrics_for_custom_metric_without_preload_content`
    get_custom_metric_metrics_without_preload_content = get_metrics_for_custom_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_metrics_for_custom_metric_serialize(
        self,
        id,
        fields_metric,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[metric]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_metric is not None:
            
            if isinstance(fields_metric, EnumMeta):
                _query_params.append(('fields[metric]', fields_metric))
            else:
                _query_params.append(('fields[metric]', fields_metric))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/custom-metrics/{id}/metrics',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_metrics_for_custom_metric_serialize`
    _get_custom_metric_metrics_serialize = _get_metrics_for_custom_metric_serialize



    @validate_call
    def get_properties_for_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricPropertyResponseCollection, Dict[str, object]]:
        """Get Properties for Metric

        Get the metric properties for the given metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_for_metric_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_properties_for_metric
    get_metric_metric_properties = get_properties_for_metric

    # alias of get_properties_for_metric
    get_metric_properties = get_properties_for_metric

    @validate_call
    def get_properties_for_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricPropertyResponseCollection]:
        """Get Properties for Metric

        Get the metric properties for the given metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_for_metric_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_properties_for_metric_with_http_info`
    get_metric_metric_properties_with_http_info = get_properties_for_metric_with_http_info

    # alias of `get_properties_for_metric_with_http_info`
    get_metric_properties_with_http_info = get_properties_for_metric_with_http_info

    @validate_call
    def get_properties_for_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        additional_fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="Request additional fields not included by default in the response. Supported values: 'sample_values'")] = None,
        fields_metric_property: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Properties for Metric

        Get the metric properties for the given metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param additional_fields_metric_property: Request additional fields not included by default in the response. Supported values: 'sample_values'
        :type additional_fields_metric_property: List[str]
        :param fields_metric_property: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_metric_property: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_properties_for_metric_serialize(
            id=id,
            additional_fields_metric_property=additional_fields_metric_property,
            fields_metric_property=fields_metric_property,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertyResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_properties_for_metric_without_preload_content`
    get_metric_metric_properties_without_preload_content = get_properties_for_metric_without_preload_content

    # alias of `get_properties_for_metric_without_preload_content`
    get_metric_properties_without_preload_content = get_properties_for_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_properties_for_metric_serialize(
        self,
        id,
        additional_fields_metric_property,
        fields_metric_property,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'additional-fields[metric-property]': 'csv',
            'fields[metric-property]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if additional_fields_metric_property is not None:
            
            if isinstance(additional_fields_metric_property, EnumMeta):
                _query_params.append(('additional-fields[metric-property]', additional_fields_metric_property))
            else:
                _query_params.append(('additional-fields[metric-property]', additional_fields_metric_property))
            
        if fields_metric_property is not None:
            
            if isinstance(fields_metric_property, EnumMeta):
                _query_params.append(('fields[metric-property]', fields_metric_property))
            else:
                _query_params.append(('fields[metric-property]', fields_metric_property))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics/{id}/metric-properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_properties_for_metric_serialize`
    _get_metric_metric_properties_serialize = _get_properties_for_metric_serialize

    # alias of `_get_properties_for_metric_serialize`
    _get_metric_properties_serialize = _get_properties_for_metric_serialize



    @validate_call
    def get_property_ids_for_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetMetricPropertiesRelationshipsResponseCollection, Dict[str, object]]:
        """Get Property IDs for Metric

        Get the IDs of metric properties for the given metric.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_property_ids_for_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertiesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_property_ids_for_metric
    get_metric_relationships_metric_properties = get_property_ids_for_metric

    # alias of get_property_ids_for_metric
    get_metric_relationships_properties = get_property_ids_for_metric

    @validate_call
    def get_property_ids_for_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetMetricPropertiesRelationshipsResponseCollection]:
        """Get Property IDs for Metric

        Get the IDs of metric properties for the given metric.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_property_ids_for_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertiesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_property_ids_for_metric_with_http_info`
    get_metric_relationships_metric_properties_with_http_info = get_property_ids_for_metric_with_http_info

    # alias of `get_property_ids_for_metric_with_http_info`
    get_metric_relationships_properties_with_http_info = get_property_ids_for_metric_with_http_info

    @validate_call
    def get_property_ids_for_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the metric")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Property IDs for Metric

        Get the IDs of metric properties for the given metric.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `metrics:read`

        :param id: The ID of the metric (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_property_ids_for_metric_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMetricPropertiesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_property_ids_for_metric_without_preload_content`
    get_metric_relationships_metric_properties_without_preload_content = get_property_ids_for_metric_without_preload_content

    # alias of `get_property_ids_for_metric_without_preload_content`
    get_metric_relationships_properties_without_preload_content = get_property_ids_for_metric_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_property_ids_for_metric_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/metrics/{id}/relationships/metric-properties',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_property_ids_for_metric_serialize`
    _get_metric_relationships_metric_properties_serialize = _get_property_ids_for_metric_serialize

    # alias of `_get_property_ids_for_metric_serialize`
    _get_metric_relationships_properties_serialize = _get_property_ids_for_metric_serialize



    @validate_call
    def query_metric_aggregates(        
        self,
        metric_aggregate_query: Annotated[MetricAggregateQuery, Field(description="Retrieve Metric Aggregations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostMetricAggregateResponse, Dict[str, object]]:
        """Query Metric Aggregates

        Query and aggregate event data associated with a metric, including native Klaviyo metrics, integration-specific metrics, and custom events (not to be confused with [custom metrics](https://developers.klaviyo.com/en/reference/custom_metrics_api_overview), which are not supported at this time). Queries must be passed in the JSON body of your `POST` request.  To request campaign and flow performance data that matches the data shown in Klaviyo's UI, we recommend the [Reporting API](https://developers.klaviyo.com/en/reference/reporting_api_overview).  Results can be filtered and grouped by time, event, or profile dimensions.  To learn more about how to use this endpoint, check out our new [Using the Query Metric Aggregates Endpoint guide](https://developers.klaviyo.com/en/docs/using-the-query-metric-aggregates-endpoint).  For a comprehensive list of request body parameters, native Klaviyo metrics, and their associated attributes for grouping and filtering, please refer to the [metrics attributes guide](https://developers.klaviyo.com/en/docs/supported_metrics_and_attributes).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param metric_aggregate_query: Retrieve Metric Aggregations (required)
        :type metric_aggregate_query: MetricAggregateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._query_metric_aggregates_serialize(
            metric_aggregate_query=metric_aggregate_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostMetricAggregateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of query_metric_aggregates
    create_metric_aggregate = query_metric_aggregates

    @validate_call
    def query_metric_aggregates_with_http_info(        
        self,
        metric_aggregate_query: Annotated[MetricAggregateQuery, Field(description="Retrieve Metric Aggregations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostMetricAggregateResponse]:
        """Query Metric Aggregates

        Query and aggregate event data associated with a metric, including native Klaviyo metrics, integration-specific metrics, and custom events (not to be confused with [custom metrics](https://developers.klaviyo.com/en/reference/custom_metrics_api_overview), which are not supported at this time). Queries must be passed in the JSON body of your `POST` request.  To request campaign and flow performance data that matches the data shown in Klaviyo's UI, we recommend the [Reporting API](https://developers.klaviyo.com/en/reference/reporting_api_overview).  Results can be filtered and grouped by time, event, or profile dimensions.  To learn more about how to use this endpoint, check out our new [Using the Query Metric Aggregates Endpoint guide](https://developers.klaviyo.com/en/docs/using-the-query-metric-aggregates-endpoint).  For a comprehensive list of request body parameters, native Klaviyo metrics, and their associated attributes for grouping and filtering, please refer to the [metrics attributes guide](https://developers.klaviyo.com/en/docs/supported_metrics_and_attributes).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param metric_aggregate_query: Retrieve Metric Aggregations (required)
        :type metric_aggregate_query: MetricAggregateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._query_metric_aggregates_serialize(
            metric_aggregate_query=metric_aggregate_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostMetricAggregateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `query_metric_aggregates_with_http_info`
    create_metric_aggregate_with_http_info = query_metric_aggregates_with_http_info

    @validate_call
    def query_metric_aggregates_without_preload_content(
        self,
        metric_aggregate_query: Annotated[MetricAggregateQuery, Field(description="Retrieve Metric Aggregations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Query Metric Aggregates

        Query and aggregate event data associated with a metric, including native Klaviyo metrics, integration-specific metrics, and custom events (not to be confused with [custom metrics](https://developers.klaviyo.com/en/reference/custom_metrics_api_overview), which are not supported at this time). Queries must be passed in the JSON body of your `POST` request.  To request campaign and flow performance data that matches the data shown in Klaviyo's UI, we recommend the [Reporting API](https://developers.klaviyo.com/en/reference/reporting_api_overview).  Results can be filtered and grouped by time, event, or profile dimensions.  To learn more about how to use this endpoint, check out our new [Using the Query Metric Aggregates Endpoint guide](https://developers.klaviyo.com/en/docs/using-the-query-metric-aggregates-endpoint).  For a comprehensive list of request body parameters, native Klaviyo metrics, and their associated attributes for grouping and filtering, please refer to the [metrics attributes guide](https://developers.klaviyo.com/en/docs/supported_metrics_and_attributes).<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `metrics:read`

        :param metric_aggregate_query: Retrieve Metric Aggregations (required)
        :type metric_aggregate_query: MetricAggregateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._query_metric_aggregates_serialize(
            metric_aggregate_query=metric_aggregate_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostMetricAggregateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `query_metric_aggregates_without_preload_content`
    create_metric_aggregate_without_preload_content = query_metric_aggregates_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _query_metric_aggregates_serialize(
        self,
        metric_aggregate_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if metric_aggregate_query is not None:
            _body_params = metric_aggregate_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/metric-aggregates',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_query_metric_aggregates_serialize`
    _create_metric_aggregate_serialize = _query_metric_aggregates_serialize



    @validate_call
    def update_custom_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        custom_metric_partial_update_query: Annotated[CustomMetricPartialUpdateQuery, Field(description="Update a custom metric by ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PatchCustomMetricResponse, Dict[str, object]]:
        """Update Custom Metric

        Update a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param custom_metric_partial_update_query: Update a custom metric by ID. (required)
        :type custom_metric_partial_update_query: CustomMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_custom_metric_serialize(
            id=id,
            custom_metric_partial_update_query=custom_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def update_custom_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        custom_metric_partial_update_query: Annotated[CustomMetricPartialUpdateQuery, Field(description="Update a custom metric by ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PatchCustomMetricResponse]:
        """Update Custom Metric

        Update a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param custom_metric_partial_update_query: Update a custom metric by ID. (required)
        :type custom_metric_partial_update_query: CustomMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_custom_metric_serialize(
            id=id,
            custom_metric_partial_update_query=custom_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_custom_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the custom metric")],
        custom_metric_partial_update_query: Annotated[CustomMetricPartialUpdateQuery, Field(description="Update a custom metric by ID.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Update Custom Metric

        Update a custom metric with the given custom metric ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `15/d`  **Scopes:** `metrics:write`

        :param id: The ID of the custom metric (required)
        :type id: str
        :param custom_metric_partial_update_query: Update a custom metric by ID. (required)
        :type custom_metric_partial_update_query: CustomMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_custom_metric_serialize(
            id=id,
            custom_metric_partial_update_query=custom_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCustomMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _update_custom_metric_serialize(
        self,
        id,
        custom_metric_partial_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if custom_metric_partial_update_query is not None:
            _body_params = custom_metric_partial_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/custom-metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_mapped_metric(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        mapped_metric_partial_update_query: Annotated[MappedMetricPartialUpdateQuery, Field(description="Update a mapped metric by ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PatchMappedMetricResponse, Dict[str, object]]:
        """Update Mapped Metric

        Update the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `30/d`  **Scopes:** `metrics:write`

        :param id: The type of mapping. (required)
        :type id: str
        :param mapped_metric_partial_update_query: Update a mapped metric by ID (required)
        :type mapped_metric_partial_update_query: MappedMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_mapped_metric_serialize(
            id=id,
            mapped_metric_partial_update_query=mapped_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchMappedMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def update_mapped_metric_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        mapped_metric_partial_update_query: Annotated[MappedMetricPartialUpdateQuery, Field(description="Update a mapped metric by ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PatchMappedMetricResponse]:
        """Update Mapped Metric

        Update the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `30/d`  **Scopes:** `metrics:write`

        :param id: The type of mapping. (required)
        :type id: str
        :param mapped_metric_partial_update_query: Update a mapped metric by ID (required)
        :type mapped_metric_partial_update_query: MappedMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_mapped_metric_serialize(
            id=id,
            mapped_metric_partial_update_query=mapped_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchMappedMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_mapped_metric_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The type of mapping.")],
        mapped_metric_partial_update_query: Annotated[MappedMetricPartialUpdateQuery, Field(description="Update a mapped metric by ID")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Update Mapped Metric

        Update the mapped metric with the given ID.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`<br>Daily: `30/d`  **Scopes:** `metrics:write`

        :param id: The type of mapping. (required)
        :type id: str
        :param mapped_metric_partial_update_query: Update a mapped metric by ID (required)
        :type mapped_metric_partial_update_query: MappedMetricPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_mapped_metric_serialize(
            id=id,
            mapped_metric_partial_update_query=mapped_metric_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchMappedMetricResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _update_mapped_metric_serialize(
        self,
        id,
        mapped_metric_partial_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if mapped_metric_partial_update_query is not None:
            _body_params = mapped_metric_partial_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/mapped-metrics/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


