# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Set, Tuple, Union
from typing_extensions import Annotated

import inspect

from enum import EnumMeta

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from openapi_client.models.campaign_clone_query import CampaignCloneQuery
from openapi_client.models.campaign_create_query import CampaignCreateQuery
from openapi_client.models.campaign_message_assign_template_query import CampaignMessageAssignTemplateQuery
from openapi_client.models.campaign_message_image_update_query import CampaignMessageImageUpdateQuery
from openapi_client.models.campaign_message_partial_update_query import CampaignMessagePartialUpdateQuery
from openapi_client.models.campaign_partial_update_query import CampaignPartialUpdateQuery
from openapi_client.models.campaign_recipient_estimation_job_create_query import CampaignRecipientEstimationJobCreateQuery
from openapi_client.models.campaign_send_job_create_query import CampaignSendJobCreateQuery
from openapi_client.models.campaign_send_job_partial_update_query import CampaignSendJobPartialUpdateQuery
from openapi_client.models.get_campaign_message_campaign_relationship_response import GetCampaignMessageCampaignRelationshipResponse
from openapi_client.models.get_campaign_message_image_relationship_response import GetCampaignMessageImageRelationshipResponse
from openapi_client.models.get_campaign_message_response_collection_compound_document import GetCampaignMessageResponseCollectionCompoundDocument
from openapi_client.models.get_campaign_message_response_compound_document import GetCampaignMessageResponseCompoundDocument
from openapi_client.models.get_campaign_message_template_relationship_response import GetCampaignMessageTemplateRelationshipResponse
from openapi_client.models.get_campaign_messages_relationships_response_collection import GetCampaignMessagesRelationshipsResponseCollection
from openapi_client.models.get_campaign_recipient_estimation_job_response import GetCampaignRecipientEstimationJobResponse
from openapi_client.models.get_campaign_recipient_estimation_response import GetCampaignRecipientEstimationResponse
from openapi_client.models.get_campaign_response import GetCampaignResponse
from openapi_client.models.get_campaign_response_collection_compound_document import GetCampaignResponseCollectionCompoundDocument
from openapi_client.models.get_campaign_response_compound_document import GetCampaignResponseCompoundDocument
from openapi_client.models.get_campaign_send_job_response import GetCampaignSendJobResponse
from openapi_client.models.get_campaign_tags_relationships_response_collection import GetCampaignTagsRelationshipsResponseCollection
from openapi_client.models.get_image_response import GetImageResponse
from openapi_client.models.get_tag_response_collection import GetTagResponseCollection
from openapi_client.models.get_template_response import GetTemplateResponse
from openapi_client.models.patch_campaign_message_response import PatchCampaignMessageResponse
from openapi_client.models.patch_campaign_response import PatchCampaignResponse
from openapi_client.models.post_campaign_message_response import PostCampaignMessageResponse
from openapi_client.models.post_campaign_recipient_estimation_job_response import PostCampaignRecipientEstimationJobResponse
from openapi_client.models.post_campaign_response import PostCampaignResponse
from openapi_client.models.post_campaign_send_job_response import PostCampaignSendJobResponse

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType
from openapi_client.api_arg_options import USE_DICTIONARY_FOR_RESPONSE_DATA


class CampaignsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def assign_template_to_campaign_message(        
        self,
        campaign_message_assign_template_query: Annotated[CampaignMessageAssignTemplateQuery, Field(description="Takes a reusable template, clones it, and assigns the non-reusable clone to the message.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCampaignMessageResponse, Dict[str, object]]:
        """Assign Template to Campaign Message

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_message_assign_template_query: Takes a reusable template, clones it, and assigns the non-reusable clone to the message. (required)
        :type campaign_message_assign_template_query: CampaignMessageAssignTemplateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assign_template_to_campaign_message_serialize(
            campaign_message_assign_template_query=campaign_message_assign_template_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of assign_template_to_campaign_message
    create_campaign_message_assign_template = assign_template_to_campaign_message

    @validate_call
    def assign_template_to_campaign_message_with_http_info(        
        self,
        campaign_message_assign_template_query: Annotated[CampaignMessageAssignTemplateQuery, Field(description="Takes a reusable template, clones it, and assigns the non-reusable clone to the message.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCampaignMessageResponse]:
        """Assign Template to Campaign Message

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_message_assign_template_query: Takes a reusable template, clones it, and assigns the non-reusable clone to the message. (required)
        :type campaign_message_assign_template_query: CampaignMessageAssignTemplateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assign_template_to_campaign_message_serialize(
            campaign_message_assign_template_query=campaign_message_assign_template_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `assign_template_to_campaign_message_with_http_info`
    create_campaign_message_assign_template_with_http_info = assign_template_to_campaign_message_with_http_info

    @validate_call
    def assign_template_to_campaign_message_without_preload_content(
        self,
        campaign_message_assign_template_query: Annotated[CampaignMessageAssignTemplateQuery, Field(description="Takes a reusable template, clones it, and assigns the non-reusable clone to the message.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Assign Template to Campaign Message

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_message_assign_template_query: Takes a reusable template, clones it, and assigns the non-reusable clone to the message. (required)
        :type campaign_message_assign_template_query: CampaignMessageAssignTemplateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._assign_template_to_campaign_message_serialize(
            campaign_message_assign_template_query=campaign_message_assign_template_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PostCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `assign_template_to_campaign_message_without_preload_content`
    create_campaign_message_assign_template_without_preload_content = assign_template_to_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _assign_template_to_campaign_message_serialize(
        self,
        campaign_message_assign_template_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_message_assign_template_query is not None:
            _body_params = campaign_message_assign_template_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/campaign-message-assign-template',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_assign_template_to_campaign_message_serialize`
    _create_campaign_message_assign_template_serialize = _assign_template_to_campaign_message_serialize



    @validate_call
    def cancel_campaign_send(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the currently sending campaign to cancel or revert")],
        campaign_send_job_partial_update_query: Annotated[CampaignSendJobPartialUpdateQuery, Field(description="Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> None:
        """Cancel Campaign Send

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The ID of the currently sending campaign to cancel or revert (required)
        :type id: str
        :param campaign_send_job_partial_update_query: Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT (required)
        :type campaign_send_job_partial_update_query: CampaignSendJobPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_campaign_send_serialize(
            id=id,
            campaign_send_job_partial_update_query=campaign_send_job_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of cancel_campaign_send
    update_campaign_send_job = cancel_campaign_send

    @validate_call
    def cancel_campaign_send_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the currently sending campaign to cancel or revert")],
        campaign_send_job_partial_update_query: Annotated[CampaignSendJobPartialUpdateQuery, Field(description="Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[None]:
        """Cancel Campaign Send

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The ID of the currently sending campaign to cancel or revert (required)
        :type id: str
        :param campaign_send_job_partial_update_query: Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT (required)
        :type campaign_send_job_partial_update_query: CampaignSendJobPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_campaign_send_serialize(
            id=id,
            campaign_send_job_partial_update_query=campaign_send_job_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `cancel_campaign_send_with_http_info`
    update_campaign_send_job_with_http_info = cancel_campaign_send_with_http_info

    @validate_call
    def cancel_campaign_send_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the currently sending campaign to cancel or revert")],
        campaign_send_job_partial_update_query: Annotated[CampaignSendJobPartialUpdateQuery, Field(description="Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Cancel Campaign Send

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The ID of the currently sending campaign to cancel or revert (required)
        :type id: str
        :param campaign_send_job_partial_update_query: Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT (required)
        :type campaign_send_job_partial_update_query: CampaignSendJobPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._cancel_campaign_send_serialize(
            id=id,
            campaign_send_job_partial_update_query=campaign_send_job_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `cancel_campaign_send_without_preload_content`
    update_campaign_send_job_without_preload_content = cancel_campaign_send_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _cancel_campaign_send_serialize(
        self,
        id,
        campaign_send_job_partial_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_send_job_partial_update_query is not None:
            _body_params = campaign_send_job_partial_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/campaign-send-jobs/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_cancel_campaign_send_serialize`
    _update_campaign_send_job_serialize = _cancel_campaign_send_serialize



    @validate_call
    def create_campaign(        
        self,
        campaign_create_query: Annotated[CampaignCreateQuery, Field(description="Creates a campaign from parameters")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCampaignResponse, Dict[str, object]]:
        """Create Campaign

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_create_query: Creates a campaign from parameters (required)
        :type campaign_create_query: CampaignCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_serialize(
            campaign_create_query=campaign_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def create_campaign_with_http_info(        
        self,
        campaign_create_query: Annotated[CampaignCreateQuery, Field(description="Creates a campaign from parameters")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCampaignResponse]:
        """Create Campaign

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_create_query: Creates a campaign from parameters (required)
        :type campaign_create_query: CampaignCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_serialize(
            campaign_create_query=campaign_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_campaign_without_preload_content(
        self,
        campaign_create_query: Annotated[CampaignCreateQuery, Field(description="Creates a campaign from parameters")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Create Campaign

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_create_query: Creates a campaign from parameters (required)
        :type campaign_create_query: CampaignCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_serialize(
            campaign_create_query=campaign_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _create_campaign_serialize(
        self,
        campaign_create_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_create_query is not None:
            _body_params = campaign_create_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/campaigns',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_campaign_clone(        
        self,
        campaign_clone_query: Annotated[CampaignCloneQuery, Field(description="Clones a campaign from an existing campaign")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCampaignResponse, Dict[str, object]]:
        """Create Campaign Clone

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_clone_query: Clones a campaign from an existing campaign (required)
        :type campaign_clone_query: CampaignCloneQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_clone_serialize(
            campaign_clone_query=campaign_clone_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of create_campaign_clone
    clone_campaign = create_campaign_clone

    @validate_call
    def create_campaign_clone_with_http_info(        
        self,
        campaign_clone_query: Annotated[CampaignCloneQuery, Field(description="Clones a campaign from an existing campaign")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCampaignResponse]:
        """Create Campaign Clone

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_clone_query: Clones a campaign from an existing campaign (required)
        :type campaign_clone_query: CampaignCloneQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_clone_serialize(
            campaign_clone_query=campaign_clone_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `create_campaign_clone_with_http_info`
    clone_campaign_with_http_info = create_campaign_clone_with_http_info

    @validate_call
    def create_campaign_clone_without_preload_content(
        self,
        campaign_clone_query: Annotated[CampaignCloneQuery, Field(description="Clones a campaign from an existing campaign")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Create Campaign Clone

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_clone_query: Clones a campaign from an existing campaign (required)
        :type campaign_clone_query: CampaignCloneQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_campaign_clone_serialize(
            campaign_clone_query=campaign_clone_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "PostCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `create_campaign_clone_without_preload_content`
    clone_campaign_without_preload_content = create_campaign_clone_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _create_campaign_clone_serialize(
        self,
        campaign_clone_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_clone_query is not None:
            _body_params = campaign_clone_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/campaign-clone',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_create_campaign_clone_serialize`
    _clone_campaign_serialize = _create_campaign_clone_serialize



    @validate_call
    def delete_campaign(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> None:
        """Delete Campaign

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be deleted (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def delete_campaign_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[None]:
        """Delete Campaign

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be deleted (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_campaign_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be deleted")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Delete Campaign

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be deleted (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _delete_campaign_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/campaigns/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaign(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignResponseCompoundDocument, Dict[str, object]]:
        """Get Campaign

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaign_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignResponseCompoundDocument]:
        """Get Campaign

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaign_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_serialize(
        self,
        id,
        fields_campaign_message,
        fields_campaign,
        fields_tag,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-message]': 'csv',
            'fields[campaign]': 'csv',
            'fields[tag]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_message is not None:
            
            if isinstance(fields_campaign_message, EnumMeta):
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            else:
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            
        if fields_campaign is not None:
            
            if isinstance(fields_campaign, EnumMeta):
                _query_params.append(('fields[campaign]', fields_campaign))
            else:
                _query_params.append(('fields[campaign]', fields_campaign))
            
        if fields_tag is not None:
            
            if isinstance(fields_tag, EnumMeta):
                _query_params.append(('fields[tag]', fields_tag))
            else:
                _query_params.append(('fields[tag]', fields_tag))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaign_for_campaign_message(        
        self,
        id: StrictStr,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignResponse, Dict[str, object]]:
        """Get Campaign for Campaign Message

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_for_campaign_message_serialize(
            id=id,
            fields_campaign=fields_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_campaign_for_campaign_message
    get_campaign_message_campaign = get_campaign_for_campaign_message

    @validate_call
    def get_campaign_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignResponse]:
        """Get Campaign for Campaign Message

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_for_campaign_message_serialize(
            id=id,
            fields_campaign=fields_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_campaign_for_campaign_message_with_http_info`
    get_campaign_message_campaign_with_http_info = get_campaign_for_campaign_message_with_http_info

    @validate_call
    def get_campaign_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign for Campaign Message

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_for_campaign_message_serialize(
            id=id,
            fields_campaign=fields_campaign,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_campaign_for_campaign_message_without_preload_content`
    get_campaign_message_campaign_without_preload_content = get_campaign_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_for_campaign_message_serialize(
        self,
        id,
        fields_campaign,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign is not None:
            
            if isinstance(fields_campaign, EnumMeta):
                _query_params.append(('fields[campaign]', fields_campaign))
            else:
                _query_params.append(('fields[campaign]', fields_campaign))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/campaign',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_campaign_for_campaign_message_serialize`
    _get_campaign_message_campaign_serialize = _get_campaign_for_campaign_message_serialize



    @validate_call
    def get_campaign_id_for_campaign_message(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessageCampaignRelationshipResponse, Dict[str, object]]:
        """Get Campaign ID for Campaign Message

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageCampaignRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_campaign_id_for_campaign_message
    get_campaign_message_relationships_campaign = get_campaign_id_for_campaign_message

    @validate_call
    def get_campaign_id_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessageCampaignRelationshipResponse]:
        """Get Campaign ID for Campaign Message

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageCampaignRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_campaign_id_for_campaign_message_with_http_info`
    get_campaign_message_relationships_campaign_with_http_info = get_campaign_id_for_campaign_message_with_http_info

    @validate_call
    def get_campaign_id_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign ID for Campaign Message

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageCampaignRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_campaign_id_for_campaign_message_without_preload_content`
    get_campaign_message_relationships_campaign_without_preload_content = get_campaign_id_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_id_for_campaign_message_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/relationships/campaign',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_campaign_id_for_campaign_message_serialize`
    _get_campaign_message_relationships_campaign_serialize = _get_campaign_id_for_campaign_message_serialize



    @validate_call
    def get_campaign_message(        
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessageResponseCompoundDocument, Dict[str, object]]:
        """Get Campaign Message

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_message_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaign_message_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessageResponseCompoundDocument]:
        """Get Campaign Message

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_message_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaign_message_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign Message

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_message_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_message_serialize(
        self,
        id,
        fields_campaign_message,
        fields_campaign,
        fields_image,
        fields_template,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-message]': 'csv',
            'fields[campaign]': 'csv',
            'fields[image]': 'csv',
            'fields[template]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_message is not None:
            
            if isinstance(fields_campaign_message, EnumMeta):
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            else:
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            
        if fields_campaign is not None:
            
            if isinstance(fields_campaign, EnumMeta):
                _query_params.append(('fields[campaign]', fields_campaign))
            else:
                _query_params.append(('fields[campaign]', fields_campaign))
            
        if fields_image is not None:
            
            if isinstance(fields_image, EnumMeta):
                _query_params.append(('fields[image]', fields_image))
            else:
                _query_params.append(('fields[image]', fields_image))
            
        if fields_template is not None:
            
            if isinstance(fields_template, EnumMeta):
                _query_params.append(('fields[template]', fields_template))
            else:
                _query_params.append(('fields[template]', fields_template))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaign_recipient_estimation(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign for which to get the estimated number of recipients")],
        fields_campaign_recipient_estimation: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignRecipientEstimationResponse, Dict[str, object]]:
        """Get Campaign Recipient Estimation

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign for which to get the estimated number of recipients (required)
        :type id: str
        :param fields_campaign_recipient_estimation: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_serialize(
            id=id,
            fields_campaign_recipient_estimation=fields_campaign_recipient_estimation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaign_recipient_estimation_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign for which to get the estimated number of recipients")],
        fields_campaign_recipient_estimation: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignRecipientEstimationResponse]:
        """Get Campaign Recipient Estimation

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign for which to get the estimated number of recipients (required)
        :type id: str
        :param fields_campaign_recipient_estimation: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_serialize(
            id=id,
            fields_campaign_recipient_estimation=fields_campaign_recipient_estimation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaign_recipient_estimation_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign for which to get the estimated number of recipients")],
        fields_campaign_recipient_estimation: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign Recipient Estimation

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign for which to get the estimated number of recipients (required)
        :type id: str
        :param fields_campaign_recipient_estimation: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_serialize(
            id=id,
            fields_campaign_recipient_estimation=fields_campaign_recipient_estimation,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_recipient_estimation_serialize(
        self,
        id,
        fields_campaign_recipient_estimation,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-recipient-estimation]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_recipient_estimation is not None:
            
            if isinstance(fields_campaign_recipient_estimation, EnumMeta):
                _query_params.append(('fields[campaign-recipient-estimation]', fields_campaign_recipient_estimation))
            else:
                _query_params.append(('fields[campaign-recipient-estimation]', fields_campaign_recipient_estimation))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-recipient-estimations/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaign_recipient_estimation_job(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to get recipient estimation status")],
        fields_campaign_recipient_estimation_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignRecipientEstimationJobResponse, Dict[str, object]]:
        """Get Campaign Recipient Estimation Job

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to get recipient estimation status (required)
        :type id: str
        :param fields_campaign_recipient_estimation_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_job_serialize(
            id=id,
            fields_campaign_recipient_estimation_job=fields_campaign_recipient_estimation_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaign_recipient_estimation_job_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to get recipient estimation status")],
        fields_campaign_recipient_estimation_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignRecipientEstimationJobResponse]:
        """Get Campaign Recipient Estimation Job

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to get recipient estimation status (required)
        :type id: str
        :param fields_campaign_recipient_estimation_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_job_serialize(
            id=id,
            fields_campaign_recipient_estimation_job=fields_campaign_recipient_estimation_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaign_recipient_estimation_job_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to get recipient estimation status")],
        fields_campaign_recipient_estimation_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign Recipient Estimation Job

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to get recipient estimation status (required)
        :type id: str
        :param fields_campaign_recipient_estimation_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_recipient_estimation_job_serialize(
            id=id,
            fields_campaign_recipient_estimation_job=fields_campaign_recipient_estimation_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_recipient_estimation_job_serialize(
        self,
        id,
        fields_campaign_recipient_estimation_job,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-recipient-estimation-job]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_recipient_estimation_job is not None:
            
            if isinstance(fields_campaign_recipient_estimation_job, EnumMeta):
                _query_params.append(('fields[campaign-recipient-estimation-job]', fields_campaign_recipient_estimation_job))
            else:
                _query_params.append(('fields[campaign-recipient-estimation-job]', fields_campaign_recipient_estimation_job))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-recipient-estimation-jobs/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaign_send_job(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to send")],
        fields_campaign_send_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignSendJobResponse, Dict[str, object]]:
        """Get Campaign Send Job

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to send (required)
        :type id: str
        :param fields_campaign_send_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_send_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_send_job_serialize(
            id=id,
            fields_campaign_send_job=fields_campaign_send_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaign_send_job_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to send")],
        fields_campaign_send_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignSendJobResponse]:
        """Get Campaign Send Job

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to send (required)
        :type id: str
        :param fields_campaign_send_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_send_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_send_job_serialize(
            id=id,
            fields_campaign_send_job=fields_campaign_send_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaign_send_job_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The ID of the campaign to send")],
        fields_campaign_send_job: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaign Send Job

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id: The ID of the campaign to send (required)
        :type id: str
        :param fields_campaign_send_job: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_send_job: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaign_send_job_serialize(
            id=id,
            fields_campaign_send_job=fields_campaign_send_job,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaign_send_job_serialize(
        self,
        id,
        fields_campaign_send_job,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-send-job]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_send_job is not None:
            
            if isinstance(fields_campaign_send_job, EnumMeta):
                _query_params.append(('fields[campaign-send-job]', fields_campaign_send_job))
            else:
                _query_params.append(('fields[campaign-send-job]', fields_campaign_send_job))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-send-jobs/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_campaigns(        
        self,
        filter: Annotated[StrictStr, Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignResponseCollectionCompoundDocument, Dict[str, object]]:
        """Get Campaigns

        Returns some or all campaigns based on filters.  A channel filter is required to list campaigns. Please provide either: `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns. `?filter=equals(messages.channel,'mobile_push')` to list mobile push campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than` (required)
        :type filter: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param sort: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaigns_serialize(
            filter=filter,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            page_cursor=page_cursor,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def get_campaigns_with_http_info(        
        self,
        filter: Annotated[StrictStr, Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignResponseCollectionCompoundDocument]:
        """Get Campaigns

        Returns some or all campaigns based on filters.  A channel filter is required to list campaigns. Please provide either: `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns. `?filter=equals(messages.channel,'mobile_push')` to list mobile push campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than` (required)
        :type filter: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param sort: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaigns_serialize(
            filter=filter,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            page_cursor=page_cursor,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_campaigns_without_preload_content(
        self,
        filter: Annotated[StrictStr, Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`")],
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        page_cursor: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Campaigns

        Returns some or all campaigns based on filters.  A channel filter is required to list campaigns. Please provide either: `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns. `?filter=equals(messages.channel,'mobile_push')` to list mobile push campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param filter: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than` (required)
        :type filter: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination
        :type page_cursor: str
        :param sort: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting
        :type sort: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_campaigns_serialize(
            filter=filter,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_tag=fields_tag,
            include=include,
            page_cursor=page_cursor,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_campaigns_serialize(
        self,
        filter,
        fields_campaign_message,
        fields_campaign,
        fields_tag,
        include,
        page_cursor,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-message]': 'csv',
            'fields[campaign]': 'csv',
            'fields[tag]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if fields_campaign_message is not None:
            
            if isinstance(fields_campaign_message, EnumMeta):
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            else:
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            
        if fields_campaign is not None:
            
            if isinstance(fields_campaign, EnumMeta):
                _query_params.append(('fields[campaign]', fields_campaign))
            else:
                _query_params.append(('fields[campaign]', fields_campaign))
            
        if fields_tag is not None:
            
            if isinstance(fields_tag, EnumMeta):
                _query_params.append(('fields[tag]', fields_tag))
            else:
                _query_params.append(('fields[tag]', fields_tag))
            
        if filter is not None:
            
            if isinstance(filter, EnumMeta):
                _query_params.append(('filter', filter))
            else:
                _query_params.append(('filter', filter))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        if page_cursor is not None:
            
            if isinstance(page_cursor, EnumMeta):
                _query_params.append(('page[cursor]', page_cursor))
            else:
                _query_params.append(('page[cursor]', page_cursor))
            
        if sort is not None:
            
            if isinstance(sort, EnumMeta):
                _query_params.append(('sort', sort))
            else:
                _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_image_for_campaign_message(        
        self,
        id: StrictStr,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetImageResponse, Dict[str, object]]:
        """Get Image for Campaign Message

        Return the related image for a given campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_for_campaign_message_serialize(
            id=id,
            fields_image=fields_image,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetImageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_image_for_campaign_message
    get_campaign_message_image = get_image_for_campaign_message

    @validate_call
    def get_image_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetImageResponse]:
        """Get Image for Campaign Message

        Return the related image for a given campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_for_campaign_message_serialize(
            id=id,
            fields_image=fields_image,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetImageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_image_for_campaign_message_with_http_info`
    get_campaign_message_image_with_http_info = get_image_for_campaign_message_with_http_info

    @validate_call
    def get_image_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Image for Campaign Message

        Return the related image for a given campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_for_campaign_message_serialize(
            id=id,
            fields_image=fields_image,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetImageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_image_for_campaign_message_without_preload_content`
    get_campaign_message_image_without_preload_content = get_image_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_image_for_campaign_message_serialize(
        self,
        id,
        fields_image,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[image]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_image is not None:
            
            if isinstance(fields_image, EnumMeta):
                _query_params.append(('fields[image]', fields_image))
            else:
                _query_params.append(('fields[image]', fields_image))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/image',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_image_for_campaign_message_serialize`
    _get_campaign_message_image_serialize = _get_image_for_campaign_message_serialize



    @validate_call
    def get_image_id_for_campaign_message(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessageImageRelationshipResponse, Dict[str, object]]:
        """Get Image ID for Campaign Message

        Returns the ID of the related image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageImageRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_image_id_for_campaign_message
    get_campaign_message_relationships_image = get_image_id_for_campaign_message

    @validate_call
    def get_image_id_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessageImageRelationshipResponse]:
        """Get Image ID for Campaign Message

        Returns the ID of the related image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageImageRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_image_id_for_campaign_message_with_http_info`
    get_campaign_message_relationships_image_with_http_info = get_image_id_for_campaign_message_with_http_info

    @validate_call
    def get_image_id_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Image ID for Campaign Message

        Returns the ID of the related image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `images:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_image_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageImageRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_image_id_for_campaign_message_without_preload_content`
    get_campaign_message_relationships_image_without_preload_content = get_image_id_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_image_id_for_campaign_message_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/relationships/image',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_image_id_for_campaign_message_serialize`
    _get_campaign_message_relationships_image_serialize = _get_image_id_for_campaign_message_serialize



    @validate_call
    def get_message_ids_for_campaign(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessagesRelationshipsResponseCollection, Dict[str, object]]:
        """Get Message IDs for Campaign

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_message_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessagesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_message_ids_for_campaign
    get_campaign_relationships_campaign_messages = get_message_ids_for_campaign

    # alias of get_message_ids_for_campaign
    get_campaign_relationships_messages = get_message_ids_for_campaign

    @validate_call
    def get_message_ids_for_campaign_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessagesRelationshipsResponseCollection]:
        """Get Message IDs for Campaign

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_message_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessagesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_message_ids_for_campaign_with_http_info`
    get_campaign_relationships_campaign_messages_with_http_info = get_message_ids_for_campaign_with_http_info

    # alias of `get_message_ids_for_campaign_with_http_info`
    get_campaign_relationships_messages_with_http_info = get_message_ids_for_campaign_with_http_info

    @validate_call
    def get_message_ids_for_campaign_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Message IDs for Campaign

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_message_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessagesRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_message_ids_for_campaign_without_preload_content`
    get_campaign_relationships_campaign_messages_without_preload_content = get_message_ids_for_campaign_without_preload_content

    # alias of `get_message_ids_for_campaign_without_preload_content`
    get_campaign_relationships_messages_without_preload_content = get_message_ids_for_campaign_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_message_ids_for_campaign_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns/{id}/relationships/campaign-messages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_message_ids_for_campaign_serialize`
    _get_campaign_relationships_campaign_messages_serialize = _get_message_ids_for_campaign_serialize

    # alias of `_get_message_ids_for_campaign_serialize`
    _get_campaign_relationships_messages_serialize = _get_message_ids_for_campaign_serialize



    @validate_call
    def get_messages_for_campaign(        
        self,
        id: StrictStr,
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessageResponseCollectionCompoundDocument, Dict[str, object]]:
        """Get Messages for Campaign

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_messages_for_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_messages_for_campaign
    get_campaign_campaign_messages = get_messages_for_campaign

    # alias of get_messages_for_campaign
    get_campaign_messages = get_messages_for_campaign

    @validate_call
    def get_messages_for_campaign_with_http_info(        
        self,
        id: StrictStr,
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessageResponseCollectionCompoundDocument]:
        """Get Messages for Campaign

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_messages_for_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_messages_for_campaign_with_http_info`
    get_campaign_campaign_messages_with_http_info = get_messages_for_campaign_with_http_info

    # alias of `get_messages_for_campaign_with_http_info`
    get_campaign_messages_with_http_info = get_messages_for_campaign_with_http_info

    @validate_call
    def get_messages_for_campaign_without_preload_content(
        self,
        id: StrictStr,
        fields_campaign_message: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_campaign: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_image: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        include: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Messages for Campaign

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`

        :param id:  (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_image: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_image: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships
        :type include: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_messages_for_campaign_serialize(
            id=id,
            fields_campaign_message=fields_campaign_message,
            fields_campaign=fields_campaign,
            fields_image=fields_image,
            fields_template=fields_template,
            include=include,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageResponseCollectionCompoundDocument",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_messages_for_campaign_without_preload_content`
    get_campaign_campaign_messages_without_preload_content = get_messages_for_campaign_without_preload_content

    # alias of `get_messages_for_campaign_without_preload_content`
    get_campaign_messages_without_preload_content = get_messages_for_campaign_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_messages_for_campaign_serialize(
        self,
        id,
        fields_campaign_message,
        fields_campaign,
        fields_image,
        fields_template,
        include,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[campaign-message]': 'csv',
            'fields[campaign]': 'csv',
            'fields[image]': 'csv',
            'fields[template]': 'csv',
            'include': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_campaign_message is not None:
            
            if isinstance(fields_campaign_message, EnumMeta):
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            else:
                _query_params.append(('fields[campaign-message]', fields_campaign_message))
            
        if fields_campaign is not None:
            
            if isinstance(fields_campaign, EnumMeta):
                _query_params.append(('fields[campaign]', fields_campaign))
            else:
                _query_params.append(('fields[campaign]', fields_campaign))
            
        if fields_image is not None:
            
            if isinstance(fields_image, EnumMeta):
                _query_params.append(('fields[image]', fields_image))
            else:
                _query_params.append(('fields[image]', fields_image))
            
        if fields_template is not None:
            
            if isinstance(fields_template, EnumMeta):
                _query_params.append(('fields[template]', fields_template))
            else:
                _query_params.append(('fields[template]', fields_template))
            
        if include is not None:
            
            if isinstance(include, EnumMeta):
                _query_params.append(('include', include))
            else:
                _query_params.append(('include', include))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns/{id}/campaign-messages',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_messages_for_campaign_serialize`
    _get_campaign_campaign_messages_serialize = _get_messages_for_campaign_serialize

    # alias of `_get_messages_for_campaign_serialize`
    _get_campaign_messages_serialize = _get_messages_for_campaign_serialize



    @validate_call
    def get_tag_ids_for_campaign(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignTagsRelationshipsResponseCollection, Dict[str, object]]:
        """Get Tag IDs for Campaign

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tag_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignTagsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_tag_ids_for_campaign
    get_campaign_relationships_tags = get_tag_ids_for_campaign

    @validate_call
    def get_tag_ids_for_campaign_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignTagsRelationshipsResponseCollection]:
        """Get Tag IDs for Campaign

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tag_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignTagsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_tag_ids_for_campaign_with_http_info`
    get_campaign_relationships_tags_with_http_info = get_tag_ids_for_campaign_with_http_info

    @validate_call
    def get_tag_ids_for_campaign_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Tag IDs for Campaign

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tag_ids_for_campaign_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignTagsRelationshipsResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_tag_ids_for_campaign_without_preload_content`
    get_campaign_relationships_tags_without_preload_content = get_tag_ids_for_campaign_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_tag_ids_for_campaign_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns/{id}/relationships/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_tag_ids_for_campaign_serialize`
    _get_campaign_relationships_tags_serialize = _get_tag_ids_for_campaign_serialize



    @validate_call
    def get_tags_for_campaign(        
        self,
        id: StrictStr,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetTagResponseCollection, Dict[str, object]]:
        """Get Tags for Campaign

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tags_for_campaign_serialize(
            id=id,
            fields_tag=fields_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTagResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_tags_for_campaign
    get_campaign_tags = get_tags_for_campaign

    @validate_call
    def get_tags_for_campaign_with_http_info(        
        self,
        id: StrictStr,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetTagResponseCollection]:
        """Get Tags for Campaign

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tags_for_campaign_serialize(
            id=id,
            fields_tag=fields_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTagResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_tags_for_campaign_with_http_info`
    get_campaign_tags_with_http_info = get_tags_for_campaign_with_http_info

    @validate_call
    def get_tags_for_campaign_without_preload_content(
        self,
        id: StrictStr,
        fields_tag: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Tags for Campaign

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`

        :param id:  (required)
        :type id: str
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_tags_for_campaign_serialize(
            id=id,
            fields_tag=fields_tag,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTagResponseCollection",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_tags_for_campaign_without_preload_content`
    get_campaign_tags_without_preload_content = get_tags_for_campaign_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_tags_for_campaign_serialize(
        self,
        id,
        fields_tag,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[tag]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_tag is not None:
            
            if isinstance(fields_tag, EnumMeta):
                _query_params.append(('fields[tag]', fields_tag))
            else:
                _query_params.append(('fields[tag]', fields_tag))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaigns/{id}/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_tags_for_campaign_serialize`
    _get_campaign_tags_serialize = _get_tags_for_campaign_serialize



    @validate_call
    def get_template_for_campaign_message(        
        self,
        id: StrictStr,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetTemplateResponse, Dict[str, object]]:
        """Get Template for Campaign Message

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_for_campaign_message_serialize(
            id=id,
            fields_template=fields_template,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTemplateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_template_for_campaign_message
    get_campaign_message_template = get_template_for_campaign_message

    @validate_call
    def get_template_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetTemplateResponse]:
        """Get Template for Campaign Message

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_for_campaign_message_serialize(
            id=id,
            fields_template=fields_template,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTemplateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_template_for_campaign_message_with_http_info`
    get_campaign_message_template_with_http_info = get_template_for_campaign_message_with_http_info

    @validate_call
    def get_template_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        fields_template: Annotated[Optional[List[StrictStr]], Field(description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Template for Campaign Message

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_for_campaign_message_serialize(
            id=id,
            fields_template=fields_template,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetTemplateResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_template_for_campaign_message_without_preload_content`
    get_campaign_message_template_without_preload_content = get_template_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_template_for_campaign_message_serialize(
        self,
        id,
        fields_template,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fields[template]': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if fields_template is not None:
            
            if isinstance(fields_template, EnumMeta):
                _query_params.append(('fields[template]', fields_template))
            else:
                _query_params.append(('fields[template]', fields_template))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/template',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_template_for_campaign_message_serialize`
    _get_campaign_message_template_serialize = _get_template_for_campaign_message_serialize



    @validate_call
    def get_template_id_for_campaign_message(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[GetCampaignMessageTemplateRelationshipResponse, Dict[str, object]]:
        """Get Template ID for Campaign Message

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageTemplateRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of get_template_id_for_campaign_message
    get_campaign_message_relationships_template = get_template_id_for_campaign_message

    @validate_call
    def get_template_id_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[GetCampaignMessageTemplateRelationshipResponse]:
        """Get Template ID for Campaign Message

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageTemplateRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `get_template_id_for_campaign_message_with_http_info`
    get_campaign_message_relationships_template_with_http_info = get_template_id_for_campaign_message_with_http_info

    @validate_call
    def get_template_id_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Get Template ID for Campaign Message

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`

        :param id:  (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_template_id_for_campaign_message_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCampaignMessageTemplateRelationshipResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `get_template_id_for_campaign_message_without_preload_content`
    get_campaign_message_relationships_template_without_preload_content = get_template_id_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _get_template_id_for_campaign_message_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/campaign-messages/{id}/relationships/template',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_get_template_id_for_campaign_message_serialize`
    _get_campaign_message_relationships_template_serialize = _get_template_id_for_campaign_message_serialize



    @validate_call
    def refresh_campaign_recipient_estimation(        
        self,
        campaign_recipient_estimation_job_create_query: Annotated[CampaignRecipientEstimationJobCreateQuery, Field(description="Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCampaignRecipientEstimationJobResponse, Dict[str, object]]:
        """Refresh Campaign Recipient Estimation

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_recipient_estimation_job_create_query: Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign. (required)
        :type campaign_recipient_estimation_job_create_query: CampaignRecipientEstimationJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._refresh_campaign_recipient_estimation_serialize(
            campaign_recipient_estimation_job_create_query=campaign_recipient_estimation_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of refresh_campaign_recipient_estimation
    create_campaign_recipient_estimation_job = refresh_campaign_recipient_estimation

    @validate_call
    def refresh_campaign_recipient_estimation_with_http_info(        
        self,
        campaign_recipient_estimation_job_create_query: Annotated[CampaignRecipientEstimationJobCreateQuery, Field(description="Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCampaignRecipientEstimationJobResponse]:
        """Refresh Campaign Recipient Estimation

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_recipient_estimation_job_create_query: Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign. (required)
        :type campaign_recipient_estimation_job_create_query: CampaignRecipientEstimationJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._refresh_campaign_recipient_estimation_serialize(
            campaign_recipient_estimation_job_create_query=campaign_recipient_estimation_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `refresh_campaign_recipient_estimation_with_http_info`
    create_campaign_recipient_estimation_job_with_http_info = refresh_campaign_recipient_estimation_with_http_info

    @validate_call
    def refresh_campaign_recipient_estimation_without_preload_content(
        self,
        campaign_recipient_estimation_job_create_query: Annotated[CampaignRecipientEstimationJobCreateQuery, Field(description="Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Refresh Campaign Recipient Estimation

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_recipient_estimation_job_create_query: Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign. (required)
        :type campaign_recipient_estimation_job_create_query: CampaignRecipientEstimationJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._refresh_campaign_recipient_estimation_serialize(
            campaign_recipient_estimation_job_create_query=campaign_recipient_estimation_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignRecipientEstimationJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `refresh_campaign_recipient_estimation_without_preload_content`
    create_campaign_recipient_estimation_job_without_preload_content = refresh_campaign_recipient_estimation_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _refresh_campaign_recipient_estimation_serialize(
        self,
        campaign_recipient_estimation_job_create_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_recipient_estimation_job_create_query is not None:
            _body_params = campaign_recipient_estimation_job_create_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/campaign-recipient-estimation-jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_refresh_campaign_recipient_estimation_serialize`
    _create_campaign_recipient_estimation_job_serialize = _refresh_campaign_recipient_estimation_serialize



    @validate_call
    def send_campaign(        
        self,
        campaign_send_job_create_query: Annotated[CampaignSendJobCreateQuery, Field(description="Trigger the campaign to send asynchronously")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PostCampaignSendJobResponse, Dict[str, object]]:
        """Send Campaign

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_send_job_create_query: Trigger the campaign to send asynchronously (required)
        :type campaign_send_job_create_query: CampaignSendJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_campaign_serialize(
            campaign_send_job_create_query=campaign_send_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of send_campaign
    create_campaign_send_job = send_campaign

    @validate_call
    def send_campaign_with_http_info(        
        self,
        campaign_send_job_create_query: Annotated[CampaignSendJobCreateQuery, Field(description="Trigger the campaign to send asynchronously")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PostCampaignSendJobResponse]:
        """Send Campaign

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_send_job_create_query: Trigger the campaign to send asynchronously (required)
        :type campaign_send_job_create_query: CampaignSendJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_campaign_serialize(
            campaign_send_job_create_query=campaign_send_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `send_campaign_with_http_info`
    create_campaign_send_job_with_http_info = send_campaign_with_http_info

    @validate_call
    def send_campaign_without_preload_content(
        self,
        campaign_send_job_create_query: Annotated[CampaignSendJobCreateQuery, Field(description="Trigger the campaign to send asynchronously")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Send Campaign

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param campaign_send_job_create_query: Trigger the campaign to send asynchronously (required)
        :type campaign_send_job_create_query: CampaignSendJobCreateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._send_campaign_serialize(
            campaign_send_job_create_query=campaign_send_job_create_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "PostCampaignSendJobResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `send_campaign_without_preload_content`
    create_campaign_send_job_without_preload_content = send_campaign_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _send_campaign_serialize(
        self,
        campaign_send_job_create_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_send_job_create_query is not None:
            _body_params = campaign_send_job_create_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/campaign-send-jobs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_send_campaign_serialize`
    _create_campaign_send_job_serialize = _send_campaign_serialize



    @validate_call
    def update_campaign(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        campaign_partial_update_query: Annotated[CampaignPartialUpdateQuery, Field(description="Update a campaign and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PatchCampaignResponse, Dict[str, object]]:
        """Update Campaign

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param campaign_partial_update_query: Update a campaign and return it (required)
        :type campaign_partial_update_query: CampaignPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_serialize(
            id=id,
            campaign_partial_update_query=campaign_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def update_campaign_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        campaign_partial_update_query: Annotated[CampaignPartialUpdateQuery, Field(description="Update a campaign and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PatchCampaignResponse]:
        """Update Campaign

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param campaign_partial_update_query: Update a campaign and return it (required)
        :type campaign_partial_update_query: CampaignPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_serialize(
            id=id,
            campaign_partial_update_query=campaign_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_campaign_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The campaign ID to be retrieved")],
        campaign_partial_update_query: Annotated[CampaignPartialUpdateQuery, Field(description="Update a campaign and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Update Campaign

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param campaign_partial_update_query: Update a campaign and return it (required)
        :type campaign_partial_update_query: CampaignPartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_serialize(
            id=id,
            campaign_partial_update_query=campaign_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _update_campaign_serialize(
        self,
        id,
        campaign_partial_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_partial_update_query is not None:
            _body_params = campaign_partial_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/campaigns/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_campaign_message(        
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        campaign_message_partial_update_query: Annotated[CampaignMessagePartialUpdateQuery, Field(description="Update a message and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) ->  Union[PatchCampaignMessageResponse, Dict[str, object]]:
        """Update Campaign Message

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param campaign_message_partial_update_query: Update a message and return it (required)
        :type campaign_message_partial_update_query: CampaignMessagePartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_message_serialize(
            id=id,
            campaign_message_partial_update_query=campaign_message_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    @validate_call
    def update_campaign_message_with_http_info(        
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        campaign_message_partial_update_query: Annotated[CampaignMessagePartialUpdateQuery, Field(description="Update a message and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[PatchCampaignMessageResponse]:
        """Update Campaign Message

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param campaign_message_partial_update_query: Update a message and return it (required)
        :type campaign_message_partial_update_query: CampaignMessagePartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_message_serialize(
            id=id,
            campaign_message_partial_update_query=campaign_message_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_campaign_message_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="The message ID to be retrieved")],
        campaign_message_partial_update_query: Annotated[CampaignMessagePartialUpdateQuery, Field(description="Update a message and return it")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Update Campaign Message

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param campaign_message_partial_update_query: Update a message and return it (required)
        :type campaign_message_partial_update_query: CampaignMessagePartialUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_campaign_message_serialize(
            id=id,
            campaign_message_partial_update_query=campaign_message_partial_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "PatchCampaignMessageResponse",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _update_campaign_message_serialize(
        self,
        id,
        campaign_message_partial_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_message_partial_update_query is not None:
            _body_params = campaign_message_partial_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/campaign-messages/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_image_for_campaign_message(        
        self,
        id: StrictStr,
        campaign_message_image_update_query: CampaignMessageImageUpdateQuery,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> None:
        """Update Image for Campaign Message

        Update a campaign message image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write` `images:read`

        :param id:  (required)
        :type id: str
        :param campaign_message_image_update_query: (required)
        :type campaign_message_image_update_query: CampaignMessageImageUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_image_for_campaign_message_serialize(
            id=id,
            campaign_message_image_update_query=campaign_message_image_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()

        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
            exclude_none=uses_sparse_fields
        ).data


    # alias of update_image_for_campaign_message
    update_campaign_message_relationships_image = update_image_for_campaign_message

    @validate_call
    def update_image_for_campaign_message_with_http_info(        
        self,
        id: StrictStr,
        campaign_message_image_update_query: CampaignMessageImageUpdateQuery,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
        options: Dict[str, Any] = {},
) -> ApiResponse[None]:
        """Update Image for Campaign Message

        Update a campaign message image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write` `images:read`

        :param id:  (required)
        :type id: str
        :param campaign_message_image_update_query: (required)
        :type campaign_message_image_update_query: CampaignMessageImageUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_image_for_campaign_message_serialize(
            id=id,
            campaign_message_image_update_query=campaign_message_image_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        frame = inspect.currentframe()
        args, _, _, values = inspect.getargvalues(frame)
        uses_sparse_fields = self._uses_sparse_fields(args, values)

        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}

        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        if uses_sparse_fields or options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False) or self.api_client.options.get(USE_DICTIONARY_FOR_RESPONSE_DATA, False):
            _response_types_map = self._replace_type_with_dict_in_response_types_map(_response_types_map)

        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    # alias of `update_image_for_campaign_message_with_http_info`
    update_campaign_message_relationships_image_with_http_info = update_image_for_campaign_message_with_http_info

    @validate_call
    def update_image_for_campaign_message_without_preload_content(
        self,
        id: StrictStr,
        campaign_message_image_update_query: CampaignMessageImageUpdateQuery,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: StrictStr = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,) -> RESTResponseType:
        """Update Image for Campaign Message

        Update a campaign message image<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write` `images:read`

        :param id:  (required)
        :type id: str
        :param campaign_message_image_update_query: (required)
        :type campaign_message_image_update_query: CampaignMessageImageUpdateQuery
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_image_for_campaign_message_serialize(
            id=id,
            campaign_message_image_update_query=campaign_message_image_update_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }
        if _request_auth is not None:
            _request_auth = {'in': 'header', 'key': 'Authorization', 'type': 'api_key', 'value': f'Klaviyo-API-Key {_request_auth}'}
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    # alias of `update_image_for_campaign_message_without_preload_content`
    update_campaign_message_relationships_image_without_preload_content = update_image_for_campaign_message_without_preload_content

    def _uses_sparse_fields(self, args, values) -> Set[str]:
        for arg in args:
             if arg.startswith('fields'):
                 if values[arg] is not None:
                      return True
        return False


    def _replace_type_with_dict_in_response_types_map(self, response_types_map: Dict[str, Optional[str]]) -> Dict[str, Optional[str]]:
        for key, value in response_types_map.items():
            if key.startswith('2'):
                if value is not None:
                    # Replace the Type for this key with a Dict type
                    response_types_map[key] = 'Dict[str, object]'

        return response_types_map

    def _update_image_for_campaign_message_serialize(
        self,
        id,
        campaign_message_image_update_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if campaign_message_image_update_query is not None:
            _body_params = campaign_message_image_update_query


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/vnd.api+json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/vnd.api+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Klaviyo-API-Key', 
            'OAuth'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/campaign-messages/{id}/relationships/image',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


    # alias of `_update_image_for_campaign_message_serialize`
    _update_campaign_message_relationships_image_serialize = _update_image_for_campaign_message_serialize

