#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/cdk");
const elb = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elb-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAZs: 1
});
new elb.LoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true,
    listeners: [{
            externalPort: 80,
            allowConnectionsFrom: [new ec2.AnyIPv4()]
        }],
    healthCheck: {
        port: 80
    },
    targets: []
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZWxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuZWxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHdDQUF5QztBQUN6QyxvQ0FBcUM7QUFDckMsOEJBQStCO0FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUV0RCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtJQUNwQyxNQUFNLEVBQUUsQ0FBQztDQUNWLENBQUMsQ0FBQztBQUVILElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO0lBQ2hDLEdBQUc7SUFDSCxjQUFjLEVBQUUsSUFBSTtJQUNwQixTQUFTLEVBQUUsQ0FBQztZQUNWLFlBQVksRUFBRSxFQUFFO1lBQ2hCLG9CQUFvQixFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsT0FBTyxFQUFFLENBQUM7U0FDMUMsQ0FBQztJQUNGLFdBQVcsRUFBRTtRQUNYLElBQUksRUFBRSxFQUFFO0tBQ1Q7SUFDRCxPQUFPLEVBQUUsRUFBRTtDQUNaLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCBlYzIgPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtZWMyJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgZWxiID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1lbGItaW50ZWcnKTtcblxuY29uc3QgdnBjID0gbmV3IGVjMi5WcGMoc3RhY2ssICdWUEMnLCB7XG4gIG1heEFaczogMVxufSk7XG5cbm5ldyBlbGIuTG9hZEJhbGFuY2VyKHN0YWNrLCAnTEInLCB7XG4gIHZwYyxcbiAgaW50ZXJuZXRGYWNpbmc6IHRydWUsXG4gIGxpc3RlbmVyczogW3tcbiAgICBleHRlcm5hbFBvcnQ6IDgwLFxuICAgIGFsbG93Q29ubmVjdGlvbnNGcm9tOiBbbmV3IGVjMi5BbnlJUHY0KCldXG4gIH1dLFxuICBoZWFsdGhDaGVjazoge1xuICAgIHBvcnQ6IDgwXG4gIH0sXG4gIHRhcmdldHM6IFtdXG59KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=