import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import { Size } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { BatchStrategy, TransformInput, TransformOutput, TransformResources } from './base-types';
/**
 * (experimental) Properties for creating an Amazon SageMaker training job task.
 *
 * @experimental
 */
export interface SageMakerCreateTransformJobProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) Training Job Name.
     *
     * @experimental
     */
    readonly transformJobName: string;
    /**
     * (experimental) Role for the Training Job.
     *
     * @default - A role is created with `AmazonSageMakerFullAccess` managed policy
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Number of records to include in a mini-batch for an HTTP inference request.
     *
     * @default - No batch strategy
     * @experimental
     */
    readonly batchStrategy?: BatchStrategy;
    /**
     * (experimental) Environment variables to set in the Docker container.
     *
     * @default - No environment variables
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) Maximum number of parallel requests that can be sent to each instance in a transform job.
     *
     * @default - Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm.
     * If the execution-parameters endpoint is not enabled, the default value is 1.
     * @experimental
     */
    readonly maxConcurrentTransforms?: number;
    /**
     * (experimental) Maximum allowed size of the payload, in MB.
     *
     * @default 6
     * @experimental
     */
    readonly maxPayload?: Size;
    /**
     * (experimental) Name of the model that you want to use for the transform job.
     *
     * @experimental
     */
    readonly modelName: string;
    /**
     * (experimental) Tags to be applied to the train job.
     *
     * @default - No tags
     * @experimental
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * (experimental) Dataset to be transformed and the Amazon S3 location where it is stored.
     *
     * @experimental
     */
    readonly transformInput: TransformInput;
    /**
     * (experimental) S3 location where you want Amazon SageMaker to save the results from the transform job.
     *
     * @experimental
     */
    readonly transformOutput: TransformOutput;
    /**
     * (experimental) ML compute instances for the transform job.
     *
     * @default - 1 instance of type M4.XLarge
     * @experimental
     */
    readonly transformResources?: TransformResources;
}
/**
 * (experimental) Class representing the SageMaker Create Training Job task.
 *
 * @experimental
 */
export declare class SageMakerCreateTransformJob extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * Dataset to be transformed and the Amazon S3 location where it is stored.
     */
    private readonly transformInput;
    /**
     * ML compute instances for the transform job.
     */
    private readonly transformResources;
    private readonly integrationPattern;
    private _role?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SageMakerCreateTransformJobProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
    /**
     * (experimental) The execution role for the Sagemaker training job.
     *
     * Only available after task has been added to a state machine.
     *
     * @experimental
     */
    get role(): iam.IRole;
    private renderParameters;
    private renderTransformInput;
    private renderTransformOutput;
    private renderTransformResources;
    private renderEnvironment;
    private makePolicyStatements;
}
