import * as iam from '@aws-cdk/aws-iam';
import * as sfn from '@aws-cdk/aws-stepfunctions';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Properties for EmrCreateCluster.
 *
 * See the RunJobFlow API for complete documentation on input parameters
 *
 * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_RunJobFlow.html
 * @experimental
 */
export interface EmrCreateClusterProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) A specification of the number and type of Amazon EC2 instances.
     *
     * @experimental
     */
    readonly instances: EmrCreateCluster.InstancesConfigProperty;
    /**
     * (experimental) Also called instance profile and EC2 role.
     *
     * An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role.
     *
     * This attribute has been renamed from jobFlowRole to clusterRole to align with other ERM/StepFunction integration parameters.
     *
     * @default - * A Role will be created
     * @experimental
     */
    readonly clusterRole?: iam.IRole;
    /**
     * (experimental) The Name of the Cluster.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The IAM role that will be assumed by the Amazon EMR service to access AWS resources on your behalf.
     *
     * @default - A role will be created that Amazon EMR service can assume.
     * @experimental
     */
    readonly serviceRole?: iam.IRole;
    /**
     * (experimental) A JSON string for selecting additional features.
     *
     * @default - None
     * @experimental
     */
    readonly additionalInfo?: string;
    /**
     * (experimental) A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster.
     *
     * @default - EMR selected default
     * @experimental
     */
    readonly applications?: EmrCreateCluster.ApplicationConfigProperty[];
    /**
     * (experimental) An IAM role for automatic scaling policies.
     *
     * @default - A role will be created.
     * @experimental
     */
    readonly autoScalingRole?: iam.IRole;
    /**
     * (experimental) A list of bootstrap actions to run before Hadoop starts on the cluster nodes.
     *
     * @default - None
     * @experimental
     */
    readonly bootstrapActions?: EmrCreateCluster.BootstrapActionConfigProperty[];
    /**
     * (experimental) The list of configurations supplied for the EMR cluster you are creating.
     *
     * @default - None
     * @experimental
     */
    readonly configurations?: EmrCreateCluster.ConfigurationProperty[];
    /**
     * (experimental) The ID of a custom Amazon EBS-backed Linux AMI.
     *
     * @default - None
     * @experimental
     */
    readonly customAmiId?: string;
    /**
     * (experimental) The size of the EBS root device volume of the Linux AMI that is used for each EC2 instance.
     *
     * @default - EMR selected default
     * @experimental
     */
    readonly ebsRootVolumeSize?: cdk.Size;
    /**
     * (experimental) Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     *
     * @default - None
     * @experimental
     */
    readonly kerberosAttributes?: EmrCreateCluster.KerberosAttributesProperty;
    /**
     * (experimental) The location in Amazon S3 to write the log files of the job flow.
     *
     * @default - None
     * @experimental
     */
    readonly logUri?: string;
    /**
     * (experimental) The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster.
     *
     * @default - EMR selected default
     * @experimental
     */
    readonly releaseLabel?: string;
    /**
     * (experimental) Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized.
     *
     * @default - EMR selected default
     * @experimental
     */
    readonly scaleDownBehavior?: EmrCreateCluster.EmrClusterScaleDownBehavior;
    /**
     * (experimental) The name of a security configuration to apply to the cluster.
     *
     * @default - None
     * @experimental
     */
    readonly securityConfiguration?: string;
    /**
     * (experimental) A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
     *
     * @default - None
     * @experimental
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * (experimental) A value of true indicates that all IAM users in the AWS account can perform cluster actions if they have the proper IAM policy permissions.
     *
     * @default true
     * @experimental
     */
    readonly visibleToAllUsers?: boolean;
}
/**
 * (experimental) A Step Functions Task to create an EMR Cluster.
 *
 * The ClusterConfiguration is defined as Parameters in the state machine definition.
 *
 * OUTPUT: the ClusterId.
 *
 * @experimental
 */
export declare class EmrCreateCluster extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    private readonly visibleToAllUsers;
    private readonly integrationPattern;
    private _serviceRole;
    private _clusterRole;
    private _autoScalingRole?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EmrCreateClusterProps);
    /**
     * (experimental) The service role for the EMR Cluster.
     *
     * Only available after task has been added to a state machine.
     *
     * @experimental
     */
    get serviceRole(): iam.IRole;
    /**
     * (experimental) The instance role for the EMR Cluster.
     *
     * Only available after task has been added to a state machine.
     *
     * @experimental
     */
    get clusterRole(): iam.IRole;
    /**
     * (experimental) The autoscaling role for the EMR Cluster.
     *
     * Only available after task has been added to a state machine.
     *
     * @experimental
     */
    get autoScalingRole(): iam.IRole;
    /**
     * @internal
     */
    protected _renderTask(): any;
    private renderTags;
    /**
     * This generates the PolicyStatements required by the Task to call CreateCluster.
     */
    private createPolicyStatements;
    /**
     * Generate the Role used by the EMR Service
     */
    private createServiceRole;
    /**
     * Generate the Role and Instance Profile used by the EC2 instances
     *
     * Data access permissions will need to be updated by the user
     */
    private createClusterRole;
    /**
     * Generate the Role used to AutoScale the Cluster
     */
    private createAutoScalingRole;
}
/**
 * (experimental) A Step Functions Task to create an EMR Cluster.
 *
 * The ClusterConfiguration is defined as Parameters in the state machine definition.
 *
 * OUTPUT: the ClusterId.
 *
 * @experimental
 */
export declare namespace EmrCreateCluster {
    /**
     * (experimental) Valid valus for the Cluster ScaleDownBehavior.
     *
     * @experimental
     */
    enum EmrClusterScaleDownBehavior {
        /**
         * (experimental) Indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted.
         *
         * This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version
         *
         * @experimental
         */
        TERMINATE_AT_INSTANCE_HOUR = "TERMINATE_AT_INSTANCE_HOUR",
        /**
         * (experimental) Indicates that Amazon EMR blacklists and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary.
         *
         * @experimental
         */
        TERMINATE_AT_TASK_COMPLETION = "TERMINATE_AT_TASK_COMPLETION"
    }
    /**
     * (experimental) Instance Role Types.
     *
     * @experimental
     */
    enum InstanceRoleType {
        /**
         * (experimental) Master Node.
         *
         * @experimental
         */
        MASTER = "MASTER",
        /**
         * (experimental) Core Node.
         *
         * @experimental
         */
        CORE = "CORE",
        /**
         * (experimental) Task Node.
         *
         * @experimental
         */
        TASK = "TASK"
    }
    /**
     * (experimental) EBS Volume Types.
     *
     * @experimental
     */
    enum EbsBlockDeviceVolumeType {
        /**
         * (experimental) gp2 Volume Type.
         *
         * @experimental
         */
        GP2 = "gp2",
        /**
         * (experimental) io1 Volume Type.
         *
         * @experimental
         */
        IO1 = "io1",
        /**
         * (experimental) Standard Volume Type.
         *
         * @experimental
         */
        STANDARD = "standard"
    }
    /**
     * (experimental) EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_VolumeSpecification.html
     * @experimental
     */
    interface VolumeSpecificationProperty {
        /**
         * (experimental) The number of I/O operations per second (IOPS) that the volume supports.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly iops?: number;
        /**
         * (experimental) The volume size.
         *
         * If the volume type is EBS-optimized, the minimum value is 10GiB.
         * Maximum size is 1TiB
         *
         * @experimental
         */
        readonly volumeSize: cdk.Size;
        /**
         * (experimental) The volume type.
         *
         * Volume types supported are gp2, io1, standard.
         *
         * @experimental
         */
        readonly volumeType: EbsBlockDeviceVolumeType;
    }
    /**
     * (experimental) Configuration of requested EBS block device associated with the instance group with count of volumes that will be associated to every instance.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsBlockDeviceConfig.html
     * @experimental
     */
    interface EbsBlockDeviceConfigProperty {
        /**
         * (experimental) EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume attached to an EC2 instance in the cluster.
         *
         * @experimental
         */
        readonly volumeSpecification: VolumeSpecificationProperty;
        /**
         * (experimental) Number of EBS volumes with a specific volume configuration that will be associated with every instance in the instance group.
         *
         * @default EMR selected default
         * @experimental
         */
        readonly volumesPerInstance?: number;
    }
    /**
     * (experimental) The Amazon EBS configuration of a cluster instance.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_EbsConfiguration.html
     * @experimental
     */
    interface EbsConfigurationProperty {
        /**
         * (experimental) An array of Amazon EBS volume specifications attached to a cluster instance.
         *
         * @default - None
         * @experimental
         */
        readonly ebsBlockDeviceConfigs?: EbsBlockDeviceConfigProperty[];
        /**
         * (experimental) Indicates whether an Amazon EBS volume is EBS-optimized.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly ebsOptimized?: boolean;
    }
    /**
     * (experimental) An instance type configuration for each instance type in an instance fleet, which determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceTypeConfig.html
     * @experimental
     */
    interface InstanceTypeConfigProperty {
        /**
         * (experimental) The bid price for each EC2 Spot instance type as defined by InstanceType.
         *
         * Expressed in USD.
         *
         * @default - None
         * @experimental
         */
        readonly bidPrice?: string;
        /**
         * (experimental) The bid price, as a percentage of On-Demand price.
         *
         * @default - None
         * @experimental
         */
        readonly bidPriceAsPercentageOfOnDemandPrice?: number;
        /**
         * (experimental) A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.
         *
         * @default - None
         * @experimental
         */
        readonly configurations?: ConfigurationProperty[];
        /**
         * (experimental) The configuration of Amazon Elastic Block Storage (EBS) attached to each instance as defined by InstanceType.
         *
         * @default - None
         * @experimental
         */
        readonly ebsConfiguration?: EbsConfigurationProperty;
        /**
         * (experimental) An EC2 instance type.
         *
         * @experimental
         */
        readonly instanceType: string;
        /**
         * (experimental) The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in the InstanceFleetConfig.
         *
         * @default - None
         * @experimental
         */
        readonly weightedCapacity?: number;
    }
    /**
     * (experimental) Spot Timeout Actions.
     *
     * @experimental
     */
    enum SpotTimeoutAction {
        /**
         * (experimental) \ SWITCH_TO_ON_DEMAND.
         *
         * @experimental
         */
        SWITCH_TO_ON_DEMAND = "SWITCH_TO_ON_DEMAND",
        /**
         * (experimental) TERMINATE_CLUSTER.
         *
         * @experimental
         */
        TERMINATE_CLUSTER = "TERMINATE_CLUSTER"
    }
    /**
     * (experimental) The launch specification for Spot instances in the instance fleet, which determines the defined duration and provisioning timeout behavior.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_SpotProvisioningSpecification.html
     * @experimental
     */
    interface SpotProvisioningSpecificationProperty {
        /**
         * (experimental) The defined duration for Spot instances (also known as Spot blocks) in minutes.
         *
         * @default No blockDurationMinutes
         * @experimental
         */
        readonly blockDurationMinutes?: number;
        /**
         * (experimental) The action to take when TargetSpotCapacity has not been fulfilled when the TimeoutDurationMinutes has expired.
         *
         * @experimental
         */
        readonly timeoutAction: SpotTimeoutAction;
        /**
         * (experimental) The spot provisioning timeout period in minutes.
         *
         * @experimental
         */
        readonly timeoutDurationMinutes: number;
    }
    /**
     * (experimental) The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetProvisioningSpecifications.html
     * @experimental
     */
    interface InstanceFleetProvisioningSpecificationsProperty {
        /**
         * (experimental) The launch specification for Spot instances in the fleet, which determines the defined duration and provisioning timeout behavior.
         *
         * @experimental
         */
        readonly spotSpecification: SpotProvisioningSpecificationProperty;
    }
    /**
     * (experimental) The configuration that defines an instance fleet.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceFleetConfig.html
     * @experimental
     */
    interface InstanceFleetConfigProperty {
        /**
         * (experimental) The node type that the instance fleet hosts.
         *
         * Valid values are MASTER,CORE,and TASK.
         *
         * @experimental
         */
        readonly instanceFleetType: InstanceRoleType;
        /**
         * (experimental) The instance type configurations that define the EC2 instances in the instance fleet.
         *
         * @default No instanceTpeConfigs
         * @experimental
         */
        readonly instanceTypeConfigs?: InstanceTypeConfigProperty[];
        /**
         * (experimental) The launch specification for the instance fleet.
         *
         * @default No launchSpecifications
         * @experimental
         */
        readonly launchSpecifications?: InstanceFleetProvisioningSpecificationsProperty;
        /**
         * (experimental) The friendly name of the instance fleet.
         *
         * @default No name
         * @experimental
         */
        readonly name?: string;
        /**
         * (experimental) The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         *
         * @default No targetOnDemandCapacity
         * @experimental
         */
        readonly targetOnDemandCapacity?: number;
        /**
         * (experimental) The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         *
         * @default No targetSpotCapacity
         * @experimental
         */
        readonly targetSpotCapacity?: number;
    }
    /**
     * (experimental) CloudWatch Alarm Comparison Operators.
     *
     * @experimental
     */
    enum CloudWatchAlarmComparisonOperator {
        /**
         * (experimental) GREATER_THAN_OR_EQUAL.
         *
         * @experimental
         */
        GREATER_THAN_OR_EQUAL = "GREATER_THAN_OR_EQUAL",
        /**
         * (experimental) GREATER_THAN.
         *
         * @experimental
         */
        GREATER_THAN = "GREATER_THAN",
        /**
         * (experimental) LESS_THAN.
         *
         * @experimental
         */
        LESS_THAN = "LESS_THAN",
        /**
         * (experimental) LESS_THAN_OR_EQUAL.
         *
         * @experimental
         */
        LESS_THAN_OR_EQUAL = "LESS_THAN_OR_EQUAL"
    }
    /**
     * (experimental) CloudWatch Alarm Statistics.
     *
     * @experimental
     */
    enum CloudWatchAlarmStatistic {
        /**
         * (experimental) SAMPLE_COUNT.
         *
         * @experimental
         */
        SAMPLE_COUNT = "SAMPLE_COUNT",
        /**
         * (experimental) AVERAGE.
         *
         * @experimental
         */
        AVERAGE = "AVERAGE",
        /**
         * (experimental) SUM.
         *
         * @experimental
         */
        SUM = "SUM",
        /**
         * (experimental) MINIMUM.
         *
         * @experimental
         */
        MINIMUM = "MINIMUM",
        /**
         * (experimental) MAXIMUM.
         *
         * @experimental
         */
        MAXIMUM = "MAXIMUM"
    }
    /**
     * (experimental) CloudWatch Alarm Units.
     *
     * @experimental
     */
    enum CloudWatchAlarmUnit {
        /**
         * (experimental) NONE.
         *
         * @experimental
         */
        NONE = "NONE",
        /**
         * (experimental) SECONDS.
         *
         * @experimental
         */
        SECONDS = "SECONDS",
        /**
         * (experimental) MICRO_SECONDS.
         *
         * @experimental
         */
        MICRO_SECONDS = "MICRO_SECONDS",
        /**
         * (experimental) MILLI_SECONDS.
         *
         * @experimental
         */
        MILLI_SECONDS = "MILLI_SECONDS",
        /**
         * (experimental) BYTES.
         *
         * @experimental
         */
        BYTES = "BYTES",
        /**
         * (experimental) KILO_BYTES.
         *
         * @experimental
         */
        KILO_BYTES = "KILO_BYTES",
        /**
         * (experimental) MEGA_BYTES.
         *
         * @experimental
         */
        MEGA_BYTES = "MEGA_BYTES",
        /**
         * (experimental) GIGA_BYTES.
         *
         * @experimental
         */
        GIGA_BYTES = "GIGA_BYTES",
        /**
         * (experimental) TERA_BYTES.
         *
         * @experimental
         */
        TERA_BYTES = "TERA_BYTES",
        /**
         * (experimental) BITS.
         *
         * @experimental
         */
        BITS = "BITS",
        /**
         * (experimental) KILO_BITS.
         *
         * @experimental
         */
        KILO_BITS = "KILO_BITS",
        /**
         * (experimental) MEGA_BITS.
         *
         * @experimental
         */
        MEGA_BITS = "MEGA_BITS",
        /**
         * (experimental) GIGA_BITS.
         *
         * @experimental
         */
        GIGA_BITS = "GIGA_BITS",
        /**
         * (experimental) TERA_BITS.
         *
         * @experimental
         */
        TERA_BITS = "TERA_BITS",
        /**
         * (experimental) PERCENT.
         *
         * @experimental
         */
        PERCENT = "PERCENT",
        /**
         * (experimental) COUNT.
         *
         * @experimental
         */
        COUNT = "COUNT",
        /**
         * (experimental) BYTES_PER_SECOND.
         *
         * @experimental
         */
        BYTES_PER_SECOND = "BYTES_PER_SECOND",
        /**
         * (experimental) KILO_BYTES_PER_SECOND.
         *
         * @experimental
         */
        KILO_BYTES_PER_SECOND = "KILO_BYTES_PER_SECOND",
        /**
         * (experimental) MEGA_BYTES_PER_SECOND.
         *
         * @experimental
         */
        MEGA_BYTES_PER_SECOND = "MEGA_BYTES_PER_SECOND",
        /**
         * (experimental) GIGA_BYTES_PER_SECOND.
         *
         * @experimental
         */
        GIGA_BYTES_PER_SECOND = "GIGA_BYTES_PER_SECOND",
        /**
         * (experimental) TERA_BYTES_PER_SECOND.
         *
         * @experimental
         */
        TERA_BYTES_PER_SECOND = "TERA_BYTES_PER_SECOND",
        /**
         * (experimental) BITS_PER_SECOND.
         *
         * @experimental
         */
        BITS_PER_SECOND = "BITS_PER_SECOND",
        /**
         * (experimental) KILO_BITS_PER_SECOND.
         *
         * @experimental
         */
        KILO_BITS_PER_SECOND = "KILO_BITS_PER_SECOND",
        /**
         * (experimental) MEGA_BITS_PER_SECOND.
         *
         * @experimental
         */
        MEGA_BITS_PER_SECOND = "MEGA_BITS_PER_SECOND",
        /**
         * (experimental) GIGA_BITS_PER_SECOND.
         *
         * @experimental
         */
        GIGA_BITS_PER_SECOND = "GIGA_BITS_PER_SECOND",
        /**
         * (experimental) TERA_BITS_PER_SECOND.
         *
         * @experimental
         */
        TERA_BITS_PER_SECOND = "TERA_BITS_PER_SECOND",
        /**
         * (experimental) COUNT_PER_SECOND.
         *
         * @experimental
         */
        COUNT_PER_SECOND = "COUNT_PER_SECOND"
    }
    /**
     * (experimental) A CloudWatch dimension, which is specified using a Key (known as a Name in CloudWatch), Value pair.
     *
     * By default, Amazon EMR uses
     * one dimension whose Key is JobFlowID and Value is a variable representing the cluster ID, which is ${emr.clusterId}. This enables
     * the rule to bootstrap when the cluster ID becomes available
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_MetricDimension.html
     * @experimental
     */
    interface MetricDimensionProperty {
        /**
         * (experimental) The dimension name.
         *
         * @experimental
         */
        readonly key: string;
        /**
         * (experimental) The dimension value.
         *
         * @experimental
         */
        readonly value: string;
    }
    /**
     * (experimental) The definition of a CloudWatch metric alarm, which determines when an automatic scaling activity is triggered.
     *
     * When the defined alarm conditions
     * are satisfied, scaling activity begins.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_CloudWatchAlarmDefinition.html
     * @experimental
     */
    interface CloudWatchAlarmDefinitionProperty {
        /**
         * (experimental) Determines how the metric specified by MetricName is compared to the value specified by Threshold.
         *
         * @experimental
         */
        readonly comparisonOperator: CloudWatchAlarmComparisonOperator;
        /**
         * (experimental) A CloudWatch metric dimension.
         *
         * @default - No dimensions
         * @experimental
         */
        readonly dimensions?: MetricDimensionProperty[];
        /**
         * (experimental) The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity.
         *
         * @default 1
         * @experimental
         */
        readonly evaluationPeriods?: number;
        /**
         * (experimental) The name of the CloudWatch metric that is watched to determine an alarm condition.
         *
         * @experimental
         */
        readonly metricName: string;
        /**
         * (experimental) The namespace for the CloudWatch metric.
         *
         * @default 'AWS/ElasticMapReduce'
         * @experimental
         */
        readonly namespace?: string;
        /**
         * (experimental) The period, in seconds, over which the statistic is applied.
         *
         * EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if
         * an EMR CloudWatch metric is specified, specify 300.
         *
         * @experimental
         */
        readonly period: cdk.Duration;
        /**
         * (experimental) The statistic to apply to the metric associated with the alarm.
         *
         * @default CloudWatchAlarmStatistic.AVERAGE
         * @experimental
         */
        readonly statistic?: CloudWatchAlarmStatistic;
        /**
         * (experimental) The value against which the specified statistic is compared.
         *
         * @default - None
         * @experimental
         */
        readonly threshold?: number;
        /**
         * (experimental) The unit of measure associated with the CloudWatch metric being watched.
         *
         * The value specified for Unit must correspond to the units
         * specified in the CloudWatch metric.
         *
         * @default CloudWatchAlarmUnit.NONE
         * @experimental
         */
        readonly unit?: CloudWatchAlarmUnit;
    }
    /**
     * (experimental) The conditions that trigger an automatic scaling activity and the definition of a CloudWatch metric alarm.
     *
     * When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingTrigger.html
     * @experimental
     */
    interface ScalingTriggerProperty {
        /**
         * (experimental) The definition of a CloudWatch metric alarm.
         *
         * When the defined alarm conditions are met along with other trigger parameters,
         * scaling activity begins.
         *
         * @experimental
         */
        readonly cloudWatchAlarmDefinition: CloudWatchAlarmDefinitionProperty;
    }
    /**
     * (experimental) EC2 Instance Market.
     *
     * @experimental
     */
    enum InstanceMarket {
        /**
         * (experimental) On Demand Instance.
         *
         * @experimental
         */
        ON_DEMAND = "ON_DEMAND",
        /**
         * (experimental) Spot Instance.
         *
         * @experimental
         */
        SPOT = "SPOT"
    }
    /**
     * (experimental) AutoScaling Adjustment Type.
     *
     * @experimental
     */
    enum ScalingAdjustmentType {
        /**
         * (experimental) CHANGE_IN_CAPACITY.
         *
         * @experimental
         */
        CHANGE_IN_CAPACITY = "CHANGE_IN_CAPACITY",
        /**
         * (experimental) PERCENT_CHANGE_IN_CAPACITY.
         *
         * @experimental
         */
        PERCENT_CHANGE_IN_CAPACITY = "PERCENT_CHANGE_IN_CAPACITY",
        /**
         * (experimental) EXACT_CAPACITY.
         *
         * @experimental
         */
        EXACT_CAPACITY = "EXACT_CAPACITY"
    }
    /**
     * (experimental) An automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period, and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_SimpleScalingPolicyConfiguration.html
     * @experimental
     */
    interface SimpleScalingPolicyConfigurationProperty {
        /**
         * (experimental) The way in which EC2 instances are added (if ScalingAdjustment is a positive number) or terminated (if ScalingAdjustment is a negative number) each time the scaling activity is triggered.
         *
         * @default - None
         * @experimental
         */
        readonly adjustmentType?: ScalingAdjustmentType;
        /**
         * (experimental) The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start.
         *
         * @default 0
         * @experimental
         */
        readonly coolDown?: number;
        /**
         * (experimental) The amount by which to scale in or scale out, based on the specified AdjustmentType.
         *
         * A positive value adds to the instance group's
         * EC2 instance count while a negative number removes instances. If AdjustmentType is set to EXACT_CAPACITY, the number should only be
         * a positive integer.
         *
         * @experimental
         */
        readonly scalingAdjustment: number;
    }
    /**
     * (experimental) The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
     *
     * And an automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period,
     * and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingAction.html
     * @experimental
     */
    interface ScalingActionProperty {
        /**
         * (experimental) Not available for instance groups.
         *
         * Instance groups use the market type specified for the group.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly market?: InstanceMarket;
        /**
         * (experimental) The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.
         *
         * @experimental
         */
        readonly simpleScalingPolicyConfiguration: SimpleScalingPolicyConfigurationProperty;
    }
    /**
     * (experimental) A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingRule.html
     * @experimental
     */
    interface ScalingRuleProperty {
        /**
         * (experimental) The conditions that trigger an automatic scaling activity.
         *
         * @experimental
         */
        readonly action: ScalingActionProperty;
        /**
         * (experimental) A friendly, more verbose description of the automatic scaling rule.
         *
         * @default - None
         * @experimental
         */
        readonly description?: string;
        /**
         * (experimental) The name used to identify an automatic scaling rule.
         *
         * Rule names must be unique within a scaling policy.
         *
         * @experimental
         */
        readonly name: string;
        /**
         * (experimental) The CloudWatch alarm definition that determines when automatic scaling activity is triggered.
         *
         * @experimental
         */
        readonly trigger: ScalingTriggerProperty;
    }
    /**
     * (experimental) The upper and lower EC2 instance limits for an automatic scaling policy.
     *
     * Automatic scaling activities triggered by automatic scaling
     * rules will not cause an instance group to grow above or below these limits.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScalingConstraints.html
     * @experimental
     */
    interface ScalingConstraintsProperty {
        /**
         * (experimental) The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow.
         *
         * Scale-out
         * activities will not add instances beyond this boundary.
         *
         * @experimental
         */
        readonly maxCapacity: number;
        /**
         * (experimental) The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink.
         *
         * Scale-in
         * activities will not terminate instances below this boundary.
         *
         * @experimental
         */
        readonly minCapacity: number;
    }
    /**
     * (experimental) An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_AutoScalingPolicy.html
     * @experimental
     */
    interface AutoScalingPolicyProperty {
        /**
         * (experimental) The upper and lower EC2 instance limits for an automatic scaling policy.
         *
         * Automatic scaling activity will not cause an instance
         * group to grow above or below these limits.
         *
         * @experimental
         */
        readonly constraints: ScalingConstraintsProperty;
        /**
         * (experimental) The scale-in and scale-out rules that comprise the automatic scaling policy.
         *
         * @experimental
         */
        readonly rules: ScalingRuleProperty[];
    }
    /**
     * (experimental) Configuration defining a new instance group.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_InstanceGroupConfig.html
     * @experimental
     */
    interface InstanceGroupConfigProperty {
        /**
         * (experimental) An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster.
         *
         * @default - None
         * @experimental
         */
        readonly autoScalingPolicy?: AutoScalingPolicyProperty;
        /**
         * (experimental) The bid price for each EC2 Spot instance type as defined by InstanceType.
         *
         * Expressed in USD.
         *
         * @default - None
         * @experimental
         */
        readonly bidPrice?: string;
        /**
         * (experimental) The list of configurations supplied for an EMR cluster instance group.
         *
         * @default - None
         * @experimental
         */
        readonly configurations?: ConfigurationProperty[];
        /**
         * (experimental) EBS configurations that will be attached to each EC2 instance in the instance group.
         *
         * @default - None
         * @experimental
         */
        readonly ebsConfiguration?: EbsConfigurationProperty;
        /**
         * (experimental) Target number of instances for the instance group.
         *
         * @experimental
         */
        readonly instanceCount: number;
        /**
         * (experimental) The role of the instance group in the cluster.
         *
         * @experimental
         */
        readonly instanceRole: InstanceRoleType;
        /**
         * (experimental) The EC2 instance type for all instances in the instance group.
         *
         * @experimental
         */
        readonly instanceType: string;
        /**
         * (experimental) Market type of the EC2 instances used to create a cluster node.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly market?: InstanceMarket;
        /**
         * (experimental) Friendly name given to the instance group.
         *
         * @default - None
         * @experimental
         */
        readonly name?: string;
    }
    /**
     * (experimental) The Amazon EC2 Availability Zone configuration of the cluster (job flow).
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_PlacementType.html
     * @experimental
     */
    interface PlacementTypeProperty {
        /**
         * (experimental) The Amazon EC2 Availability Zone for the cluster.
         *
         * AvailabilityZone is used for uniform instance groups, while AvailabilityZones
         * (plural) is used for instance fleets.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly availabilityZone?: string;
        /**
         * (experimental) When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone.
         *
         * AvailabilityZones is used for instance fleets, while AvailabilityZone (singular) is used for uniform instance groups.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly availabilityZones?: string[];
    }
    /**
     * (experimental) A specification of the number and type of Amazon EC2 instances.
     *
     * See the RunJobFlow API for complete documentation on input parameters
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_JobFlowInstancesConfig.html
     * @experimental
     */
    interface InstancesConfigProperty {
        /**
         * (experimental) A list of additional Amazon EC2 security group IDs for the master node.
         *
         * @default - None
         * @experimental
         */
        readonly additionalMasterSecurityGroups?: string[];
        /**
         * (experimental) A list of additional Amazon EC2 security group IDs for the core and task nodes.
         *
         * @default - None
         * @experimental
         */
        readonly additionalSlaveSecurityGroups?: string[];
        /**
         * (experimental) The name of the EC2 key pair that can be used to ssh to the master node as the user called "hadoop.".
         *
         * @default - None
         * @experimental
         */
        readonly ec2KeyName?: string;
        /**
         * (experimental) Applies to clusters that use the uniform instance group configuration.
         *
         * To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC),
         * set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch.
         *
         * @default EMR selected default
         * @experimental
         */
        readonly ec2SubnetId?: string;
        /**
         * (experimental) Applies to clusters that use the instance fleet configuration.
         *
         * When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and
         * launches instances in the optimal subnet.
         *
         * @default EMR selected default
         * @experimental
         */
        readonly ec2SubnetIds?: string[];
        /**
         * (experimental) The identifier of the Amazon EC2 security group for the master node.
         *
         * @default - None
         * @experimental
         */
        readonly emrManagedMasterSecurityGroup?: string;
        /**
         * (experimental) The identifier of the Amazon EC2 security group for the core and task nodes.
         *
         * @default - None
         * @experimental
         */
        readonly emrManagedSlaveSecurityGroup?: string;
        /**
         * (experimental) Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster.
         *
         * @default - 0.18 if the AmiVersion parameter is not set. If AmiVersion is set, the version of Hadoop for that AMI version is used.
         * @experimental
         */
        readonly hadoopVersion?: string;
        /**
         * (experimental) The number of EC2 instances in the cluster.
         *
         * @default 0
         * @experimental
         */
        readonly instanceCount?: number;
        /**
         * (experimental) Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.
         *
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         *
         * @default - None
         * @experimental
         */
        readonly instanceFleets?: InstanceFleetConfigProperty[];
        /**
         * (experimental) Configuration for the instance groups in a cluster.
         *
         * @default - None
         * @experimental
         */
        readonly instanceGroups?: InstanceGroupConfigProperty[];
        /**
         * (experimental) The EC2 instance type of the master node.
         *
         * @default - None
         * @experimental
         */
        readonly masterInstanceType?: string;
        /**
         * (experimental) The Availability Zone in which the cluster runs.
         *
         * @default - EMR selected default
         * @experimental
         */
        readonly placement?: PlacementTypeProperty;
        /**
         * (experimental) The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.
         *
         * @default - None
         * @experimental
         */
        readonly serviceAccessSecurityGroup?: string;
        /**
         * (experimental) The EC2 instance type of the core and task nodes.
         *
         * @default - None
         * @experimental
         */
        readonly slaveInstanceType?: string;
        /**
         * (experimental) Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.
         *
         * @default false
         * @experimental
         */
        readonly terminationProtected?: boolean;
    }
    /**
     * (experimental) Properties for the EMR Cluster Applications.
     *
     * Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching
     * the cluster.
     *
     * See the RunJobFlow API for complete documentation on input parameters
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_Application.html
     * @experimental
     */
    interface ApplicationConfigProperty {
        /**
         * (experimental) This option is for advanced users only.
         *
         * This is meta information about third-party applications that third-party vendors use
         * for testing purposes.
         *
         * @default No additionalInfo
         * @experimental
         */
        readonly additionalInfo?: {
            [key: string]: string;
        };
        /**
         * (experimental) Arguments for Amazon EMR to pass to the application.
         *
         * @default No args
         * @experimental
         */
        readonly args?: string[];
        /**
         * (experimental) The name of the application.
         *
         * @experimental
         */
        readonly name: string;
        /**
         * (experimental) The version of the application.
         *
         * @default No version
         * @experimental
         */
        readonly version?: string;
    }
    /**
     * (experimental) Configuration of the script to run during a bootstrap action.
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_ScriptBootstrapActionConfig.html
     * @experimental
     */
    interface ScriptBootstrapActionConfigProperty {
        /**
         * (experimental) Location of the script to run during a bootstrap action.
         *
         * Can be either a location in Amazon S3 or on a local file system.
         *
         * @experimental
         */
        readonly path: string;
        /**
         * (experimental) A list of command line arguments to pass to the bootstrap action script.
         *
         * @default No args
         * @experimental
         */
        readonly args?: string[];
    }
    /**
     * (experimental) Configuration of a bootstrap action.
     *
     * See the RunJobFlow API for complete documentation on input parameters
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_BootstrapActionConfig.html
     * @experimental
     */
    interface BootstrapActionConfigProperty {
        /**
         * (experimental) The name of the bootstrap action.
         *
         * @experimental
         */
        readonly name: string;
        /**
         * (experimental) The script run by the bootstrap action.
         *
         * @experimental
         */
        readonly scriptBootstrapAction: ScriptBootstrapActionConfigProperty;
    }
    /**
     * (experimental) An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.
     *
     * See the RunJobFlow API for complete documentation on input parameters
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_Configuration.html
     * @experimental
     */
    interface ConfigurationProperty {
        /**
         * (experimental) The classification within a configuration.
         *
         * @default No classification
         * @experimental
         */
        readonly classification?: string;
        /**
         * (experimental) A set of properties specified within a configuration classification.
         *
         * @default No properties
         * @experimental
         */
        readonly properties?: {
            [key: string]: string;
        };
        /**
         * (experimental) A list of additional configurations to apply within a configuration object.
         *
         * @default No configurations
         * @experimental
         */
        readonly configurations?: ConfigurationProperty[];
    }
    /**
     * (experimental) Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration.
     *
     * See the RunJobFlow API for complete documentation on input parameters
     *
     * @see https://docs.aws.amazon.com/emr/latest/APIReference/API_KerberosAttributes.html
     * @experimental
     */
    interface KerberosAttributesProperty {
        /**
         * (experimental) The Active Directory password for ADDomainJoinUser.
         *
         * @default No adDomainJoinPassword
         * @experimental
         */
        readonly adDomainJoinPassword?: string;
        /**
         * (experimental) Required only when establishing a cross-realm trust with an Active Directory domain.
         *
         * A user with sufficient privileges to join
         * resources to the domain.
         *
         * @default No adDomainJoinUser
         * @experimental
         */
        readonly adDomainJoinUser?: string;
        /**
         * (experimental) Required only when establishing a cross-realm trust with a KDC in a different realm.
         *
         * The cross-realm principal password, which
         * must be identical across realms.
         *
         * @default No crossRealmTrustPrincipalPassword
         * @experimental
         */
        readonly crossRealmTrustPrincipalPassword?: string;
        /**
         * (experimental) The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.
         *
         * @default No kdcAdminPassword
         * @experimental
         */
        readonly kdcAdminPassword?: string;
        /**
         * (experimental) The name of the Kerberos realm to which all nodes in a cluster belong.
         *
         * For example, EC2.INTERNAL.
         *
         * @experimental
         */
        readonly realm: string;
    }
}
