# coding: utf-8

"""
    Auth - Application API

    Auth manages access policies for services that need access policies management for their clients. Auth also issues temporary credentials for the services' clients and validates them for the services  # noqa: E501

    OpenAPI spec version: 1.0.3
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from akeyless_auth_api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def authenticate_api_key_policy(self, policy_id, timestamp, nonce, signature, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an API key access policy will be able to get temporary credentials to access the service that created the policy for him. The client must provide a signature that proves his compliance with the policy. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.authenticate_api_key_policy(policy_id, timestamp, nonce, signature, async=True)
        >>> result = thread.get()

        :param async bool
        :param str policy_id: Policy id. (required)
        :param int timestamp: A Unix timestamp which was used for the signature. (required)
        :param str nonce: Random string which was used for the signature. (required)
        :param str signature: A digital signature generated with the private key that complies with the access policy. (required)
        :param str client_ip: The Client's IP for authentication. Relevant only to the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.authenticate_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, **kwargs)  # noqa: E501
            return data

    def authenticate_api_key_policy_with_http_info(self, policy_id, timestamp, nonce, signature, **kwargs):  # noqa: E501
        """Return a temporary access credentials  # noqa: E501

        Client that meet an API key access policy will be able to get temporary credentials to access the service that created the policy for him. The client must provide a signature that proves his compliance with the policy. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.authenticate_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, async=True)
        >>> result = thread.get()

        :param async bool
        :param str policy_id: Policy id. (required)
        :param int timestamp: A Unix timestamp which was used for the signature. (required)
        :param str nonce: Random string which was used for the signature. (required)
        :param str signature: A digital signature generated with the private key that complies with the access policy. (required)
        :param str client_ip: The Client's IP for authentication. Relevant only to the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'timestamp', 'nonce', 'signature', 'client_ip']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate_api_key_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params or
                params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `authenticate_api_key_policy`")  # noqa: E501
        # verify the required parameter 'timestamp' is set
        if ('timestamp' not in params or
                params['timestamp'] is None):
            raise ValueError("Missing the required parameter `timestamp` when calling `authenticate_api_key_policy`")  # noqa: E501
        # verify the required parameter 'nonce' is set
        if ('nonce' not in params or
                params['nonce'] is None):
            raise ValueError("Missing the required parameter `nonce` when calling `authenticate_api_key_policy`")  # noqa: E501
        # verify the required parameter 'signature' is set
        if ('signature' not in params or
                params['signature'] is None):
            raise ValueError("Missing the required parameter `signature` when calling `authenticate_api_key_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_id' in params:
            query_params.append(('policy_id', params['policy_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-api-key-policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def authenticate_uam_api_key_policy(self, policy_id, timestamp, nonce, signature, **kwargs):  # noqa: E501
        """Return a combination of three temporary credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        System's user that meet an API key access policy will be able to get a combination of three temporary credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide a signature that proves his compliance with the policy. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.authenticate_uam_api_key_policy(policy_id, timestamp, nonce, signature, async=True)
        >>> result = thread.get()

        :param async bool
        :param str policy_id: Policy id. (required)
        :param int timestamp: A Unix timestamp which was used for the signature. (required)
        :param str nonce: Random string which was used for the signature. (required)
        :param str signature: A digital signature generated with the private key that complies with the access policy. (required)
        :param str client_ip: The Client's IP for authentication. Relevant only to the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemUserCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.authenticate_uam_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, **kwargs)  # noqa: E501
        else:
            (data) = self.authenticate_uam_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, **kwargs)  # noqa: E501
            return data

    def authenticate_uam_api_key_policy_with_http_info(self, policy_id, timestamp, nonce, signature, **kwargs):  # noqa: E501
        """Return a combination of three temporary credentials for accessing Auth, UAM and KFMs instances.  # noqa: E501

        System's user that meet an API key access policy will be able to get a combination of three temporary credentials signed by Auth for accessing Auth, UAM and KFMs instances. The client must provide a signature that proves his compliance with the policy. In this case the IP address used for authentication will be taken from the http request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.authenticate_uam_api_key_policy_with_http_info(policy_id, timestamp, nonce, signature, async=True)
        >>> result = thread.get()

        :param async bool
        :param str policy_id: Policy id. (required)
        :param int timestamp: A Unix timestamp which was used for the signature. (required)
        :param str nonce: Random string which was used for the signature. (required)
        :param str signature: A digital signature generated with the private key that complies with the access policy. (required)
        :param str client_ip: The Client's IP for authentication. Relevant only to the services that mediate between Auth and their clients in obtaining temporary access credentials.
        :param int creds_expiry: The requested expiration time of the temporary credentials in minutes.
        :return: SystemUserCredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_id', 'timestamp', 'nonce', 'signature', 'client_ip', 'creds_expiry']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method authenticate_uam_api_key_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params or
                params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `authenticate_uam_api_key_policy`")  # noqa: E501
        # verify the required parameter 'timestamp' is set
        if ('timestamp' not in params or
                params['timestamp'] is None):
            raise ValueError("Missing the required parameter `timestamp` when calling `authenticate_uam_api_key_policy`")  # noqa: E501
        # verify the required parameter 'nonce' is set
        if ('nonce' not in params or
                params['nonce'] is None):
            raise ValueError("Missing the required parameter `nonce` when calling `authenticate_uam_api_key_policy`")  # noqa: E501
        # verify the required parameter 'signature' is set
        if ('signature' not in params or
                params['signature'] is None):
            raise ValueError("Missing the required parameter `signature` when calling `authenticate_uam_api_key_policy`")  # noqa: E501

        if 'creds_expiry' in params and params['creds_expiry'] > 60:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam_api_key_policy`, must be a value less than or equal to `60`")  # noqa: E501
        if 'creds_expiry' in params and params['creds_expiry'] < 2:  # noqa: E501
            raise ValueError("Invalid value for parameter `creds_expiry` when calling `authenticate_uam_api_key_policy`, must be a value greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_id' in params:
            query_params.append(('policy_id', params['policy_id']))  # noqa: E501
        if 'timestamp' in params:
            query_params.append(('timestamp', params['timestamp']))  # noqa: E501
        if 'nonce' in params:
            query_params.append(('nonce', params['nonce']))  # noqa: E501
        if 'signature' in params:
            query_params.append(('signature', params['signature']))  # noqa: E501
        if 'client_ip' in params:
            query_params.append(('client_ip', params['client_ip']))  # noqa: E501
        if 'creds_expiry' in params:
            query_params.append(('creds_expiry', params['creds_expiry']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/auth-uam-api-key-policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemUserCredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_account_creds(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access policy to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_account_creds(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param CreateAccountCredsParams body: Policy rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_creds_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_account_creds_with_http_info(self, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to create new account in the UAM service. The UAM service will use this credentials to create an access policy to be used for accessing the account  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_account_creds_with_http_info(body, async=True)
        >>> result = thread.get()

        :param async bool
        :param CreateAccountCredsParams body: Policy rules to be used for accessing the new account. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_account_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/create-account-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_policy(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_policy(akeyless_credentials, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param PolicyParams body: Policy rules and attaches. (required)
        :return: CreatePolicyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.create_policy_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_policy_with_http_info(akeyless_credentials, body, **kwargs)  # noqa: E501
            return data

    def create_policy_with_http_info(self, akeyless_credentials, body, **kwargs):  # noqa: E501
        """Creating a new access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.create_policy_with_http_info(akeyless_credentials, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param PolicyParams body: Policy rules and attaches. (required)
        :return: CreatePolicyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `create_policy`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatePolicyReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_policy(self, akeyless_credentials, policy_id, **kwargs):  # noqa: E501
        """Deleting an existing access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_policy(akeyless_credentials, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str policy_id: Policy id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_policy_with_http_info(akeyless_credentials, policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_policy_with_http_info(akeyless_credentials, policy_id, **kwargs)  # noqa: E501
            return data

    def delete_policy_with_http_info(self, akeyless_credentials, policy_id, **kwargs):  # noqa: E501
        """Deleting an existing access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_policy_with_http_info(akeyless_credentials, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str policy_id: Policy id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `delete_policy`")  # noqa: E501
        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params or
                params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `delete_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in params:
            path_params['policy_id'] = params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/policy/{policy_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_policies(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of access policies  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_policies(akeyless_credentials, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param list[str] filter_keys: Keys array of fields in the policy attaches.
        :param list[str] filter_values: Values array of fields in the policy attaches.
        :param bool include_expired:
        :return: GetPoliciesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_policies_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.get_policies_with_http_info(akeyless_credentials, **kwargs)  # noqa: E501
            return data

    def get_policies_with_http_info(self, akeyless_credentials, **kwargs):  # noqa: E501
        """Geting a list of access policies  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_policies_with_http_info(akeyless_credentials, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param list[str] filter_keys: Keys array of fields in the policy attaches.
        :param list[str] filter_values: Values array of fields in the policy attaches.
        :param bool include_expired:
        :return: GetPoliciesReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'filter_keys', 'filter_values', 'include_expired']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_policies`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter_keys' in params:
            query_params.append(('filter_keys', params['filter_keys']))  # noqa: E501
            collection_formats['filter_keys'] = 'multi'  # noqa: E501
        if 'filter_values' in params:
            query_params.append(('filter_values', params['filter_values']))  # noqa: E501
            collection_formats['filter_values'] = 'multi'  # noqa: E501
        if 'include_expired' in params:
            query_params.append(('include_expired', params['include_expired']))  # noqa: E501

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPoliciesReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_policy(self, akeyless_credentials, policy_id, **kwargs):  # noqa: E501
        """Getting an existing access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_policy(akeyless_credentials, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str policy_id: Policy id. (required)
        :return: GetPolicyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_policy_with_http_info(akeyless_credentials, policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_policy_with_http_info(akeyless_credentials, policy_id, **kwargs)  # noqa: E501
            return data

    def get_policy_with_http_info(self, akeyless_credentials, policy_id, **kwargs):  # noqa: E501
        """Getting an existing access policy.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_policy_with_http_info(akeyless_credentials, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str policy_id: Policy id. (required)
        :return: GetPolicyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `get_policy`")  # noqa: E501
        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params or
                params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `get_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in params:
            path_params['policy_id'] = params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/policy/{policy_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetPolicyReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_signing_key(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_public_signing_key(signing_key_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_signing_key_with_http_info(signing_key_id, **kwargs)  # noqa: E501
            return data

    def get_public_signing_key_with_http_info(self, signing_key_id, **kwargs):  # noqa: E501
        """Getting the public part of the key used by Auth to sign the temporary access credentials.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_public_signing_key_with_http_info(signing_key_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str signing_key_id: The ID of the key used by Auth to sign the temporary access credentials. (required)
        :return: PublicSigningKeyReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['signing_key_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_signing_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'signing_key_id' is set
        if ('signing_key_id' not in params or
                params['signing_key_id'] is None):
            raise ValueError("Missing the required parameter `signing_key_id` when calling `get_public_signing_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'signing_key_id' in params:
            path_params['signing_key_id'] = params['signing_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/public-signing-key/{signing_key_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PublicSigningKeyReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status(async=True)
        >>> result = thread.get()

        :param async bool
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_status  # noqa: E501

        Get Auth server status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_status_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: AuthStatusReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthStatusReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_time(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_time(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_time  # noqa: E501

        Get Auth server time  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_time_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: TimeReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_uam_policy_creds(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access policy or to update an existing access policy in an UAM account. The UAM service will use this credentials to create/update an access policy to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.set_uam_policy_creds(akeyless_auth_creds, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMPolicyCredsParams body: Policy params. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.set_uam_policy_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
        else:
            (data) = self.set_uam_policy_creds_with_http_info(akeyless_auth_creds, body, **kwargs)  # noqa: E501
            return data

    def set_uam_policy_creds_with_http_info(self, akeyless_auth_creds, body, **kwargs):  # noqa: E501
        """Getting temporary access credentials to add a new access policy or to update an existing access policy in an UAM account. The UAM service will use this credentials to create/update an access policy to be used for accessing key fragments.  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.set_uam_policy_creds_with_http_info(akeyless_auth_creds, body, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_auth_creds: Temporary credentials for accessing the endpoint (required)
        :param SetUAMPolicyCredsParams body: Policy params. (required)
        :return: CredentialsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_auth_creds', 'body']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_uam_policy_creds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_auth_creds' is set
        if ('akeyless_auth_creds' not in params or
                params['akeyless_auth_creds'] is None):
            raise ValueError("Missing the required parameter `akeyless_auth_creds` when calling `set_uam_policy_creds`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_uam_policy_creds`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'akeyless_auth_creds' in params:
            header_params['AkeylessAuthCreds'] = params['akeyless_auth_creds']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/set-uam-policy-creds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CredentialsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_policy(self, akeyless_credentials, body, policy_id, **kwargs):  # noqa: E501
        """Updating an existing access policy  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_policy(akeyless_credentials, body, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param PolicyParams body: Policy rules and attaches. (required)
        :param str policy_id: Policy id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_policy_with_http_info(akeyless_credentials, body, policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_policy_with_http_info(akeyless_credentials, body, policy_id, **kwargs)  # noqa: E501
            return data

    def update_policy_with_http_info(self, akeyless_credentials, body, policy_id, **kwargs):  # noqa: E501
        """Updating an existing access policy  # noqa: E501

        This endpoint is accessible only by services that have a permission to access Auth for managing their policies for their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_policy_with_http_info(akeyless_credentials, body, policy_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param PolicyParams body: Policy rules and attaches. (required)
        :param str policy_id: Policy id. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'body', 'policy_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `update_policy`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_policy`")  # noqa: E501
        # verify the required parameter 'policy_id' is set
        if ('policy_id' not in params or
                params['policy_id'] is None):
            raise ValueError("Missing the required parameter `policy_id` when calling `update_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy_id' in params:
            path_params['policy_id'] = params['policy_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/policy/{policy_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def validate_client_credentials(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.validate_client_credentials(akeyless_credentials, client_credentials, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
        else:
            (data) = self.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, **kwargs)  # noqa: E501
            return data

    def validate_client_credentials_with_http_info(self, akeyless_credentials, client_credentials, **kwargs):  # noqa: E501
        """Validate client credentials  # noqa: E501

        Allows the services to validate the temporary access credentials that received from their clients.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.validate_client_credentials_with_http_info(akeyless_credentials, client_credentials, async=True)
        >>> result = thread.get()

        :param async bool
        :param str akeyless_credentials: Temporary credentials for accessing the endpoint (required)
        :param str client_credentials: Temporary credentials for validation (required)
        :return: ValidateClientCredsReplyObj
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['akeyless_credentials', 'client_credentials']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method validate_client_credentials" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'akeyless_credentials' is set
        if ('akeyless_credentials' not in params or
                params['akeyless_credentials'] is None):
            raise ValueError("Missing the required parameter `akeyless_credentials` when calling `validate_client_credentials`")  # noqa: E501
        # verify the required parameter 'client_credentials' is set
        if ('client_credentials' not in params or
                params['client_credentials'] is None):
            raise ValueError("Missing the required parameter `client_credentials` when calling `validate_client_credentials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'client_credentials' in params:
            query_params.append(('client_credentials', params['client_credentials']))  # noqa: E501

        header_params = {}
        if 'akeyless_credentials' in params:
            header_params['Akeyless-Credentials'] = params['akeyless_credentials']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/validate-client-credentials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ValidateClientCredsReplyObj',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
