<a name="readme-top"></a>



<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->
[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]
[![LinkedIn][linkedin-shield]][linkedin-url]

<!-- PROJECT LOGO -->
<br />
<div align="center">
  <h3 align="center">Thread</h3>

  <p align="center">
    A python threading library extension
    <br />
    <a href="https://github.com/caffeine-addictt/thread/issues">Report Bug</a>
    ·
    <a href="https://github.com/caffeine-addictt/thread/issues">Request Feature</a>
  </p>
</div>



<!-- ABOUT THE PROJECT -->
## About The Project
> Wraps around the python threading library and provides extra functionality

Strictly type-safe

Fully compatible with the threading library, this project hopes to provide a more out-of-the-box solution with multi-threaded processing and fetching values from a completed thread, etc.

<br />

**!! Important !!**<br />
THis project is in it's very early stages of development and bugs are to be expected.

<br />

I hope thread will become your threading solution! ♡⸜(˶˃ ᵕ ˂˶)⸝♡

<p align="right">(<a href="#readme-top">back to top</a>)</p>



### Built With

* [![Python 3.11.6+](https://img.shields.io/badge/python-3.11.6+-blue.svg)](https://www.python.org/downloads/release/python-3116/)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- GETTING STARTED -->
## Getting Started

This is an example of how you may give instructions on setting up your project locally.
To get a local copy up and running follow these simple example steps.

### Prerequisites

* Python 3.10+

### Installation

_Below is an example of how you can instruct your audience on installing and setting up your app. This template doesn't rely on any external dependencies or services._

1. Install the package
   ```sh
   pip install -U thread
   ```
2. Import thread into your library!
   ```py
   import thread
   from thread import Thread, ...
   ```

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- USAGE EXAMPLES -->
## Usage

```bash
# Docs soon!!
```

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ROADMAP -->
## Roadmap

- [x] 0.0.1 Release
- [ ] Bug fixes

See the [open issues](https://github.com/caffeine-addictt/thread/issues) for a full list of proposed features (and known issues).

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- CONTRIBUTING -->
## Contributing

Contributions are what make the open source community such an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**. ( ˶ˆᗜˆ˵ )

If you have a suggestion that would make this better, please fork the repo and create a pull request. You can also simply open an issue with the tag "enhancement".
Don't forget to give the project a star! Thanks again!

1. Fork the Project
2. Create your Feature Branch (`git checkout -b feature/AmazingFeature`)
3. Commit your Changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the Branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE.txt` for more information.

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- CONTACT -->
## Contact

Alex - junxiangng63@gmail.com

Project Link: [https://github.com/caffeine-addictt/thread](https://github.com/caffeine-addictt/thread)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ACKNOWLEDGMENTS -->
## Acknowledgments

* [Choose an Open Source License](https://choosealicense.com)
* [GitHub Emoji Cheat Sheet](https://www.webpagefx.com/tools/emoji-cheat-sheet)
* [Malven's Flexbox Cheatsheet](https://flexbox.malven.co/)
* [Malven's Grid Cheatsheet](https://grid.malven.co/)
* [Img Shields](https://shields.io)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/caffeine-addictt/thread.svg?style=for-the-badge
[contributors-url]: https://github.com/caffeine-addictt/thread/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/caffeine-addictt/thread.svg?style=for-the-badge
[forks-url]: https://github.com/caffeine-addictt/thread/network/members
[stars-shield]: https://img.shields.io/github/stars/caffeine-addictt/thread.svg?style=for-the-badge
[stars-url]: https://github.com/caffeine-addictt/thread/stargazers
[issues-shield]: https://img.shields.io/github/issues/caffeine-addictt/thread.svg?style=for-the-badge
[issues-url]: https://github.com/caffeine-addictt/thread/issues
[license-shield]: https://img.shields.io/github/license/caffeine-addictt/thread.svg?style=for-the-badge
[license-url]: https://github.com/caffeine-addictt/thread/blob/master/LICENSE.txt
[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555
[linkedin-url]: https://www.linkedin.com/in/ngjx
