# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from ideastatica_connection_api.models.con_member_forces_in_enum import ConMemberForcesInEnum
from typing import Optional, Set
from typing_extensions import Self

class ConMemberModel(BaseModel):
    """
    ConMemberModel
    """ # noqa: E501
    model_type: Optional[StrictStr] = Field(default=None, alias="modelType")
    forces_in: Optional[ConMemberForcesInEnum] = Field(default=None, alias="forcesIn")
    x: Optional[Union[StrictFloat, StrictInt]] = None
    connected_member_id: Optional[StrictInt] = Field(default=None, alias="connectedMemberId")
    __properties: ClassVar[List[str]] = ["modelType", "forcesIn", "x", "connectedMemberId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConMemberModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if model_type (nullable) is None
        # and model_fields_set contains the field
        if self.model_type is None and "model_type" in self.model_fields_set:
            _dict['modelType'] = None

        # set to None if x (nullable) is None
        # and model_fields_set contains the field
        if self.x is None and "x" in self.model_fields_set:
            _dict['x'] = None

        # set to None if connected_member_id (nullable) is None
        # and model_fields_set contains the field
        if self.connected_member_id is None and "connected_member_id" in self.model_fields_set:
            _dict['connectedMemberId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConMemberModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "modelType": obj.get("modelType"),
            "forcesIn": obj.get("forcesIn"),
            "x": obj.get("x"),
            "connectedMemberId": obj.get("connectedMemberId")
        })
        return _obj


