# coding: utf-8

"""
    Connection Rest API 2.0

    IDEA StatiCa Connection API, used for the automated design and calculation of steel connections.

    The version of the OpenAPI document: 2.0
    Contact: info@ideastatica.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ideastatica_connection_api.models.conversion_mapping import ConversionMapping
from ideastatica_connection_api.models.country_code import CountryCode
from typing import Optional, Set
from typing_extensions import Self

class ConConversionSettings(BaseModel):
    """
    ConConversionSettings
    """ # noqa: E501
    target_design_code: Optional[CountryCode] = Field(default=None, alias="targetDesignCode")
    concrete: Optional[List[ConversionMapping]] = None
    cross_sections: Optional[List[ConversionMapping]] = Field(default=None, alias="crossSections")
    fasteners: Optional[List[ConversionMapping]] = None
    steel: Optional[List[ConversionMapping]] = None
    welds: Optional[List[ConversionMapping]] = None
    bolt_grade: Optional[List[ConversionMapping]] = Field(default=None, alias="boltGrade")
    __properties: ClassVar[List[str]] = ["targetDesignCode", "concrete", "crossSections", "fasteners", "steel", "welds", "boltGrade"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConConversionSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in concrete (list)
        _items = []
        if self.concrete:
            for _item_concrete in self.concrete:
                if _item_concrete:
                    _items.append(_item_concrete.to_dict())
            _dict['concrete'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cross_sections (list)
        _items = []
        if self.cross_sections:
            for _item_cross_sections in self.cross_sections:
                if _item_cross_sections:
                    _items.append(_item_cross_sections.to_dict())
            _dict['crossSections'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fasteners (list)
        _items = []
        if self.fasteners:
            for _item_fasteners in self.fasteners:
                if _item_fasteners:
                    _items.append(_item_fasteners.to_dict())
            _dict['fasteners'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in steel (list)
        _items = []
        if self.steel:
            for _item_steel in self.steel:
                if _item_steel:
                    _items.append(_item_steel.to_dict())
            _dict['steel'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in welds (list)
        _items = []
        if self.welds:
            for _item_welds in self.welds:
                if _item_welds:
                    _items.append(_item_welds.to_dict())
            _dict['welds'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bolt_grade (list)
        _items = []
        if self.bolt_grade:
            for _item_bolt_grade in self.bolt_grade:
                if _item_bolt_grade:
                    _items.append(_item_bolt_grade.to_dict())
            _dict['boltGrade'] = _items
        # set to None if concrete (nullable) is None
        # and model_fields_set contains the field
        if self.concrete is None and "concrete" in self.model_fields_set:
            _dict['concrete'] = None

        # set to None if cross_sections (nullable) is None
        # and model_fields_set contains the field
        if self.cross_sections is None and "cross_sections" in self.model_fields_set:
            _dict['crossSections'] = None

        # set to None if fasteners (nullable) is None
        # and model_fields_set contains the field
        if self.fasteners is None and "fasteners" in self.model_fields_set:
            _dict['fasteners'] = None

        # set to None if steel (nullable) is None
        # and model_fields_set contains the field
        if self.steel is None and "steel" in self.model_fields_set:
            _dict['steel'] = None

        # set to None if welds (nullable) is None
        # and model_fields_set contains the field
        if self.welds is None and "welds" in self.model_fields_set:
            _dict['welds'] = None

        # set to None if bolt_grade (nullable) is None
        # and model_fields_set contains the field
        if self.bolt_grade is None and "bolt_grade" in self.model_fields_set:
            _dict['boltGrade'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConConversionSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "targetDesignCode": obj.get("targetDesignCode"),
            "concrete": [ConversionMapping.from_dict(_item) for _item in obj["concrete"]] if obj.get("concrete") is not None else None,
            "crossSections": [ConversionMapping.from_dict(_item) for _item in obj["crossSections"]] if obj.get("crossSections") is not None else None,
            "fasteners": [ConversionMapping.from_dict(_item) for _item in obj["fasteners"]] if obj.get("fasteners") is not None else None,
            "steel": [ConversionMapping.from_dict(_item) for _item in obj["steel"]] if obj.get("steel") is not None else None,
            "welds": [ConversionMapping.from_dict(_item) for _item in obj["welds"]] if obj.get("welds") is not None else None,
            "boltGrade": [ConversionMapping.from_dict(_item) for _item in obj["boltGrade"]] if obj.get("boltGrade") is not None else None
        })
        return _obj


