### README.md

# vaultlock-py

[![PyPI version](https://badge.fury.io/py/vaultlock-py.svg)](https://badge.fury.io/py/vaultlock-py)
[![Downloads](https://pepy.tech/badge/vaultlock-py)](https://pepy.tech/project/vaultlock-py)

**vaultlock-py** is a secure Python library that integrates:

-  Google Cloud Secret Manager
-  HashiCorp Vault
-  Google Cloud KMS

## Features
- Create, access, and manage secrets in GCP
- Read and write secure secrets in Vault
- Encrypt and decrypt data using GCP KMS
- Unified CLI interface for DevSecOps

## Installation
```bash
pip install vaultlock-py
```

## CLI Usage
```bash
python -m vaultlock.cli --mode gcp --action create --project_id=my-project --path=my-secret --value=secret123
```

## License

This README provides an overview, installation, usage examples (CLI and code), and a brief mention of how it works and license. In an actual project, one might expand the README with troubleshooting tips or more details on authentication.

MIT License

Copyright (c) 2025 Raghava Chellu

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
