import logging  # noqa: INP001
import sqlite3

from .table import QolsysTable

LOGGER = logging.getLogger(__name__)


class QolsysTableTroubleConditions(QolsysTable):
    def __init__(self, db: sqlite3.Connection, cursor: sqlite3.Cursor) -> None:
        super().__init__(db, cursor)
        self._uri = "content://com.qolsys.qolsysprovider.TroubleConditionsContentProvider/trouble_conditions"
        self._table = "trouble_conditions"
        self._abort_on_error = False
        self._implemented = True

        self._columns = [
            "_id",
            "version",
            "opr",
            "partition_id",
            "device_id",
            "device_name",
            "trouble_condition",
            "status",
            "time",
        ]

        self._create_table()
