# Generated by Django 5.1.4 on 2024-12-21 22:26

import core.models
import django.contrib.auth.validators
import django.db.models.deletion
import django.utils.timezone
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="FeatureFlags",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(editable=False, max_length=100, unique=True)),
                (
                    "description",
                    models.TextField(blank=True, editable=False, max_length=500, null=True),
                ),
                ("value", models.BooleanField(default=False)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Feature Flag",
                "verbose_name_plural": "Feature Flags",
            },
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(blank=True, null=True, verbose_name="last login"),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={"unique": "A user with that username already exists."},
                        help_text="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=150,
                        unique=True,
                        validators=[django.contrib.auth.validators.UnicodeUsernameValidator()],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(blank=True, max_length=150, verbose_name="first name"),
                ),
                (
                    "last_name",
                    models.CharField(blank=True, max_length=150, verbose_name="last name"),
                ),
                (
                    "email",
                    models.EmailField(blank=True, max_length=254, verbose_name="email address"),
                ),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(default=django.utils.timezone.now, verbose_name="date joined"),
                ),
                (
                    "stripe_customer_id",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("entitlements", models.JSONField(blank=True, default=list, null=True)),
                ("awaiting_email_verification", models.BooleanField(default=True)),
                ("require_change_password", models.BooleanField(default=False)),
                (
                    "role",
                    models.CharField(
                        choices=[
                            ("DEV", "Developer"),
                            ("STAFF", "Staff"),
                            ("USER", "User"),
                            ("TESTER", "Tester"),
                        ],
                        default="USER",
                        max_length=10,
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "verbose_name": "user",
                "verbose_name_plural": "users",
                "abstract": False,
            },
            managers=[
                ("objects", core.models.CustomUserManager()),
            ],
        ),
        migrations.CreateModel(
            name="Error",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("error", models.CharField(max_length=250, null=True)),
                ("error_code", models.CharField(max_length=100, null=True)),
                ("error_colour", models.CharField(default="danger", max_length=25)),
                ("date", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="LoginLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "service",
                    models.CharField(
                        choices=[("manual", "Manual"), ("magic_link", "Magic Link")],
                        default="manual",
                        max_length=14,
                    ),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("message", models.CharField(max_length=100)),
                (
                    "action",
                    models.CharField(
                        choices=[
                            ("normal", "Normal"),
                            ("modal", "Modal"),
                            ("redirect", "Redirect"),
                        ],
                        default="normal",
                        max_length=10,
                    ),
                ),
                (
                    "action_value",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("extra_type", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "extra_value",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Organization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "stripe_customer_id",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("entitlements", models.JSONField(blank=True, default=list, null=True)),
                (
                    "leader",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="teams_leader_of",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "members",
                    models.ManyToManyField(related_name="teams_joined", to=settings.AUTH_USER_MODEL),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AuditLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("action", models.CharField(max_length=300)),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.organization",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="APIAuthToken",
            fields=[
                (
                    "expires",
                    models.DateTimeField(
                        blank=True,
                        help_text="When the item will expire",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "hashed_key",
                    models.CharField(max_length=128, unique=True, verbose_name="Key"),
                ),
                ("name", models.CharField(max_length=64, verbose_name="Key Name")),
                (
                    "description",
                    models.TextField(blank=True, null=True, verbose_name="Description"),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "last_used",
                    models.DateTimeField(blank=True, null=True, verbose_name="Last Used"),
                ),
                (
                    "scopes",
                    models.JSONField(
                        default=list,
                        help_text="List of permitted scopes",
                        verbose_name="Scopes",
                    ),
                ),
                (
                    "administrator_service_type",
                    models.CharField(
                        blank=True,
                        max_length=64,
                        null=True,
                        verbose_name="Administrator Service Type",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.organization",
                    ),
                ),
            ],
            options={
                "verbose_name": "API Key",
                "verbose_name_plural": "API Keys",
            },
        ),
        migrations.AddField(
            model_name="user",
            name="logged_in_as_team",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="core.organization",
            ),
        ),
        migrations.CreateModel(
            name="PasswordSecret",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(
                        blank=True,
                        help_text="When the item will expire",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("secret", models.TextField(max_length=300)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="password_secrets",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TeamInvitation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(
                        blank=True,
                        help_text="When the item will expire",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                ("code", models.CharField(max_length=10)),
                (
                    "invited_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "team",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="team_invitations",
                        to="core.organization",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="team_invitations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Team Invitation",
                "verbose_name_plural": "Team Invitations",
            },
        ),
        migrations.CreateModel(
            name="TracebackError",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("error", models.CharField(max_length=5000, null=True)),
                ("date", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UserSettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("dark_mode", models.BooleanField(default=True)),
                (
                    "currency",
                    models.CharField(
                        choices=[
                            ("GBP", "British Pound Sterling"),
                            ("EUR", "Euro"),
                            ("USD", "United States Dollar"),
                            ("JPY", "Japanese Yen"),
                            ("INR", "Indian Rupee"),
                            ("AUD", "Australian Dollar"),
                            ("CAD", "Canadian Dollar"),
                        ],
                        default="GBP",
                        max_length=3,
                    ),
                ),
                (
                    "profile_picture",
                    models.ImageField(
                        blank=True,
                        null=True,
                        storage=core.models._public_storage,
                        upload_to="profile_pictures/",
                    ),
                ),
                ("disabled_features", models.JSONField(default=list)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_profile",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Settings",
                "verbose_name_plural": "User Settings",
            },
        ),
        migrations.CreateModel(
            name="VerificationCodes",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(
                        blank=True,
                        help_text="When the item will expire",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                ("active", models.BooleanField(default=True)),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                (
                    "token",
                    models.TextField(default=core.models.RandomCode, editable=False),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "service",
                    models.CharField(
                        choices=[
                            ("create_account", "Create Account"),
                            ("reset_password", "Reset Password"),
                        ],
                        max_length=14,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Verification Code",
                "verbose_name_plural": "Verification Codes",
            },
        ),
        migrations.CreateModel(
            name="EmailSendStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("updated_status_at", models.DateTimeField(auto_now_add=True)),
                ("recipient", models.TextField()),
                (
                    "aws_message_id",
                    models.CharField(blank=True, editable=False, max_length=100, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("send", "Send"),
                            ("reject", "Reject"),
                            ("bounce", "Bounce"),
                            ("complaint", "Complaint"),
                            ("delivery", "Delivery"),
                            ("open", "Open"),
                            ("click", "Click"),
                            ("rendering_failure", "Rendering_Failure"),
                            ("delivery_delay", "Delivery_Delay"),
                            ("subscription", "Subscription"),
                            ("failed_to_send", "Failed_To_Send"),
                            ("pending", "Pending"),
                        ],
                        max_length=20,
                    ),
                ),
                (
                    "sent_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="emails_sent",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organization",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="core.organization",
                    ),
                ),
            ],
            options={
                "constraints": [
                    models.CheckConstraint(
                        condition=models.Q(
                            models.Q(("organization__isnull", False), ("user__isnull", True)),
                            models.Q(("organization__isnull", True), ("user__isnull", False)),
                            _connector="OR",
                        ),
                        name="core_emailsendstatus_check_user_or_organization",
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="TeamMemberPermission",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "scopes",
                    models.JSONField(
                        default=list,
                        help_text="List of permitted scopes",
                        verbose_name="Scopes",
                    ),
                ),
                (
                    "team",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="permissions",
                        to="core.organization",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="team_permissions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("team", "user")},
            },
        ),
    ]
