# Generated by Django 5.1.4 on 2024-12-21 22:26

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("billing", "0001_initial"),
        ("core", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AddField(
            model_name="billingusage",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.organization",
            ),
        ),
        migrations.AddField(
            model_name="billingusage",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="planfeature",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="features",
                to="billing.planfeaturegroup",
            ),
        ),
        migrations.AddField(
            model_name="stripecheckoutsession",
            name="features",
            field=models.ManyToManyField(related_name="checkout_sessions", to="billing.planfeature"),
        ),
        migrations.AddField(
            model_name="stripecheckoutsession",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.organization",
            ),
        ),
        migrations.AddField(
            model_name="stripecheckoutsession",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="stripecheckoutsession",
            name="plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="checkout_sessions",
                to="billing.subscriptionplan",
            ),
        ),
        migrations.AddField(
            model_name="planfeature",
            name="subscription_plan",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="features",
                to="billing.subscriptionplan",
            ),
        ),
        migrations.AddField(
            model_name="usersubscription",
            name="organization",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="core.organization",
            ),
        ),
        migrations.AddField(
            model_name="usersubscription",
            name="subscription_plan",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="billing.subscriptionplan",
            ),
        ),
        migrations.AddField(
            model_name="usersubscription",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddConstraint(
            model_name="billingusage",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    models.Q(("organization__isnull", False), ("user__isnull", True)),
                    models.Q(("organization__isnull", True), ("user__isnull", False)),
                    _connector="OR",
                ),
                name="billing_billingusage_check_user_or_organization",
            ),
        ),
        migrations.AddConstraint(
            model_name="stripecheckoutsession",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    models.Q(("organization__isnull", False), ("user__isnull", True)),
                    models.Q(("organization__isnull", True), ("user__isnull", False)),
                    _connector="OR",
                ),
                name="billing_stripecheckoutsession_check_user_or_organization",
            ),
        ),
        migrations.AddConstraint(
            model_name="usersubscription",
            constraint=models.CheckConstraint(
                condition=models.Q(
                    models.Q(("organization__isnull", False), ("user__isnull", True)),
                    models.Q(("organization__isnull", True), ("user__isnull", False)),
                    _connector="OR",
                ),
                name="billing_usersubscription_check_user_or_organization",
            ),
        ),
    ]
