# mypy-boto3-codeartifact<a id="mypy-boto3-codeartifact"></a>

[![PyPI - mypy-boto3-codeartifact](https://img.shields.io/pypi/v/mypy-boto3-codeartifact.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeartifact)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codeartifact.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeartifact)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-codeartifact?color=blue)](https://pypistats.org/packages/mypy-boto3-codeartifact)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeArtifact 1.17.69](https://boto3.amazonaws.com/v1/documentation/api/1.17.69/reference/services/codeartifact.html#CodeArtifact)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.12.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-codeartifact docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeartifact/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codeartifact](#mypy-boto3-codeartifact)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `CodeArtifact` service.

```bash
python -m pip install boto3-stubs[codeartifact]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codeartifact]` in your environment:
  `python -m pip install 'boto3-stubs[codeartifact]'`

Both type checking and auto-complete should work for `CodeArtifact` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[codeartifact]` in your environment:
  `python -m pip install 'boto3-stubs[codeartifact]'`

Both type checking and auto-complete should work for `CodeArtifact` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codeartifact]` in your environment:
  `python -m pip install 'boto3-stubs[codeartifact]'`
- Run `mypy` as usual

Type checking should work for `CodeArtifact` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codeartifact]` in your environment:
  `python -m pip install 'boto3-stubs[codeartifact]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeArtifact` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`CodeArtifactClient` provides annotations for `boto3.client("codeartifact")`.

```python
import boto3

from mypy_boto3_codeartifact import CodeArtifactClient

client: CodeArtifactClient = boto3.client("codeartifact")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeArtifactClient = session.client("codeartifact")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_codeartifact.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_codeartifact import CodeArtifactClient
from mypy_boto3_codeartifact.paginator import (
    ListDomainsPaginator,
    ListPackageVersionAssetsPaginator,
    ListPackageVersionsPaginator,
    ListPackagesPaginator,
    ListRepositoriesPaginator,
    ListRepositoriesInDomainPaginator,
)

client: CodeArtifactClient = boto3.client("codeartifact")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_package_version_assets_paginator: ListPackageVersionAssetsPaginator = client.get_paginator("list_package_version_assets")
list_package_versions_paginator: ListPackageVersionsPaginator = client.get_paginator("list_package_versions")
list_packages_paginator: ListPackagesPaginator = client.get_paginator("list_packages")
list_repositories_paginator: ListRepositoriesPaginator = client.get_paginator("list_repositories")
list_repositories_in_domain_paginator: ListRepositoriesInDomainPaginator = client.get_paginator("list_repositories_in_domain")
```

### Literals<a id="literals"></a>

`mypy_boto3_codeartifact.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_codeartifact.literals import (
    DomainStatus,
    ExternalConnectionStatus,
    HashAlgorithm,
    ListDomainsPaginatorName,
    ListPackageVersionAssetsPaginatorName,
    ListPackageVersionsPaginatorName,
    ListPackagesPaginatorName,
    ListRepositoriesInDomainPaginatorName,
    ListRepositoriesPaginatorName,
    PackageFormat,
    PackageVersionErrorCode,
    PackageVersionSortType,
    PackageVersionStatus,
)

def check_value(value: DomainStatus) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_codeartifact.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_codeartifact.type_defs import (
    AssetSummaryTypeDef,
    AssociateExternalConnectionResultTypeDef,
    CopyPackageVersionsResultTypeDef,
    CreateDomainResultTypeDef,
    CreateRepositoryResultTypeDef,
    DeleteDomainPermissionsPolicyResultTypeDef,
    DeleteDomainResultTypeDef,
    DeletePackageVersionsResultTypeDef,
    DeleteRepositoryPermissionsPolicyResultTypeDef,
    DeleteRepositoryResultTypeDef,
    DescribeDomainResultTypeDef,
    DescribePackageVersionResultTypeDef,
    DescribeRepositoryResultTypeDef,
    DisassociateExternalConnectionResultTypeDef,
    DisposePackageVersionsResultTypeDef,
    DomainDescriptionTypeDef,
    DomainSummaryTypeDef,
    GetAuthorizationTokenResultTypeDef,
    GetDomainPermissionsPolicyResultTypeDef,
    GetPackageVersionAssetResultTypeDef,
    GetPackageVersionReadmeResultTypeDef,
    GetRepositoryEndpointResultTypeDef,
    GetRepositoryPermissionsPolicyResultTypeDef,
    LicenseInfoTypeDef,
    ListDomainsResultTypeDef,
    ListPackageVersionAssetsResultTypeDef,
    ListPackageVersionDependenciesResultTypeDef,
    ListPackageVersionsResultTypeDef,
    ListPackagesResultTypeDef,
    ListRepositoriesInDomainResultTypeDef,
    ListRepositoriesResultTypeDef,
    ListTagsForResourceResultTypeDef,
    PackageDependencyTypeDef,
    PackageSummaryTypeDef,
    PackageVersionDescriptionTypeDef,
    PackageVersionErrorTypeDef,
    PackageVersionSummaryTypeDef,
    PaginatorConfigTypeDef,
    PutDomainPermissionsPolicyResultTypeDef,
    PutRepositoryPermissionsPolicyResultTypeDef,
    RepositoryDescriptionTypeDef,
    RepositoryExternalConnectionInfoTypeDef,
    RepositorySummaryTypeDef,
    ResourcePolicyTypeDef,
    SuccessfulPackageVersionInfoTypeDef,
    TagTypeDef,
    UpdatePackageVersionsStatusResultTypeDef,
    UpdateRepositoryResultTypeDef,
    UpstreamRepositoryInfoTypeDef,
    UpstreamRepositoryTypeDef,
)

def get_structure() -> AssetSummaryTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-codeartifact` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-codeartifact docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_codeartifact/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
