"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeFunction = exports.InvocationType = exports.LogType = exports.AwsApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const providers_1 = require("./providers");
const waiter_state_machine_1 = require("./waiter-state-machine");
/**
 * Construct that creates a custom resource that will perform
 * a query using the AWS SDK
 */
class AwsApiCall extends api_call_base_1.ApiCallBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_AwsApiCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AwsApiCall);
            }
            throw error;
        }
        this.provider = new providers_1.AssertionsProvider(this, 'SdkProvider');
        this.provider.addPolicyStatementFromSdkCall(props.service, props.api);
        this.name = `${props.service}${props.api}`;
        this.api = props.api;
        this.service = props.service;
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                service: props.service,
                api: props.api,
                expected: aws_cdk_lib_1.Lazy.any({ produce: () => this.expectedResult }),
                actualPath: aws_cdk_lib_1.Lazy.string({ produce: () => this._assertAtPath }),
                stateMachineArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.stateMachineArn }),
                parameters: this.provider.encode(props.parameters),
                flattenResponse: aws_cdk_lib_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.SDK_RESOURCE_TYPE_PREFIX}${this.name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
        // if expectedResult has been configured then that means
        // we are making assertions and we should output the results
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof AwsApiCall) {
                    if (node.expectedResult) {
                        const result = node.apiCallResource.getAttString('assertion');
                        new aws_cdk_lib_1.CfnOutput(node, 'AssertionResults', {
                            value: result,
                        }).overrideLogicalId(`AssertionResults${id}`);
                    }
                }
            },
        });
    }
    assertAtPath(path, expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        this._assertAtPath = path;
        this.expectedResult = expected.result;
        this.flattenResponse = 'true';
        return this;
    }
    waitForAssertions(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_WaiterStateMachineOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.waitForAssertions);
            }
            throw error;
        }
        const waiter = new waiter_state_machine_1.WaiterStateMachine(this, 'WaitFor', {
            ...options,
        });
        this.stateMachineArn = waiter.stateMachineArn;
        this.provider.addPolicyStatementFromSdkCall('states', 'StartExecution');
        waiter.isCompleteProvider.addPolicyStatementFromSdkCall(this.service, this.api);
        this.waiterProvider = waiter.isCompleteProvider;
        return this;
    }
}
exports.AwsApiCall = AwsApiCall;
_a = JSII_RTTI_SYMBOL_1;
AwsApiCall[_a] = { fqn: "@aws-cdk/integ-tests-alpha.AwsApiCall", version: "2.52.1-alpha.0" };
/**
 * Set to Tail to include the execution log in the response.
 * Applies to synchronously invoked functions only.
 */
var LogType;
(function (LogType) {
    /**
     * The log messages are not returned in the response
     */
    LogType["NONE"] = "None";
    /**
     * The log messages are returned in the response
     */
    LogType["TAIL"] = "Tail";
})(LogType = exports.LogType || (exports.LogType = {}));
/**
 * The type of invocation. Default is REQUEST_RESPONE
 */
var InvocationType;
(function (InvocationType) {
    /**
     * Invoke the function asynchronously.
     * Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured).
     * The API response only includes a status code.
     */
    InvocationType["EVENT"] = "Event";
    /**
     * Invoke the function synchronously.
     * Keep the connection open until the function returns a response or times out.
     * The API response includes the function response and additional data.
     */
    InvocationType["REQUEST_RESPONE"] = "RequestResponse";
    /**
     * Validate parameter values and verify that the user
     * or role has permission to invoke the function.
     */
    InvocationType["DRY_RUN"] = "DryRun";
})(InvocationType = exports.InvocationType || (exports.InvocationType = {}));
/**
 * An AWS Lambda Invoke function API call.
 * Use this istead of the generic AwsApiCall in order to
 * invoke a lambda function. This will automatically create
 * the correct permissions to invoke the function
 */
class LambdaInvokeFunction extends AwsApiCall {
    constructor(scope, id, props) {
        super(scope, id, {
            api: 'invoke',
            service: 'Lambda',
            parameters: {
                FunctionName: props.functionName,
                InvocationType: props.invocationType,
                LogType: props.logType,
                Payload: props.payload,
            },
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_LambdaInvokeFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvokeFunction);
            }
            throw error;
        }
        const stack = aws_cdk_lib_1.Stack.of(this);
        // need to give the assertion lambda permission to invoke
        new aws_cdk_lib_1.CfnResource(this, 'Invoke', {
            type: 'AWS::Lambda::Permission',
            properties: {
                Action: 'lambda:InvokeFunction',
                FunctionName: props.functionName,
                Principal: this.provider.handlerRoleArn,
            },
        });
        // the api call is 'invoke', but the permission is 'invokeFunction'
        // so need to handle it specially
        this.provider.addPolicyStatementFromSdkCall('Lambda', 'invokeFunction', [stack.formatArn({
                service: 'lambda',
                resource: 'function',
                arnFormat: aws_cdk_lib_1.ArnFormat.COLON_RESOURCE_NAME,
                resourceName: props.functionName,
            })]);
    }
}
exports.LambdaInvokeFunction = LambdaInvokeFunction;
_b = JSII_RTTI_SYMBOL_1;
LambdaInvokeFunction[_b] = { fqn: "@aws-cdk/integ-tests-alpha.LambdaInvokeFunction", version: "2.52.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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