"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = exports.flatten = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const utils_1 = require("./utils");
/**
 * Flattens a nested object
 *
 * @param object the object to be flattened
 * @returns a flat object with path as keys
 */
function flatten(object) {
    return Object.assign({}, ...function _flatten(child, path = []) {
        return [].concat(...Object.keys(child)
            .map(key => {
            let childKey = Buffer.isBuffer(child[key]) ? child[key].toString('utf8') : child[key];
            // if the value is a json string then treat it as an object
            // and keep recursing. This allows for easier assertions against complex json strings
            if (typeof childKey === 'string') {
                childKey = isJsonString(childKey);
            }
            return typeof childKey === 'object' && childKey !== null
                ? _flatten(childKey, path.concat([key]))
                : ({ [path.concat([key]).join('.')]: childKey });
        }));
    }(object));
}
exports.flatten = flatten;
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        // eslint-disable-next-line
        const AWS = require('aws-sdk');
        console.log(`AWS SDK VERSION: ${AWS.VERSION}`);
        if (!Object.prototype.hasOwnProperty.call(AWS, request.service)) {
            throw Error(`Service ${request.service} does not exist in AWS SDK version ${AWS.VERSION}.`);
        }
        const service = new AWS[request.service]();
        const response = await service[request.api](request.parameters && utils_1.decode(request.parameters)).promise();
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.ResponseMetadata;
        const respond = {
            apiCallResponse: response,
        };
        const flatData = {
            ...flatten(respond),
        };
        const resp = request.flattenResponse === 'true' ? flatData : respond;
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
function isJsonString(value) {
    try {
        return JSON.parse(value);
    }
    catch {
        return value;
    }
}
//# sourceMappingURL=data:application/json;base64,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