#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
const elb = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-elb-integ');
const vpc = new ec2.Vpc(stack, 'VPC', {
    maxAzs: 1
});
new elb.LoadBalancer(stack, 'LB', {
    vpc,
    internetFacing: true,
    listeners: [{
            externalPort: 80,
            allowConnectionsFrom: [ec2.Peer.anyIpv4()]
        }],
    healthCheck: {
        port: 80
    }
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZWxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuZWxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHdDQUF5QztBQUN6QyxxQ0FBc0M7QUFDdEMsOEJBQStCO0FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQzFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsbUJBQW1CLENBQUMsQ0FBQztBQUV0RCxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtJQUNwQyxNQUFNLEVBQUUsQ0FBQztDQUNWLENBQUMsQ0FBQztBQUVILElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO0lBQ2hDLEdBQUc7SUFDSCxjQUFjLEVBQUUsSUFBSTtJQUNwQixTQUFTLEVBQUUsQ0FBQztZQUNWLFlBQVksRUFBRSxFQUFFO1lBQ2hCLG9CQUFvQixFQUFFLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztTQUMzQyxDQUFDO0lBQ0YsV0FBVyxFQUFFO1FBQ1gsSUFBSSxFQUFFLEVBQUU7S0FDVDtDQUNGLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIiMhL3Vzci9iaW4vZW52IG5vZGVcbmltcG9ydCBlYzIgPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtZWMyJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IGVsYiA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1jZGstZWxiLWludGVnJyk7XG5cbmNvbnN0IHZwYyA9IG5ldyBlYzIuVnBjKHN0YWNrLCAnVlBDJywge1xuICBtYXhBenM6IDFcbn0pO1xuXG5uZXcgZWxiLkxvYWRCYWxhbmNlcihzdGFjaywgJ0xCJywge1xuICB2cGMsXG4gIGludGVybmV0RmFjaW5nOiB0cnVlLFxuICBsaXN0ZW5lcnM6IFt7XG4gICAgZXh0ZXJuYWxQb3J0OiA4MCxcbiAgICBhbGxvd0Nvbm5lY3Rpb25zRnJvbTogW2VjMi5QZWVyLmFueUlwdjQoKV1cbiAgfV0sXG4gIGhlYWx0aENoZWNrOiB7XG4gICAgcG9ydDogODBcbiAgfVxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19