# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t
from . import entity_t
from . import identifier_t

__all__: list[str] = [
    "ArgumentValueId",
    "ArgumentValueRefName",
    "FieldArgumentValue",
    "FieldRefIdNameValue",
    "FieldRefNameValue",
    "FieldValue",
    "FieldValueBase",
    "FieldValueBatchReference",
    "FieldValueBoolean",
    "FieldValueDate",
    "FieldValueDatetime",
    "FieldValueFieldOption",
    "FieldValueFieldOptions",
    "FieldValueFiles",
    "FieldValueId",
    "FieldValueIds",
    "FieldValueNotes",
    "FieldValueNull",
    "FieldValueNumeric",
    "FieldValueText",
    "FieldValueTexts",
    "FieldValueType",
    "ValueResolution",
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldRefNameValue",
    unconverted_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldRefNameValue:
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldRefIdNameValue",
    unconverted_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldRefIdNameValue:
    field_id: base_t.ObjectId
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.ArgumentValueRefName",
    unconverted_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class ArgumentValueRefName:
    field_ref_name: str
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.ArgumentValueId",
    unconverted_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class ArgumentValueId:
    field_id: base_t.ObjectId
    value: base_t.JsonValue
    row_index: int | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class FieldValueType(StrEnum):
    FILES = "files"
    TEXT = "text"
    TEXTS = "texts"
    ID = "id"
    IDS = "ids"
    BOOLEAN = "boolean"
    NUMERIC = "numeric"
    BATCH_REFERENCE = "batch_reference"
    FIELD_OPTION = "field_option"
    FIELD_OPTIONS = "field_options"
    NULL_VALUE = "null_value"
    NOTES = "notes"
    DATE = "date"
    DATETIME = "datetime"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueBase:
    type: FieldValueType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueFiles",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueFiles(FieldValueBase):
    type: typing.Literal[FieldValueType.FILES] = FieldValueType.FILES
    file_ids: list[base_t.ObjectId]


# DO NOT MODIFY -- This file is generated by type_spec
class ValueResolution(StrEnum):
    DIRECT = "direct"
    LABEL = "label"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueFieldOption",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueFieldOption(FieldValueBase):
    type: typing.Literal[FieldValueType.FIELD_OPTION] = FieldValueType.FIELD_OPTION
    value: str
    value_resolution: ValueResolution = ValueResolution.DIRECT


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueFieldOptions",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueFieldOptions(FieldValueBase):
    type: typing.Literal[FieldValueType.FIELD_OPTIONS] = FieldValueType.FIELD_OPTIONS
    value: list[str]
    value_resolution: ValueResolution = ValueResolution.DIRECT


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueId",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueId(FieldValueBase):
    type: typing.Literal[FieldValueType.ID] = FieldValueType.ID
    entity_type: entity_t.EntityType
    identifier_key: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueIds",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueIds(FieldValueBase):
    type: typing.Literal[FieldValueType.IDS] = FieldValueType.IDS
    entity_type: entity_t.EntityType
    identifier_keys: list[identifier_t.IdentifierKey]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueText",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueText(FieldValueBase):
    type: typing.Literal[FieldValueType.TEXT] = FieldValueType.TEXT
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueTexts",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueTexts(FieldValueBase):
    type: typing.Literal[FieldValueType.TEXTS] = FieldValueType.TEXTS
    value: list[str]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBoolean",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueBoolean(FieldValueBase):
    type: typing.Literal[FieldValueType.BOOLEAN] = FieldValueType.BOOLEAN
    value: bool


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueNumeric",
    to_string_values={"value"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueNumeric(FieldValueBase):
    type: typing.Literal[FieldValueType.NUMERIC] = FieldValueType.NUMERIC
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueBatchReference",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueBatchReference(FieldValueBase):
    type: typing.Literal[FieldValueType.BATCH_REFERENCE] = FieldValueType.BATCH_REFERENCE
    reference_key: identifier_t.IdentifierKeyBatchReference
    data_key: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueNull",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueNull(FieldValueBase):
    type: typing.Literal[FieldValueType.NULL_VALUE] = FieldValueType.NULL_VALUE


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueNotes",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueNotes(FieldValueBase):
    type: typing.Literal[FieldValueType.NOTES] = FieldValueType.NOTES
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueDate",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueDate(FieldValueBase):
    type: typing.Literal[FieldValueType.DATE] = FieldValueType.DATE
    value: datetime.date


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldValueDatetime",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldValueDatetime(FieldValueBase):
    type: typing.Literal[FieldValueType.DATETIME] = FieldValueType.DATETIME
    value: datetime.datetime


# DO NOT MODIFY -- This file is generated by type_spec
FieldValue = typing.Annotated[
    FieldValueFiles | FieldValueId | FieldValueIds | FieldValueText | FieldValueTexts | FieldValueBoolean | FieldValueNumeric | FieldValueBatchReference | FieldValueFieldOption | FieldValueFieldOptions | FieldValueNull | FieldValueNotes | FieldValueDate | FieldValueDatetime,
    serial_union_annotation(
    named_type_path="sdk.field_values.FieldValue",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.field_values.FieldArgumentValue",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FieldArgumentValue:
    field_key: identifier_t.IdentifierKey
    value: FieldValue
# DO NOT MODIFY -- This file is generated by type_spec
