# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t

__all__: list[str] = [
    "CielabColor",
    "ColorFormat",
    "LChColor",
    "RgbColor",
    "SupportedColorFormatColor",
    "XyzColor",
]


# DO NOT MODIFY -- This file is generated by type_spec
class ColorFormat(StrEnum):
    RGB = "rgb"
    LAB = "lab"
    XYZ = "xyz"
    LCH = "lch"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.data.RgbColor",
    unconverted_keys={"B", "G", "R", "type"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RgbColor:
    type: typing.Literal[ColorFormat.RGB] = ColorFormat.RGB
    R: Decimal
    G: Decimal
    B: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.data.CielabColor",
    unconverted_keys={"L", "a", "b", "type"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class CielabColor:
    type: typing.Literal[ColorFormat.LAB] = ColorFormat.LAB
    L: Decimal
    a: Decimal
    b: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.data.XyzColor",
    unconverted_keys={"X", "Y", "Z", "type"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class XyzColor:
    type: typing.Literal[ColorFormat.XYZ] = ColorFormat.XYZ
    X: Decimal
    Y: Decimal
    Z: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.data.LChColor",
    unconverted_keys={"C", "L", "h", "type"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class LChColor:
    type: typing.Literal[ColorFormat.LCH] = ColorFormat.LCH
    L: Decimal
    C: Decimal
    h: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
SupportedColorFormatColor = typing.Annotated[
    RgbColor | CielabColor | XyzColor | LChColor,
    serial_union_annotation(
    named_type_path="sdk.data.SupportedColorFormatColor",
        discriminator="type",
        discriminator_map={
            "rgb": RgbColor,
            "lab": CielabColor,
            "xyz": XyzColor,
            "lch": LChColor,
        },
    ),
]
# DO NOT MODIFY -- This file is generated by type_spec
