# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from . import base_t
from . import entity_t

__all__: list[str] = [
    "AsyncBatchActionReturn",
    "AsyncBatchRequest",
    "AsyncBatchRequestPath",
    "AsyncBatchResultValue",
    "QueuedAsyncBatchRequest",
    "SavedAsyncBatchActionReturn",
]


# DO NOT MODIFY -- This file is generated by type_spec
class AsyncBatchRequestPath(StrEnum):
    CREATE_RECIPE = "recipes/create_recipe"
    SET_RECIPE_METADATA = "recipes/set_recipe_metadata"
    SET_RECIPE_TAGS = "recipes/set_recipe_tags"
    EDIT_RECIPE_INPUTS = "recipes/edit_recipe_inputs"
    ARCHIVE_RECIPES = "recipes/archive"
    LOCK_RECIPES = "recipes/lock_recipes"
    UNLOCK_RECIPES = "recipes/unlock_recipes"
    ASSOCIATE_EQUIPMENT_INPUT = "equipment/associate_equipment_input"
    INVOKE_UPLOADER = "uploader/invoke_uploader"
    ASSOCIATE_RECIPE_AS_INPUT = "recipes/associate_recipe_as_input"
    CLEAR_RECIPE_OUTPUTS = "recipes/clear_recipe_outputs"
    GRANT_ENTITY_PERMISSIONS = "entity/grant_entity_permissions"
    SET_ENTITY_FIELD_VALUES = "entity/set_entity_field_values"
    ASSOCIATE_RECIPE_AS_LOT = "recipes/associate_recipe_as_lot"
    CREATE_OR_UPDATE_ENTITY = "entity/create_or_update_entity"
    ADD_TIME_SERIES_DATA = "recipes/add_time_series_data"
    LOOKUP_ENTITY = "entity/lookup_entity"
    CREATE_RECIPE_LINK = "recipe_links/create_recipe_link"
    UPSERT_CONDITION_MATCH = "condition_parameters/upsert_condition_match"
    COMPLETE_ASYNC_UPLOAD = "runsheet/complete_async_upload"
    CREATE_MIX_ORDER = "recipes/create_mix_order"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.async_batch.AsyncBatchRequest",
    unconverted_values={"data"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class AsyncBatchRequest:
    path: AsyncBatchRequestPath
    data: base_t.JsonValue
    batch_reference: str
    depends_on: list[str] | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.async_batch.AsyncBatchResultValue",
    unconverted_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class AsyncBatchResultValue:
    data_key: str
    value: base_t.JsonValue


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.async_batch.AsyncBatchActionReturn",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class AsyncBatchActionReturn:
    modification_made: bool
    result_id: base_t.ObjectId | None = None
    entity: entity_t.Entity | None = None
    result_values: list[AsyncBatchResultValue] | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.async_batch.SavedAsyncBatchActionReturn",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SavedAsyncBatchActionReturn:
    identifier: str
    result_data: AsyncBatchActionReturn


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.async_batch.QueuedAsyncBatchRequest",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class QueuedAsyncBatchRequest:
    path: AsyncBatchRequestPath
    batch_reference: str
# DO NOT MODIFY -- This file is generated by type_spec
