# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from ... import base_t
from ... import identifier_t

__all__: list[str] = [
    "AnnotationEdit",
    "AnnotationUpdateType",
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "RecipeOutputEditBase",
    "RecipeOutputMergeAnnotations",
    "RecipeOutputReplaceAnnotations",
    "RecipeOutputUpdateAnnotations",
]

ENDPOINT_METHOD = "POST"
ENDPOINT_PATH = "api/external/recipes/set_recipe_output_annotations"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.AnnotationEdit",
    to_string_values={"lower_value", "upper_value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class AnnotationEdit:
    annotation_type_key: identifier_t.IdentifierKey
    lower_value: Decimal | None = None
    upper_value: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class AnnotationUpdateType(StrEnum):
    MERGE = "merge"
    REPLACE = "replace"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.RecipeOutputEditBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeOutputEditBase:
    recipe_id: base_t.ObjectId
    output_id: base_t.ObjectId
    experiment_num: int
    annotations: list[AnnotationEdit]
    condition_id: base_t.ObjectId | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.RecipeOutputMergeAnnotations",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeOutputMergeAnnotations(RecipeOutputEditBase):
    type: typing.Literal[AnnotationUpdateType.MERGE] = AnnotationUpdateType.MERGE


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.RecipeOutputReplaceAnnotations",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeOutputReplaceAnnotations(RecipeOutputEditBase):
    type: typing.Literal[AnnotationUpdateType.REPLACE] = AnnotationUpdateType.REPLACE


# DO NOT MODIFY -- This file is generated by type_spec
RecipeOutputUpdateAnnotations = typing.Annotated[
    RecipeOutputMergeAnnotations | RecipeOutputReplaceAnnotations,
    serial_union_annotation(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.RecipeOutputUpdateAnnotations",
        discriminator="type",
        discriminator_map={
            "merge": RecipeOutputMergeAnnotations,
            "replace": RecipeOutputReplaceAnnotations,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    updates: list[RecipeOutputUpdateAnnotations]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.set_recipe_output_annotations.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data:
    pass
# DO NOT MODIFY -- This file is generated by type_spec
