# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from ... import async_batch_t
from ... import base_t
from ... import identifier_t

__all__: list[str] = [
    "Arguments",
    "ConditionParameter",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "MatchType",
]

ENDPOINT_METHOD = "POST"
ENDPOINT_PATH = "api/external/condition_parameters/upsert_condition_match"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.condition_parameters.upsert_condition_match.ConditionParameter",
    to_string_values={"max_value", "min_value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class ConditionParameter:
    condition_parameter_key: identifier_t.IdentifierKey
    allow_null: bool
    min_value: Decimal | None = None
    max_value: Decimal | None = None
    categorical_values: list[str | None] | None = None
    match_type: MatchType | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class MatchType(StrEnum):
    ALL = "all"
    EQ = "eq"
    EQCATEGORICAL = "eqCategorical"
    RANGE = "range"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.condition_parameters.upsert_condition_match.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    explicit_name: bool = False
    name: str | None = None
    condition_parameters: list[ConditionParameter] | None = None
    output_conditions: list[identifier_t.IdentifierKey] | None = None
    existing_condition_match: identifier_t.IdentifierKey | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.condition_parameters.upsert_condition_match.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data(async_batch_t.AsyncBatchActionReturn):
    pass
# DO NOT MODIFY -- This file is generated by type_spec
