"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline TS Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineTsProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineTsProject", {
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.ts"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.ts",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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