# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class RouterRoute(pulumi.CustomResource):
    destination_cidr: pulumi.Output[str]
    """
    CIDR block to match on the packet’s destination IP. Changing
    this creates a new routing entry.
    """
    next_hop: pulumi.Output[str]
    """
    IP address of the next hop gateway.  Changing
    this creates a new routing entry.
    """
    region: pulumi.Output[str]
    """
    The region in which to obtain the V2 networking client.
    A networking client is needed to configure a routing entry on a router. If omitted, the
    `region` argument of the provider is used. Changing this creates a new
    routing entry.
    """
    router_id: pulumi.Output[str]
    """
    ID of the router this routing entry belongs to. Changing
    this creates a new routing entry.
    """
    def __init__(__self__, resource_name, opts=None, destination_cidr=None, next_hop=None, region=None, router_id=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates a routing entry on a OpenStack V2 router.


        ## Notes

        The `next_hop` IP address must be directly reachable from the router at the ``networking.RouterRoute``
        resource creation time.  You can ensure that by explicitly specifying a dependency on the ``networking.RouterInterface``
        resource that connects the next hop to the router, as in the example above.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_cidr: CIDR block to match on the packet’s destination IP. Changing
               this creates a new routing entry.
        :param pulumi.Input[str] next_hop: IP address of the next hop gateway.  Changing
               this creates a new routing entry.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure a routing entry on a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               routing entry.
        :param pulumi.Input[str] router_id: ID of the router this routing entry belongs to. Changing
               this creates a new routing entry.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if destination_cidr is None:
                raise TypeError("Missing required property 'destination_cidr'")
            __props__['destination_cidr'] = destination_cidr
            if next_hop is None:
                raise TypeError("Missing required property 'next_hop'")
            __props__['next_hop'] = next_hop
            __props__['region'] = region
            if router_id is None:
                raise TypeError("Missing required property 'router_id'")
            __props__['router_id'] = router_id
        super(RouterRoute, __self__).__init__(
            'openstack:networking/routerRoute:RouterRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, destination_cidr=None, next_hop=None, region=None, router_id=None):
        """
        Get an existing RouterRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_cidr: CIDR block to match on the packet’s destination IP. Changing
               this creates a new routing entry.
        :param pulumi.Input[str] next_hop: IP address of the next hop gateway.  Changing
               this creates a new routing entry.
        :param pulumi.Input[str] region: The region in which to obtain the V2 networking client.
               A networking client is needed to configure a routing entry on a router. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               routing entry.
        :param pulumi.Input[str] router_id: ID of the router this routing entry belongs to. Changing
               this creates a new routing entry.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["destination_cidr"] = destination_cidr
        __props__["next_hop"] = next_hop
        __props__["region"] = region
        __props__["router_id"] = router_id
        return RouterRoute(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

