# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Volume(pulumi.CustomResource):
    attachments: pulumi.Output[list]
    """
    If a volume is attached to an instance, this attribute will
    display the Attachment ID, Instance ID, and the Device as the Instance
    sees it.

      * `device` (`str`)
      * `id` (`str`)
      * `instance_id` (`str`)
    """
    availability_zone: pulumi.Output[str]
    """
    The availability zone for the volume.
    Changing this creates a new volume.
    """
    consistency_group_id: pulumi.Output[str]
    """
    The consistency group to place the volume
    in.
    """
    description: pulumi.Output[str]
    """
    A description of the volume. Changing this updates
    the volume's description.
    """
    enable_online_resize: pulumi.Output[bool]
    """
    When this option is set it allows extending
    attached volumes. Note: updating size of an attached volume requires Cinder
    support for version 3.42 and a compatible storage driver.
    """
    image_id: pulumi.Output[str]
    """
    The image ID from which to create the volume.
    Changing this creates a new volume.
    """
    metadata: pulumi.Output[dict]
    """
    Metadata key/value pairs to associate with the volume.
    Changing this updates the existing volume metadata.
    """
    multiattach: pulumi.Output[bool]
    """
    Allow the volume to be attached to more than one Compute instance.
    """
    name: pulumi.Output[str]
    """
    A unique name for the volume. Changing this updates the
    volume's name.
    """
    region: pulumi.Output[str]
    """
    The region in which to create the volume. If
    omitted, the `region` argument of the provider is used. Changing this
    creates a new volume.
    """
    scheduler_hints: pulumi.Output[list]
    """
    Provide the Cinder scheduler with hints on where
    to instantiate a volume in the OpenStack cloud. The available hints are described below.

      * `additionalProperties` (`dict`) - Arbitrary key/value pairs of additional
        properties to pass to the scheduler.
      * `differentHosts` (`list`) - The volume should be scheduled on a 
        different host from the set of volumes specified in the list provided.
      * `localToInstance` (`str`) - An instance UUID. The volume should be 
        scheduled on the same host as the instance.
      * `query` (`str`) - A conditional query that a back-end must pass in
        order to host a volume. The query must use the `JsonFilter` syntax
        which is described
        [here](https://docs.openstack.org/cinder/latest/configuration/block-storage/scheduler-filters.html#jsonfilter).
        At this time, only simple queries are supported. Compound queries using
        `and`, `or`, or `not` are not supported. An example of a simple query is:
      * `sameHosts` (`list`) - A list of volume UUIDs. The volume should be
        scheduled on the same host as another volume specified in the list provided.
    """
    size: pulumi.Output[float]
    """
    The size of the volume to create (in gigabytes).
    """
    snapshot_id: pulumi.Output[str]
    """
    The snapshot ID from which to create the volume.
    Changing this creates a new volume.
    """
    source_replica: pulumi.Output[str]
    """
    The volume ID to replicate with.
    """
    source_vol_id: pulumi.Output[str]
    """
    The volume ID from which to create the volume.
    Changing this creates a new volume.
    """
    volume_type: pulumi.Output[str]
    """
    The type of volume to create.
    Changing this creates a new volume.
    """
    def __init__(__self__, resource_name, opts=None, availability_zone=None, consistency_group_id=None, description=None, enable_online_resize=None, image_id=None, metadata=None, multiattach=None, name=None, region=None, scheduler_hints=None, size=None, snapshot_id=None, source_replica=None, source_vol_id=None, volume_type=None, __props__=None, __name__=None, __opts__=None):
        """
        Manages a V3 volume resource within OpenStack.



        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[dict] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[bool] multiattach: Allow the volume to be attached to more than one Compute instance.
        :param pulumi.Input[str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[list] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[float] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[str] source_vol_id: The volume ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] volume_type: The type of volume to create.
               Changing this creates a new volume.

        The **scheduler_hints** object supports the following:

          * `additionalProperties` (`pulumi.Input[dict]`) - Arbitrary key/value pairs of additional
            properties to pass to the scheduler.
          * `differentHosts` (`pulumi.Input[list]`) - The volume should be scheduled on a 
            different host from the set of volumes specified in the list provided.
          * `localToInstance` (`pulumi.Input[str]`) - An instance UUID. The volume should be 
            scheduled on the same host as the instance.
          * `query` (`pulumi.Input[str]`) - A conditional query that a back-end must pass in
            order to host a volume. The query must use the `JsonFilter` syntax
            which is described
            [here](https://docs.openstack.org/cinder/latest/configuration/block-storage/scheduler-filters.html#jsonfilter).
            At this time, only simple queries are supported. Compound queries using
            `and`, `or`, or `not` are not supported. An example of a simple query is:
          * `sameHosts` (`pulumi.Input[list]`) - A list of volume UUIDs. The volume should be
            scheduled on the same host as another volume specified in the list provided.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['availability_zone'] = availability_zone
            __props__['consistency_group_id'] = consistency_group_id
            __props__['description'] = description
            __props__['enable_online_resize'] = enable_online_resize
            __props__['image_id'] = image_id
            __props__['metadata'] = metadata
            __props__['multiattach'] = multiattach
            __props__['name'] = name
            __props__['region'] = region
            __props__['scheduler_hints'] = scheduler_hints
            if size is None:
                raise TypeError("Missing required property 'size'")
            __props__['size'] = size
            __props__['snapshot_id'] = snapshot_id
            __props__['source_replica'] = source_replica
            __props__['source_vol_id'] = source_vol_id
            __props__['volume_type'] = volume_type
            __props__['attachments'] = None
        super(Volume, __self__).__init__(
            'openstack:blockstorage/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, attachments=None, availability_zone=None, consistency_group_id=None, description=None, enable_online_resize=None, image_id=None, metadata=None, multiattach=None, name=None, region=None, scheduler_hints=None, size=None, snapshot_id=None, source_replica=None, source_vol_id=None, volume_type=None):
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] attachments: If a volume is attached to an instance, this attribute will
               display the Attachment ID, Instance ID, and the Device as the Instance
               sees it.
        :param pulumi.Input[str] availability_zone: The availability zone for the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] consistency_group_id: The consistency group to place the volume
               in.
        :param pulumi.Input[str] description: A description of the volume. Changing this updates
               the volume's description.
        :param pulumi.Input[bool] enable_online_resize: When this option is set it allows extending
               attached volumes. Note: updating size of an attached volume requires Cinder
               support for version 3.42 and a compatible storage driver.
        :param pulumi.Input[str] image_id: The image ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[dict] metadata: Metadata key/value pairs to associate with the volume.
               Changing this updates the existing volume metadata.
        :param pulumi.Input[bool] multiattach: Allow the volume to be attached to more than one Compute instance.
        :param pulumi.Input[str] name: A unique name for the volume. Changing this updates the
               volume's name.
        :param pulumi.Input[str] region: The region in which to create the volume. If
               omitted, the `region` argument of the provider is used. Changing this
               creates a new volume.
        :param pulumi.Input[list] scheduler_hints: Provide the Cinder scheduler with hints on where
               to instantiate a volume in the OpenStack cloud. The available hints are described below.
        :param pulumi.Input[float] size: The size of the volume to create (in gigabytes).
        :param pulumi.Input[str] snapshot_id: The snapshot ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] source_replica: The volume ID to replicate with.
        :param pulumi.Input[str] source_vol_id: The volume ID from which to create the volume.
               Changing this creates a new volume.
        :param pulumi.Input[str] volume_type: The type of volume to create.
               Changing this creates a new volume.

        The **attachments** object supports the following:

          * `device` (`pulumi.Input[str]`)
          * `id` (`pulumi.Input[str]`)
          * `instance_id` (`pulumi.Input[str]`)

        The **scheduler_hints** object supports the following:

          * `additionalProperties` (`pulumi.Input[dict]`) - Arbitrary key/value pairs of additional
            properties to pass to the scheduler.
          * `differentHosts` (`pulumi.Input[list]`) - The volume should be scheduled on a 
            different host from the set of volumes specified in the list provided.
          * `localToInstance` (`pulumi.Input[str]`) - An instance UUID. The volume should be 
            scheduled on the same host as the instance.
          * `query` (`pulumi.Input[str]`) - A conditional query that a back-end must pass in
            order to host a volume. The query must use the `JsonFilter` syntax
            which is described
            [here](https://docs.openstack.org/cinder/latest/configuration/block-storage/scheduler-filters.html#jsonfilter).
            At this time, only simple queries are supported. Compound queries using
            `and`, `or`, or `not` are not supported. An example of a simple query is:
          * `sameHosts` (`pulumi.Input[list]`) - A list of volume UUIDs. The volume should be
            scheduled on the same host as another volume specified in the list provided.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["attachments"] = attachments
        __props__["availability_zone"] = availability_zone
        __props__["consistency_group_id"] = consistency_group_id
        __props__["description"] = description
        __props__["enable_online_resize"] = enable_online_resize
        __props__["image_id"] = image_id
        __props__["metadata"] = metadata
        __props__["multiattach"] = multiattach
        __props__["name"] = name
        __props__["region"] = region
        __props__["scheduler_hints"] = scheduler_hints
        __props__["size"] = size
        __props__["snapshot_id"] = snapshot_id
        __props__["source_replica"] = source_replica
        __props__["source_vol_id"] = source_vol_id
        __props__["volume_type"] = volume_type
        return Volume(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

