# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.general_notification_preference import GeneralNotificationPreference
from empire_platform_api_public_client.models.general_notification_preference_with_sms import GeneralNotificationPreferenceWithSms
from typing import Optional, Set
from typing_extensions import Self

class UserPreferencesGeneralNotifications(BaseModel):
    """
    UserPreferencesGeneralNotifications
    """ # noqa: E501
    critical_alert: GeneralNotificationPreferenceWithSms = Field(alias="criticalAlert")
    critical: GeneralNotificationPreference
    major: GeneralNotificationPreference
    normal: GeneralNotificationPreference
    __properties: ClassVar[List[str]] = ["criticalAlert", "critical", "major", "normal"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserPreferencesGeneralNotifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of critical_alert
        if self.critical_alert:
            _dict['criticalAlert'] = self.critical_alert.to_dict()
        # override the default output from pydantic by calling `to_dict()` of critical
        if self.critical:
            _dict['critical'] = self.critical.to_dict()
        # override the default output from pydantic by calling `to_dict()` of major
        if self.major:
            _dict['major'] = self.major.to_dict()
        # override the default output from pydantic by calling `to_dict()` of normal
        if self.normal:
            _dict['normal'] = self.normal.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserPreferencesGeneralNotifications from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "criticalAlert": GeneralNotificationPreferenceWithSms.from_dict(obj["criticalAlert"]) if obj.get("criticalAlert") is not None else None,
            "critical": GeneralNotificationPreference.from_dict(obj["critical"]) if obj.get("critical") is not None else None,
            "major": GeneralNotificationPreference.from_dict(obj["major"]) if obj.get("major") is not None else None,
            "normal": GeneralNotificationPreference.from_dict(obj["normal"]) if obj.get("normal") is not None else None
        })
        return _obj


