# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.platform_appearance import PlatformAppearance
from empire_platform_api_public_client.models.timescale_preferences import TimescalePreferences
from empire_platform_api_public_client.models.user_preferences_general_notifications import UserPreferencesGeneralNotifications
from empire_platform_api_public_client.models.user_preferences_subscription_notifications import UserPreferencesSubscriptionNotifications
from typing import Optional, Set
from typing_extensions import Self

class UserPreferences(BaseModel):
    """
    UserPreferences
    """ # noqa: E501
    general_notifications: UserPreferencesGeneralNotifications = Field(alias="generalNotifications")
    subscription_notifications: UserPreferencesSubscriptionNotifications = Field(alias="subscriptionNotifications")
    appearance: PlatformAppearance
    timescale_preferences: TimescalePreferences = Field(alias="timescalePreferences")
    __properties: ClassVar[List[str]] = ["generalNotifications", "subscriptionNotifications", "appearance", "timescalePreferences"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserPreferences from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of general_notifications
        if self.general_notifications:
            _dict['generalNotifications'] = self.general_notifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subscription_notifications
        if self.subscription_notifications:
            _dict['subscriptionNotifications'] = self.subscription_notifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of timescale_preferences
        if self.timescale_preferences:
            _dict['timescalePreferences'] = self.timescale_preferences.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserPreferences from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "generalNotifications": UserPreferencesGeneralNotifications.from_dict(obj["generalNotifications"]) if obj.get("generalNotifications") is not None else None,
            "subscriptionNotifications": UserPreferencesSubscriptionNotifications.from_dict(obj["subscriptionNotifications"]) if obj.get("subscriptionNotifications") is not None else None,
            "appearance": obj.get("appearance"),
            "timescalePreferences": TimescalePreferences.from_dict(obj["timescalePreferences"]) if obj.get("timescalePreferences") is not None else None
        })
        return _obj


