# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from empire_platform_api_public_client.models.return_auction import ReturnAuction
from empire_platform_api_public_client.models.secondary_market_return_request_status import SecondaryMarketReturnRequestStatus
from empire_platform_api_public_client.models.source_auction_display_data import SourceAuctionDisplayData
from typing import Optional, Set
from typing_extensions import Self

class SecondaryMarketReturnRequest(BaseModel):
    """
    SecondaryMarketReturnRequest
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    source_auction: SourceAuctionDisplayData = Field(alias="sourceAuction")
    return_auction: ReturnAuction = Field(alias="returnAuction")
    returned_capacity: StrictInt = Field(description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers", alias="returnedCapacity")
    successfully_allocated_capacity: Optional[StrictInt] = Field(default=None, description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers", alias="successfullyAllocatedCapacity")
    price: Optional[Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    status: SecondaryMarketReturnRequestStatus
    organisation_name: StrictStr = Field(alias="organisationName")
    __properties: ClassVar[List[str]] = ["id", "sourceAuction", "returnAuction", "returnedCapacity", "successfullyAllocatedCapacity", "price", "status", "organisationName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecondaryMarketReturnRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of source_auction
        if self.source_auction:
            _dict['sourceAuction'] = self.source_auction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_auction
        if self.return_auction:
            _dict['returnAuction'] = self.return_auction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecondaryMarketReturnRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "sourceAuction": SourceAuctionDisplayData.from_dict(obj["sourceAuction"]) if obj.get("sourceAuction") is not None else None,
            "returnAuction": ReturnAuction.from_dict(obj["returnAuction"]) if obj.get("returnAuction") is not None else None,
            "returnedCapacity": obj.get("returnedCapacity"),
            "successfullyAllocatedCapacity": obj.get("successfullyAllocatedCapacity"),
            "price": obj.get("price"),
            "status": obj.get("status"),
            "organisationName": obj.get("organisationName")
        })
        return _obj


