# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.date_period import DatePeriod
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.other_party import OtherParty
from empire_platform_api_public_client.models.secondary_market_day_ahead_or_intra_day_transfer_request_mtus import SecondaryMarketDayAheadOrIntraDayTransferRequestMtus
from empire_platform_api_public_client.models.secondary_market_transfer_request_status import SecondaryMarketTransferRequestStatus
from typing import Optional, Set
from typing_extensions import Self

class SecondaryMarketDayAheadOrIntraDayTransferRequest(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayTransferRequest
    """ # noqa: E501
    timescale: AuctionTimescale
    delivery_period: DatePeriod = Field(alias="deliveryPeriod")
    direction: BorderDirection
    requested_at: datetime = Field(description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="requestedAt")
    completed_at: Optional[datetime] = Field(default=None, description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="completedAt")
    expires_at: datetime = Field(description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="expiresAt")
    sender: OtherParty
    receiver: OtherParty
    status: SecondaryMarketTransferRequestStatus
    resolution: MtuSize
    mtus: List[SecondaryMarketDayAheadOrIntraDayTransferRequestMtus]
    __properties: ClassVar[List[str]] = ["timescale", "deliveryPeriod", "direction", "requestedAt", "completedAt", "expiresAt", "sender", "receiver", "status", "resolution", "mtus"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayTransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender
        if self.sender:
            _dict['sender'] = self.sender.to_dict()
        # override the default output from pydantic by calling `to_dict()` of receiver
        if self.receiver:
            _dict['receiver'] = self.receiver.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in mtus (list)
        _items = []
        if self.mtus:
            for _item_mtus in self.mtus:
                if _item_mtus:
                    _items.append(_item_mtus.to_dict())
            _dict['mtus'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayTransferRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timescale": obj.get("timescale"),
            "deliveryPeriod": DatePeriod.from_dict(obj["deliveryPeriod"]) if obj.get("deliveryPeriod") is not None else None,
            "direction": obj.get("direction"),
            "requestedAt": obj.get("requestedAt"),
            "completedAt": obj.get("completedAt"),
            "expiresAt": obj.get("expiresAt"),
            "sender": OtherParty.from_dict(obj["sender"]) if obj.get("sender") is not None else None,
            "receiver": OtherParty.from_dict(obj["receiver"]) if obj.get("receiver") is not None else None,
            "status": obj.get("status"),
            "resolution": obj.get("resolution"),
            "mtus": [SecondaryMarketDayAheadOrIntraDayTransferRequestMtus.from_dict(_item) for _item in obj["mtus"]] if obj.get("mtus") is not None else None
        })
        return _obj


