# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.address import Address
from empire_platform_api_public_client.models.finance_overview import FinanceOverview
from empire_platform_api_public_client.models.organisation_status import OrganisationStatus
from empire_platform_api_public_client.models.organisation_type import OrganisationType
from empire_platform_api_public_client.models.participant_overview_data_contact_information import ParticipantOverviewDataContactInformation
from empire_platform_api_public_client.models.participant_overview_data_organisation_members import ParticipantOverviewDataOrganisationMembers
from typing import Optional, Set
from typing_extensions import Self

class ParticipantOverviewData(BaseModel):
    """
    ParticipantOverviewData
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    name: StrictStr
    type: OrganisationType
    status: OrganisationStatus
    billing_address: Address = Field(alias="billingAddress")
    finance_overview: FinanceOverview = Field(alias="financeOverview")
    organisation_members: ParticipantOverviewDataOrganisationMembers = Field(alias="organisationMembers")
    contact_information: ParticipantOverviewDataContactInformation = Field(alias="contactInformation")
    __properties: ClassVar[List[str]] = ["id", "name", "type", "status", "billingAddress", "financeOverview", "organisationMembers", "contactInformation"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParticipantOverviewData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billingAddress'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of finance_overview
        if self.finance_overview:
            _dict['financeOverview'] = self.finance_overview.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organisation_members
        if self.organisation_members:
            _dict['organisationMembers'] = self.organisation_members.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact_information
        if self.contact_information:
            _dict['contactInformation'] = self.contact_information.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParticipantOverviewData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "billingAddress": Address.from_dict(obj["billingAddress"]) if obj.get("billingAddress") is not None else None,
            "financeOverview": FinanceOverview.from_dict(obj["financeOverview"]) if obj.get("financeOverview") is not None else None,
            "organisationMembers": ParticipantOverviewDataOrganisationMembers.from_dict(obj["organisationMembers"]) if obj.get("organisationMembers") is not None else None,
            "contactInformation": ParticipantOverviewDataContactInformation.from_dict(obj["contactInformation"]) if obj.get("contactInformation") is not None else None
        })
        return _obj


