# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.organisation_auth_method import OrganisationAuthMethod
from empire_platform_api_public_client.models.organisation_contact_information import OrganisationContactInformation
from empire_platform_api_public_client.models.organisation_file_settings import OrganisationFileSettings
from empire_platform_api_public_client.models.organisation_market_settings import OrganisationMarketSettings
from empire_platform_api_public_client.models.organisation_status import OrganisationStatus
from typing import Optional, Set
from typing_extensions import Self

class ParticipantOrganisationDetails(BaseModel):
    """
    ParticipantOrganisationDetails
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    status: OrganisationStatus
    name: StrictStr
    auth_method: OrganisationAuthMethod = Field(alias="authMethod")
    contact_information: OrganisationContactInformation = Field(alias="contactInformation")
    market_settings: OrganisationMarketSettings = Field(alias="marketSettings")
    file_settings: OrganisationFileSettings = Field(alias="fileSettings")
    __properties: ClassVar[List[str]] = ["id", "status", "name", "authMethod", "contactInformation", "marketSettings", "fileSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParticipantOrganisationDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of contact_information
        if self.contact_information:
            _dict['contactInformation'] = self.contact_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of market_settings
        if self.market_settings:
            _dict['marketSettings'] = self.market_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file_settings
        if self.file_settings:
            _dict['fileSettings'] = self.file_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParticipantOrganisationDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "status": obj.get("status"),
            "name": obj.get("name"),
            "authMethod": obj.get("authMethod"),
            "contactInformation": OrganisationContactInformation.from_dict(obj["contactInformation"]) if obj.get("contactInformation") is not None else None,
            "marketSettings": OrganisationMarketSettings.from_dict(obj["marketSettings"]) if obj.get("marketSettings") is not None else None,
            "fileSettings": OrganisationFileSettings.from_dict(obj["fileSettings"]) if obj.get("fileSettings") is not None else None
        })
        return _obj


