# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.dashboard_next_nomination_gate import DashboardNextNominationGate
from empire_platform_api_public_client.models.participant_dashboard_next_auction import ParticipantDashboardNextAuction
from typing import Optional, Set
from typing_extensions import Self

class ParticipantDashboardNextAuctionsAndNominationGates(BaseModel):
    """
    ParticipantDashboardNextAuctionsAndNominationGates
    """ # noqa: E501
    nomination_gates: List[DashboardNextNominationGate] = Field(alias="nominationGates")
    day_ahead_auctions: List[ParticipantDashboardNextAuction] = Field(alias="dayAheadAuctions")
    intra_day_auctions: List[ParticipantDashboardNextAuction] = Field(alias="intraDayAuctions")
    __properties: ClassVar[List[str]] = ["nominationGates", "dayAheadAuctions", "intraDayAuctions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParticipantDashboardNextAuctionsAndNominationGates from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in nomination_gates (list)
        _items = []
        if self.nomination_gates:
            for _item_nomination_gates in self.nomination_gates:
                if _item_nomination_gates:
                    _items.append(_item_nomination_gates.to_dict())
            _dict['nominationGates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in day_ahead_auctions (list)
        _items = []
        if self.day_ahead_auctions:
            for _item_day_ahead_auctions in self.day_ahead_auctions:
                if _item_day_ahead_auctions:
                    _items.append(_item_day_ahead_auctions.to_dict())
            _dict['dayAheadAuctions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in intra_day_auctions (list)
        _items = []
        if self.intra_day_auctions:
            for _item_intra_day_auctions in self.intra_day_auctions:
                if _item_intra_day_auctions:
                    _items.append(_item_intra_day_auctions.to_dict())
            _dict['intraDayAuctions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParticipantDashboardNextAuctionsAndNominationGates from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "nominationGates": [DashboardNextNominationGate.from_dict(_item) for _item in obj["nominationGates"]] if obj.get("nominationGates") is not None else None,
            "dayAheadAuctions": [ParticipantDashboardNextAuction.from_dict(_item) for _item in obj["dayAheadAuctions"]] if obj.get("dayAheadAuctions") is not None else None,
            "intraDayAuctions": [ParticipantDashboardNextAuction.from_dict(_item) for _item in obj["intraDayAuctions"]] if obj.get("intraDayAuctions") is not None else None
        })
        return _obj


