# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from empire_platform_api_public_client.models.message import Message
from typing import Optional, Set
from typing_extensions import Self

class ParticipantDashboardMessages(BaseModel):
    """
    ParticipantDashboardMessages
    """ # noqa: E501
    general: Annotated[List[Message], Field(max_length=3)]
    participant: Annotated[List[Message], Field(max_length=3)]
    __properties: ClassVar[List[str]] = ["general", "participant"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParticipantDashboardMessages from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in general (list)
        _items = []
        if self.general:
            for _item_general in self.general:
                if _item_general:
                    _items.append(_item_general.to_dict())
            _dict['general'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in participant (list)
        _items = []
        if self.participant:
            for _item_participant in self.participant:
                if _item_participant:
                    _items.append(_item_participant.to_dict())
            _dict['participant'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParticipantDashboardMessages from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "general": [Message.from_dict(_item) for _item in obj["general"]] if obj.get("general") is not None else None,
            "participant": [Message.from_dict(_item) for _item in obj["participant"]] if obj.get("participant") is not None else None
        })
        return _obj


