# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.sage_code import SageCode
from typing import Optional, Set
from typing_extensions import Self

class InvoiceLineItem(BaseModel):
    """
    InvoiceLineItem
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique (at least locally) identifier for the record in UUID4 format  * records received nullable identifiers through GET requests should have the property filled out * records sent to PUT endpoints:   - if property is filled out => backend is expected to update the record   - if property is null or missing => backend is expected to create a new record   - if list of records does not contain the record identifier => backend is expected to delete the record ")
    code: SageCode
    direction: BorderDirection
    delivery_month: date = Field(description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-01` format ", alias="deliveryMonth")
    net_amount: Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places", alias="netAmount")
    vat_rate: Union[Annotated[float, Field(multiple_of=0.01, le=100, strict=True, ge=0)], Annotated[int, Field(le=100, strict=True, ge=0)]] = Field(description="Percentage values, accepted with a precision of maximum 2 decimal places", alias="vatRate")
    vat_amount: Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places", alias="vatAmount")
    gross_amount: Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places", alias="grossAmount")
    manually_added: StrictBool = Field(alias="manuallyAdded")
    __properties: ClassVar[List[str]] = ["id", "code", "direction", "deliveryMonth", "netAmount", "vatRate", "vatAmount", "grossAmount", "manuallyAdded"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvoiceLineItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvoiceLineItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "direction": obj.get("direction"),
            "deliveryMonth": obj.get("deliveryMonth"),
            "netAmount": obj.get("netAmount"),
            "vatRate": obj.get("vatRate"),
            "vatAmount": obj.get("vatAmount"),
            "grossAmount": obj.get("grossAmount"),
            "manuallyAdded": obj.get("manuallyAdded")
        })
        return _obj


