# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from empire_platform_api_public_client.models.attachment import Attachment
from empire_platform_api_public_client.models.date_period import DatePeriod
from empire_platform_api_public_client.models.invoice_history import InvoiceHistory
from empire_platform_api_public_client.models.invoice_line_item import InvoiceLineItem
from empire_platform_api_public_client.models.invoice_participant_details import InvoiceParticipantDetails
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.invoice_summary import InvoiceSummary
from empire_platform_api_public_client.models.invoice_vat_rate import InvoiceVatRate
from typing import Optional, Set
from typing_extensions import Self

class InvoiceDetails(BaseModel):
    """
    InvoiceDetails
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    group_id: StrictStr = Field(description="Unique identifier for the record in UUID4 format", alias="groupId")
    display_id: StrictStr = Field(alias="displayId")
    participant: InvoiceParticipantDetails
    period: DatePeriod
    net_amount: Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places", alias="netAmount")
    gross_amount: Union[Annotated[float, Field(multiple_of=0.01, strict=True)], Annotated[int, Field(strict=True)]] = Field(description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places", alias="grossAmount")
    due_date: Optional[date] = Field(default=None, description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ", alias="dueDate")
    sent_date: Optional[date] = Field(default=None, description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ", alias="sentDate")
    paid_date: Optional[date] = Field(default=None, description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ", alias="paidDate")
    status: InvoiceStatus
    last_status_change: datetime = Field(description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="lastStatusChange")
    sendable: StrictBool
    line_items: List[InvoiceLineItem] = Field(alias="lineItems")
    vat_rates: List[InvoiceVatRate] = Field(alias="vatRates")
    summaries: List[InvoiceSummary]
    attachment: Optional[Attachment] = None
    history: List[InvoiceHistory]
    __properties: ClassVar[List[str]] = ["id", "groupId", "displayId", "participant", "period", "netAmount", "grossAmount", "dueDate", "sentDate", "paidDate", "status", "lastStatusChange", "sendable", "lineItems", "vatRates", "summaries", "attachment", "history"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvoiceDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of period
        if self.period:
            _dict['period'] = self.period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item_line_items in self.line_items:
                if _item_line_items:
                    _items.append(_item_line_items.to_dict())
            _dict['lineItems'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in vat_rates (list)
        _items = []
        if self.vat_rates:
            for _item_vat_rates in self.vat_rates:
                if _item_vat_rates:
                    _items.append(_item_vat_rates.to_dict())
            _dict['vatRates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in summaries (list)
        _items = []
        if self.summaries:
            for _item_summaries in self.summaries:
                if _item_summaries:
                    _items.append(_item_summaries.to_dict())
            _dict['summaries'] = _items
        # override the default output from pydantic by calling `to_dict()` of attachment
        if self.attachment:
            _dict['attachment'] = self.attachment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item_history in self.history:
                if _item_history:
                    _items.append(_item_history.to_dict())
            _dict['history'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvoiceDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "groupId": obj.get("groupId"),
            "displayId": obj.get("displayId"),
            "participant": InvoiceParticipantDetails.from_dict(obj["participant"]) if obj.get("participant") is not None else None,
            "period": DatePeriod.from_dict(obj["period"]) if obj.get("period") is not None else None,
            "netAmount": obj.get("netAmount"),
            "grossAmount": obj.get("grossAmount"),
            "dueDate": obj.get("dueDate"),
            "sentDate": obj.get("sentDate"),
            "paidDate": obj.get("paidDate"),
            "status": obj.get("status"),
            "lastStatusChange": obj.get("lastStatusChange"),
            "sendable": obj.get("sendable"),
            "lineItems": [InvoiceLineItem.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None,
            "vatRates": [InvoiceVatRate.from_dict(_item) for _item in obj["vatRates"]] if obj.get("vatRates") is not None else None,
            "summaries": [InvoiceSummary.from_dict(_item) for _item in obj["summaries"]] if obj.get("summaries") is not None else None,
            "attachment": Attachment.from_dict(obj["attachment"]) if obj.get("attachment") is not None else None,
            "history": [InvoiceHistory.from_dict(_item) for _item in obj["history"]] if obj.get("history") is not None else None
        })
        return _obj


