# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.finance_information_lockable_amount import FinanceInformationLockableAmount
from empire_platform_api_public_client.models.finance_information_lockable_date import FinanceInformationLockableDate
from typing import Optional, Set
from typing_extensions import Self

class FinanceInformationLockablePeriod(BaseModel):
    """
    FinanceInformationLockablePeriod
    """ # noqa: E501
    validity_from: FinanceInformationLockableDate = Field(alias="validityFrom")
    validity_to: FinanceInformationLockableDate = Field(alias="validityTo")
    amount: FinanceInformationLockableAmount
    __properties: ClassVar[List[str]] = ["validityFrom", "validityTo", "amount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FinanceInformationLockablePeriod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of validity_from
        if self.validity_from:
            _dict['validityFrom'] = self.validity_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validity_to
        if self.validity_to:
            _dict['validityTo'] = self.validity_to.to_dict()
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FinanceInformationLockablePeriod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "validityFrom": FinanceInformationLockableDate.from_dict(obj["validityFrom"]) if obj.get("validityFrom") is not None else None,
            "validityTo": FinanceInformationLockableDate.from_dict(obj["validityTo"]) if obj.get("validityTo") is not None else None,
            "amount": FinanceInformationLockableAmount.from_dict(obj["amount"]) if obj.get("amount") is not None else None
        })
        return _obj


