# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from empire_platform_api_public_client.models.address import Address
from empire_platform_api_public_client.models.finance_information_bank_deposits import FinanceInformationBankDeposits
from empire_platform_api_public_client.models.finance_information_letter_of_credits import FinanceInformationLetterOfCredits
from empire_platform_api_public_client.models.finance_information_market_vat_details import FinanceInformationMarketVatDetails
from empire_platform_api_public_client.models.finance_information_sage_settings import FinanceInformationSageSettings
from typing import Optional, Set
from typing_extensions import Self

class FinanceInformation(BaseModel):
    """
    FinanceInformation
    """ # noqa: E501
    sage_settings: Optional[FinanceInformationSageSettings] = Field(default=None, alias="sageSettings")
    billing_address: Optional[Address] = Field(default=None, alias="billingAddress")
    billing_email: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, alias="billingEmail")
    vat_details: List[FinanceInformationMarketVatDetails] = Field(alias="vatDetails")
    letter_of_credits: List[FinanceInformationLetterOfCredits] = Field(alias="letterOfCredits")
    bank_deposits: List[FinanceInformationBankDeposits] = Field(alias="bankDeposits")
    __properties: ClassVar[List[str]] = ["sageSettings", "billingAddress", "billingEmail", "vatDetails", "letterOfCredits", "bankDeposits"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FinanceInformation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sage_settings
        if self.sage_settings:
            _dict['sageSettings'] = self.sage_settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of billing_address
        if self.billing_address:
            _dict['billingAddress'] = self.billing_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in vat_details (list)
        _items = []
        if self.vat_details:
            for _item_vat_details in self.vat_details:
                if _item_vat_details:
                    _items.append(_item_vat_details.to_dict())
            _dict['vatDetails'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in letter_of_credits (list)
        _items = []
        if self.letter_of_credits:
            for _item_letter_of_credits in self.letter_of_credits:
                if _item_letter_of_credits:
                    _items.append(_item_letter_of_credits.to_dict())
            _dict['letterOfCredits'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bank_deposits (list)
        _items = []
        if self.bank_deposits:
            for _item_bank_deposits in self.bank_deposits:
                if _item_bank_deposits:
                    _items.append(_item_bank_deposits.to_dict())
            _dict['bankDeposits'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FinanceInformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sageSettings": FinanceInformationSageSettings.from_dict(obj["sageSettings"]) if obj.get("sageSettings") is not None else None,
            "billingAddress": Address.from_dict(obj["billingAddress"]) if obj.get("billingAddress") is not None else None,
            "billingEmail": obj.get("billingEmail"),
            "vatDetails": [FinanceInformationMarketVatDetails.from_dict(_item) for _item in obj["vatDetails"]] if obj.get("vatDetails") is not None else None,
            "letterOfCredits": [FinanceInformationLetterOfCredits.from_dict(_item) for _item in obj["letterOfCredits"]] if obj.get("letterOfCredits") is not None else None,
            "bankDeposits": [FinanceInformationBankDeposits.from_dict(_item) for _item in obj["bankDeposits"]] if obj.get("bankDeposits") is not None else None
        })
        return _obj


