# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.dashboard_next_nomination_gate_window import DashboardNextNominationGateWindow
from empire_platform_api_public_client.models.dashboard_next_nomination_window_status import DashboardNextNominationWindowStatus
from empire_platform_api_public_client.models.mtu_period import MtuPeriod
from typing import Optional, Set
from typing_extensions import Self

class DashboardNextNominationGate(BaseModel):
    """
    DashboardNextNominationGate
    """ # noqa: E501
    timescale: AuctionTimescale
    window: DashboardNextNominationGateWindow
    delivery_period: MtuPeriod = Field(alias="deliveryPeriod")
    status: DashboardNextNominationWindowStatus
    next_action_at: datetime = Field(description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="nextActionAt")
    __properties: ClassVar[List[str]] = ["timescale", "window", "deliveryPeriod", "status", "nextActionAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DashboardNextNominationGate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of window
        if self.window:
            _dict['window'] = self.window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DashboardNextNominationGate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timescale": obj.get("timescale"),
            "window": DashboardNextNominationGateWindow.from_dict(obj["window"]) if obj.get("window") is not None else None,
            "deliveryPeriod": MtuPeriod.from_dict(obj["deliveryPeriod"]) if obj.get("deliveryPeriod") is not None else None,
            "status": obj.get("status"),
            "nextActionAt": obj.get("nextActionAt")
        })
        return _obj


