# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.border_direction import BorderDirection
from typing import Optional, Set
from typing_extensions import Self

class CreateSecondaryMarketLongTermTransferRequest(BaseModel):
    """
    CreateSecondaryMarketLongTermTransferRequest
    """ # noqa: E501
    first_day: date = Field(description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ", alias="firstDay")
    last_day: date = Field(description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ", alias="lastDay")
    direction: BorderDirection
    participant_id: StrictStr = Field(description="Unique identifier for the record in UUID4 format", alias="participantId")
    transfer_capacity: StrictInt = Field(description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers", alias="transferCapacity")
    __properties: ClassVar[List[str]] = ["firstDay", "lastDay", "direction", "participantId", "transferCapacity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSecondaryMarketLongTermTransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSecondaryMarketLongTermTransferRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstDay": obj.get("firstDay"),
            "lastDay": obj.get("lastDay"),
            "direction": obj.get("direction"),
            "participantId": obj.get("participantId"),
            "transferCapacity": obj.get("transferCapacity")
        })
        return _obj


