# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from empire_platform_api_public_client.models.audit_log_api_key import AuditLogApiKey
from empire_platform_api_public_client.models.audit_log_domain import AuditLogDomain
from empire_platform_api_public_client.models.audit_log_status import AuditLogStatus
from empire_platform_api_public_client.models.audit_log_type import AuditLogType
from empire_platform_api_public_client.models.audit_log_user import AuditLogUser
from typing import Optional, Set
from typing_extensions import Self

class AuditLog(BaseModel):
    """
    AuditLog
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    created_at: datetime = Field(description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="createdAt")
    user: AuditLogUser
    domain: AuditLogDomain
    type: AuditLogType
    status: AuditLogStatus
    description: StrictStr
    impersonated_by_user: Optional[AuditLogUser] = Field(default=None, alias="impersonatedByUser")
    requested_with_api_key: Optional[AuditLogApiKey] = Field(default=None, alias="requestedWithApiKey")
    __properties: ClassVar[List[str]] = ["id", "createdAt", "user", "domain", "type", "status", "description", "impersonatedByUser", "requestedWithApiKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditLog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of impersonated_by_user
        if self.impersonated_by_user:
            _dict['impersonatedByUser'] = self.impersonated_by_user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of requested_with_api_key
        if self.requested_with_api_key:
            _dict['requestedWithApiKey'] = self.requested_with_api_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditLog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "user": AuditLogUser.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "domain": obj.get("domain"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "description": obj.get("description"),
            "impersonatedByUser": AuditLogUser.from_dict(obj["impersonatedByUser"]) if obj.get("impersonatedByUser") is not None else None,
            "requestedWithApiKey": AuditLogApiKey.from_dict(obj["requestedWithApiKey"]) if obj.get("requestedWithApiKey") is not None else None
        })
        return _obj


