# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_status import AuctionStatus
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.date_time_period import DateTimePeriod
from empire_platform_api_public_client.models.mtu_period import MtuPeriod
from typing import Optional, Set
from typing_extensions import Self

class Auction(BaseModel):
    """
    * `offeredCapacity` = Offered capacity in kilowatts. Optional, only set for LT auctions, and should be calculated as MAX(OC) over the MTUs in the delivery period. * `currentParticipantBidCount` - Number of bids made by the organisation of the currently logged in user. Optional, only sent when the currently logged in user belongs to a PARTICIPANT type organisation. 
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier for the record in UUID4 format")
    display_id: StrictStr = Field(description="Generated display identifier", alias="displayId")
    product_type: AuctionProductType = Field(alias="productType")
    border_direction: BorderDirection = Field(alias="borderDirection")
    status: AuctionStatus
    processing: StrictBool
    delivery_period: MtuPeriod = Field(alias="deliveryPeriod")
    bidding_period: DateTimePeriod = Field(alias="biddingPeriod")
    name: StrictStr = Field(description="Human readable name")
    pre_bidding_allowed: StrictBool = Field(alias="preBiddingAllowed")
    offered_capacity: Optional[StrictInt] = Field(default=None, description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers", alias="offeredCapacity")
    current_participant_bid_count: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(default=None, description="Natural numbers {0, 1, 2, 3, ...} used for counting elements", alias="currentParticipantBidCount")
    returns_window_close: Optional[datetime] = Field(default=None, description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ", alias="returnsWindowClose")
    __properties: ClassVar[List[str]] = ["id", "displayId", "productType", "borderDirection", "status", "processing", "deliveryPeriod", "biddingPeriod", "name", "preBiddingAllowed", "offeredCapacity", "currentParticipantBidCount", "returnsWindowClose"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Auction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of delivery_period
        if self.delivery_period:
            _dict['deliveryPeriod'] = self.delivery_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bidding_period
        if self.bidding_period:
            _dict['biddingPeriod'] = self.bidding_period.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Auction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "displayId": obj.get("displayId"),
            "productType": obj.get("productType"),
            "borderDirection": obj.get("borderDirection"),
            "status": obj.get("status"),
            "processing": obj.get("processing"),
            "deliveryPeriod": MtuPeriod.from_dict(obj["deliveryPeriod"]) if obj.get("deliveryPeriod") is not None else None,
            "biddingPeriod": DateTimePeriod.from_dict(obj["biddingPeriod"]) if obj.get("biddingPeriod") is not None else None,
            "name": obj.get("name"),
            "preBiddingAllowed": obj.get("preBiddingAllowed"),
            "offeredCapacity": obj.get("offeredCapacity"),
            "currentParticipantBidCount": obj.get("currentParticipantBidCount"),
            "returnsWindowClose": obj.get("returnsWindowClose")
        })
        return _obj


