# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.aggregated_pre_nomination_options_timescale import AggregatedPreNominationOptionsTimescale
from typing import Optional, Set
from typing_extensions import Self

class AggregatedPreNominationOptions(BaseModel):
    """
    AggregatedPreNominationOptions
    """ # noqa: E501
    long_term: List[AggregatedPreNominationOptionsTimescale] = Field(alias="longTerm")
    day_ahead: List[AggregatedPreNominationOptionsTimescale] = Field(alias="dayAhead")
    intra_day: List[AggregatedPreNominationOptionsTimescale] = Field(alias="intraDay")
    __properties: ClassVar[List[str]] = ["longTerm", "dayAhead", "intraDay"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregatedPreNominationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in long_term (list)
        _items = []
        if self.long_term:
            for _item_long_term in self.long_term:
                if _item_long_term:
                    _items.append(_item_long_term.to_dict())
            _dict['longTerm'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in day_ahead (list)
        _items = []
        if self.day_ahead:
            for _item_day_ahead in self.day_ahead:
                if _item_day_ahead:
                    _items.append(_item_day_ahead.to_dict())
            _dict['dayAhead'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in intra_day (list)
        _items = []
        if self.intra_day:
            for _item_intra_day in self.intra_day:
                if _item_intra_day:
                    _items.append(_item_intra_day.to_dict())
            _dict['intraDay'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregatedPreNominationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "longTerm": [AggregatedPreNominationOptionsTimescale.from_dict(_item) for _item in obj["longTerm"]] if obj.get("longTerm") is not None else None,
            "dayAhead": [AggregatedPreNominationOptionsTimescale.from_dict(_item) for _item in obj["dayAhead"]] if obj.get("dayAhead") is not None else None,
            "intraDay": [AggregatedPreNominationOptionsTimescale.from_dict(_item) for _item in obj["intraDay"]] if obj.get("intraDay") is not None else None
        })
        return _obj


