# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from empire_platform_api_public_client.models.aggregated_nominations_mns_or_gb import AggregatedNominationsMnsOrGb
from empire_platform_api_public_client.models.aggregated_nominations_nl import AggregatedNominationsNl
from typing import Optional, Set
from typing_extensions import Self

class AggregatedNominations(BaseModel):
    """
    AggregatedNominations
    """ # noqa: E501
    mns: AggregatedNominationsMnsOrGb
    gb: AggregatedNominationsMnsOrGb
    nl: AggregatedNominationsNl
    __properties: ClassVar[List[str]] = ["mns", "gb", "nl"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregatedNominations from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mns
        if self.mns:
            _dict['mns'] = self.mns.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gb
        if self.gb:
            _dict['gb'] = self.gb.to_dict()
        # override the default output from pydantic by calling `to_dict()` of nl
        if self.nl:
            _dict['nl'] = self.nl.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregatedNominations from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "mns": AggregatedNominationsMnsOrGb.from_dict(obj["mns"]) if obj.get("mns") is not None else None,
            "gb": AggregatedNominationsMnsOrGb.from_dict(obj["gb"]) if obj.get("gb") is not None else None,
            "nl": AggregatedNominationsNl.from_dict(obj["nl"]) if obj.get("nl") is not None else None
        })
        return _obj


