# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from empire_platform_api_public_client.models.aggregated_nomination_options_bpp_enabled import AggregatedNominationOptionsBppEnabled
from empire_platform_api_public_client.models.aggregated_nomination_options_nominee_participants import AggregatedNominationOptionsNomineeParticipants
from typing import Optional, Set
from typing_extensions import Self

class AggregatedNominationOptions(BaseModel):
    """
    AggregatedNominationOptions
    """ # noqa: E501
    bpp_enabled: AggregatedNominationOptionsBppEnabled = Field(alias="bppEnabled")
    nominator_on_behalf: StrictBool = Field(alias="nominatorOnBehalf")
    nominee_participants: Optional[List[AggregatedNominationOptionsNomineeParticipants]] = Field(default=None, alias="nomineeParticipants")
    __properties: ClassVar[List[str]] = ["bppEnabled", "nominatorOnBehalf", "nomineeParticipants"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AggregatedNominationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of bpp_enabled
        if self.bpp_enabled:
            _dict['bppEnabled'] = self.bpp_enabled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nominee_participants (list)
        _items = []
        if self.nominee_participants:
            for _item_nominee_participants in self.nominee_participants:
                if _item_nominee_participants:
                    _items.append(_item_nominee_participants.to_dict())
            _dict['nomineeParticipants'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AggregatedNominationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bppEnabled": AggregatedNominationOptionsBppEnabled.from_dict(obj["bppEnabled"]) if obj.get("bppEnabled") is not None else None,
            "nominatorOnBehalf": obj.get("nominatorOnBehalf"),
            "nomineeParticipants": [AggregatedNominationOptionsNomineeParticipants.from_dict(_item) for _item in obj["nomineeParticipants"]] if obj.get("nomineeParticipants") is not None else None
        })
        return _obj


