# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictStr
from typing import List
from typing_extensions import Annotated
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.transmission_rights_overview import TransmissionRightsOverview

from empire_platform_api_public_client.api_client import ApiClient, RequestSerialized
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.rest import RESTResponseType


class TransmissionRightApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_transmission_rights_overview(
        self,
        delivery_day: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TransmissionRightsOverview:
        """get_transmission_rights_overview

        Fetch an filterable overview of Transmission Rights  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transmission_rights_overview_serialize(
            delivery_day=delivery_day,
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            timescales=timescales,
            mtu_size=mtu_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransmissionRightsOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_transmission_rights_overview_with_http_info(
        self,
        delivery_day: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TransmissionRightsOverview]:
        """get_transmission_rights_overview

        Fetch an filterable overview of Transmission Rights  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transmission_rights_overview_serialize(
            delivery_day=delivery_day,
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            timescales=timescales,
            mtu_size=mtu_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransmissionRightsOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_transmission_rights_overview_without_preload_content(
        self,
        delivery_day: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_transmission_rights_overview

        Fetch an filterable overview of Transmission Rights  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_transmission_rights_overview_serialize(
            delivery_day=delivery_day,
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            timescales=timescales,
            mtu_size=mtu_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransmissionRightsOverview",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_transmission_rights_overview_serialize(
        self,
        delivery_day,
        x_participant_ids,
        border_direction,
        timescales,
        mtu_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
            'timescales': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if timescales is not None:
            
            _query_params.append(('timescales', timescales))
            
        if mtu_size is not None:
            
            _query_params.append(('mtuSize', mtu_size.value))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/transmission-rights/overview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


