# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictBytes, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from empire_platform_api_public_client.models.aggregated_nomination_type import AggregatedNominationType
from empire_platform_api_public_client.models.auction_product_type import AuctionProductType
from empire_platform_api_public_client.models.auction_status import AuctionStatus
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.audit_log_domain import AuditLogDomain
from empire_platform_api_public_client.models.border_direction_with_both import BorderDirectionWithBoth
from empire_platform_api_public_client.models.buy_now_offer_status import BuyNowOfferStatus
from empire_platform_api_public_client.models.credit_cover_type import CreditCoverType
from empire_platform_api_public_client.models.invoice_status import InvoiceStatus
from empire_platform_api_public_client.models.invoice_type_with_netting_statement import InvoiceTypeWithNettingStatement
from empire_platform_api_public_client.models.mtu_size import MtuSize
from empire_platform_api_public_client.models.sage_code import SageCode
from empire_platform_api_public_client.models.transaction_type import TransactionType
from empire_platform_api_public_client.models.user_role import UserRole
from empire_platform_api_public_client.models.user_status import UserStatus

from empire_platform_api_public_client.api_client import ApiClient, RequestSerialized
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.rest import RESTResponseType


class ReportingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_auction_allocation_results_report(
        self,
        id_or_display_id: StrictStr,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """get_auction_allocation_results_report

        Fetch Auction Allocation Results Report in \"ECAN Allocation Results Document v4.0\" format  Report can be fetched by submitting in the `idOrDisplayId` parameter either:   - an \"Internal ID\" / in UUIDv4 format, can be obtained from the browser URLs or the `id` field of an Auction object   - a \"Display ID\" / shown on the GUI, or can be obtained from the `displayId` field of an Auction object  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param id_or_display_id: (required)
        :type id_or_display_id: str
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auction_allocation_results_report_serialize(
            id_or_display_id=id_or_display_id,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_auction_allocation_results_report_with_http_info(
        self,
        id_or_display_id: StrictStr,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """get_auction_allocation_results_report

        Fetch Auction Allocation Results Report in \"ECAN Allocation Results Document v4.0\" format  Report can be fetched by submitting in the `idOrDisplayId` parameter either:   - an \"Internal ID\" / in UUIDv4 format, can be obtained from the browser URLs or the `id` field of an Auction object   - a \"Display ID\" / shown on the GUI, or can be obtained from the `displayId` field of an Auction object  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param id_or_display_id: (required)
        :type id_or_display_id: str
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auction_allocation_results_report_serialize(
            id_or_display_id=id_or_display_id,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_auction_allocation_results_report_without_preload_content(
        self,
        id_or_display_id: StrictStr,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_auction_allocation_results_report

        Fetch Auction Allocation Results Report in \"ECAN Allocation Results Document v4.0\" format  Report can be fetched by submitting in the `idOrDisplayId` parameter either:   - an \"Internal ID\" / in UUIDv4 format, can be obtained from the browser URLs or the `id` field of an Auction object   - a \"Display ID\" / shown on the GUI, or can be obtained from the `displayId` field of an Auction object  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param id_or_display_id: (required)
        :type id_or_display_id: str
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auction_allocation_results_report_serialize(
            id_or_display_id=id_or_display_id,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '409': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_auction_allocation_results_report_serialize(
        self,
        id_or_display_id,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id_or_display_id is not None:
            _path_params['idOrDisplayId'] = id_or_display_id
        # process the query parameters
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/xml', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/auctions/{idOrDisplayId}/allocation-results',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_auctions_bids_report(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_auctions_bids_report

        Fetch Auction Bids Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_bids_report_serialize(
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': None,
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_auctions_bids_report_with_http_info(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_auctions_bids_report

        Fetch Auction Bids Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_bids_report_serialize(
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': None,
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_auctions_bids_report_without_preload_content(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_auctions_bids_report

        Fetch Auction Bids Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_bids_report_serialize(
            x_participant_id=x_participant_id,
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': None,
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_auctions_bids_report_serialize(
        self,
        x_participant_id,
        product_types,
        border_direction,
        statuses,
        delivery_period_start,
        delivery_period_end,
        bidding_period_start,
        bidding_period_end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'productTypes': 'multi',
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if product_types is not None:
            
            _query_params.append(('productTypes', product_types))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        if bidding_period_start is not None:
            if isinstance(bidding_period_start, date):
                _query_params.append(
                    (
                        'biddingPeriodStart',
                        bidding_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('biddingPeriodStart', bidding_period_start))
            
        if bidding_period_end is not None:
            if isinstance(bidding_period_end, date):
                _query_params.append(
                    (
                        'biddingPeriodEnd',
                        bidding_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('biddingPeriodEnd', bidding_period_end))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/auctions/bids',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_auctions_schedule_report(
        self,
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_auctions_schedule_report

        Fetch Auction Schedule Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_schedule_report_serialize(
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_auctions_schedule_report_with_http_info(
        self,
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_auctions_schedule_report

        Fetch Auction Schedule Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_schedule_report_serialize(
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_auctions_schedule_report_without_preload_content(
        self,
        product_types: Annotated[List[AuctionProductType], Field(description="List of Auction Product Types")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        statuses: List[AuctionStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        bidding_period_start: Optional[date] = None,
        bidding_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_auctions_schedule_report

        Fetch Auction Schedule Report  ---  __Requires Permission:__ (at least one)   * `VIEW_PUBLISHED_AUCTIONS`   * `VIEW_ANY_AUCTIONS`

        :param product_types: List of Auction Product Types (required)
        :type product_types: List[AuctionProductType]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param statuses: (required)
        :type statuses: List[AuctionStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param bidding_period_start:
        :type bidding_period_start: date
        :param bidding_period_end:
        :type bidding_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_auctions_schedule_report_serialize(
            product_types=product_types,
            border_direction=border_direction,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            bidding_period_start=bidding_period_start,
            bidding_period_end=bidding_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_auctions_schedule_report_serialize(
        self,
        product_types,
        border_direction,
        statuses,
        delivery_period_start,
        delivery_period_end,
        bidding_period_start,
        bidding_period_end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'productTypes': 'multi',
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if product_types is not None:
            
            _query_params.append(('productTypes', product_types))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        if bidding_period_start is not None:
            if isinstance(bidding_period_start, date):
                _query_params.append(
                    (
                        'biddingPeriodStart',
                        bidding_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('biddingPeriodStart', bidding_period_start))
            
        if bidding_period_end is not None:
            if isinstance(bidding_period_end, date):
                _query_params.append(
                    (
                        'biddingPeriodEnd',
                        bidding_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('biddingPeriodEnd', bidding_period_end))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/auctions/schedule',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_auction_results_settlement_per_participant_report(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        accounting_codes: List[SageCode],
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        final_results_published_from: Optional[date] = None,
        final_results_published_to: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_auction_results_settlement_per_participant_report

        Fetch Finance Auction Results Settlement Report Per Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param final_results_published_from:
        :type final_results_published_from: date
        :param final_results_published_to:
        :type final_results_published_to: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_auction_results_settlement_per_participant_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            accounting_codes=accounting_codes,
            x_participant_ids=x_participant_ids,
            final_results_published_from=final_results_published_from,
            final_results_published_to=final_results_published_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_auction_results_settlement_per_participant_report_with_http_info(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        accounting_codes: List[SageCode],
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        final_results_published_from: Optional[date] = None,
        final_results_published_to: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_auction_results_settlement_per_participant_report

        Fetch Finance Auction Results Settlement Report Per Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param final_results_published_from:
        :type final_results_published_from: date
        :param final_results_published_to:
        :type final_results_published_to: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_auction_results_settlement_per_participant_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            accounting_codes=accounting_codes,
            x_participant_ids=x_participant_ids,
            final_results_published_from=final_results_published_from,
            final_results_published_to=final_results_published_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_auction_results_settlement_per_participant_report_without_preload_content(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        accounting_codes: List[SageCode],
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        final_results_published_from: Optional[date] = None,
        final_results_published_to: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_auction_results_settlement_per_participant_report

        Fetch Finance Auction Results Settlement Report Per Participant  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param final_results_published_from:
        :type final_results_published_from: date
        :param final_results_published_to:
        :type final_results_published_to: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_auction_results_settlement_per_participant_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            accounting_codes=accounting_codes,
            x_participant_ids=x_participant_ids,
            final_results_published_from=final_results_published_from,
            final_results_published_to=final_results_published_to,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_auction_results_settlement_per_participant_report_serialize(
        self,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        accounting_codes,
        x_participant_ids,
        final_results_published_from,
        final_results_published_to,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accountingCodes': 'multi',
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if final_results_published_from is not None:
            if isinstance(final_results_published_from, date):
                _query_params.append(
                    (
                        'finalResultsPublishedFrom',
                        final_results_published_from.isoformat()
                    )
                )
            else:
                _query_params.append(('finalResultsPublishedFrom', final_results_published_from))
            
        if final_results_published_to is not None:
            if isinstance(final_results_published_to, date):
                _query_params.append(
                    (
                        'finalResultsPublishedTo',
                        final_results_published_to.isoformat()
                    )
                )
            else:
                _query_params.append(('finalResultsPublishedTo', final_results_published_to))
            
        if accounting_codes is not None:
            
            _query_params.append(('accountingCodes', accounting_codes))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/auction-results-settlement-per-participant',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_billing_report(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        invoice_period: date,
        accounting_codes: List[SageCode],
        delivery_period_start: Optional[date] = None,
        delivery_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_billing_report

        Fetch Finance Billing Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param invoice_period: (required)
        :type invoice_period: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param delivery_period_start:
        :type delivery_period_start: date
        :param delivery_period_end:
        :type delivery_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_billing_report_serialize(
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            invoice_period=invoice_period,
            accounting_codes=accounting_codes,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_billing_report_with_http_info(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        invoice_period: date,
        accounting_codes: List[SageCode],
        delivery_period_start: Optional[date] = None,
        delivery_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_billing_report

        Fetch Finance Billing Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param invoice_period: (required)
        :type invoice_period: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param delivery_period_start:
        :type delivery_period_start: date
        :param delivery_period_end:
        :type delivery_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_billing_report_serialize(
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            invoice_period=invoice_period,
            accounting_codes=accounting_codes,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_billing_report_without_preload_content(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        invoice_period: date,
        accounting_codes: List[SageCode],
        delivery_period_start: Optional[date] = None,
        delivery_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_billing_report

        Fetch Finance Billing Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param invoice_period: (required)
        :type invoice_period: date
        :param accounting_codes: (required)
        :type accounting_codes: List[SageCode]
        :param delivery_period_start:
        :type delivery_period_start: date
        :param delivery_period_end:
        :type delivery_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_billing_report_serialize(
            x_participant_ids=x_participant_ids,
            border_direction=border_direction,
            invoice_period=invoice_period,
            accounting_codes=accounting_codes,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_billing_report_serialize(
        self,
        x_participant_ids,
        border_direction,
        invoice_period,
        accounting_codes,
        delivery_period_start,
        delivery_period_end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
            'accountingCodes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if invoice_period is not None:
            if isinstance(invoice_period, date):
                _query_params.append(
                    (
                        'invoicePeriod',
                        invoice_period.isoformat()
                    )
                )
            else:
                _query_params.append(('invoicePeriod', invoice_period))
            
        if accounting_codes is not None:
            
            _query_params.append(('accountingCodes', accounting_codes))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/billing',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_bought_or_sold_capacity_report(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        transaction_types: List[TransactionType],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_bought_or_sold_capacity_report

        Fetch Finance Bought Or Sold Capacity Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param transaction_types: (required)
        :type transaction_types: List[TransactionType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_bought_or_sold_capacity_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            timescales=timescales,
            transaction_types=transaction_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_bought_or_sold_capacity_report_with_http_info(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        transaction_types: List[TransactionType],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_bought_or_sold_capacity_report

        Fetch Finance Bought Or Sold Capacity Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param transaction_types: (required)
        :type transaction_types: List[TransactionType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_bought_or_sold_capacity_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            timescales=timescales,
            transaction_types=transaction_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_bought_or_sold_capacity_report_without_preload_content(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        transaction_types: List[TransactionType],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_bought_or_sold_capacity_report

        Fetch Finance Bought Or Sold Capacity Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param transaction_types: (required)
        :type transaction_types: List[TransactionType]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_bought_or_sold_capacity_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            timescales=timescales,
            transaction_types=transaction_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_bought_or_sold_capacity_report_serialize(
        self,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        x_participant_id,
        timescales,
        transaction_types,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'timescales': 'multi',
            'transactionTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if timescales is not None:
            
            _query_params.append(('timescales', timescales))
            
        if transaction_types is not None:
            
            _query_params.append(('transactionTypes', transaction_types))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/bought-or-sold-capacity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_credit_cover_report(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        period_start: date,
        period_end: date,
        credit_type: CreditCoverType,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_credit_cover_report

        Fetch Finance Credit Cover Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param credit_type: (required)
        :type credit_type: CreditCoverType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_cover_report_serialize(
            x_participant_ids=x_participant_ids,
            period_start=period_start,
            period_end=period_end,
            credit_type=credit_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_credit_cover_report_with_http_info(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        period_start: date,
        period_end: date,
        credit_type: CreditCoverType,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_credit_cover_report

        Fetch Finance Credit Cover Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param credit_type: (required)
        :type credit_type: CreditCoverType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_cover_report_serialize(
            x_participant_ids=x_participant_ids,
            period_start=period_start,
            period_end=period_end,
            credit_type=credit_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_credit_cover_report_without_preload_content(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        period_start: date,
        period_end: date,
        credit_type: CreditCoverType,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_credit_cover_report

        Fetch Finance Credit Cover Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param credit_type: (required)
        :type credit_type: CreditCoverType
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_cover_report_serialize(
            x_participant_ids=x_participant_ids,
            period_start=period_start,
            period_end=period_end,
            credit_type=credit_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_credit_cover_report_serialize(
        self,
        x_participant_ids,
        period_start,
        period_end,
        credit_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if period_start is not None:
            if isinstance(period_start, date):
                _query_params.append(
                    (
                        'periodStart',
                        period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('periodStart', period_start))
            
        if period_end is not None:
            if isinstance(period_end, date):
                _query_params.append(
                    (
                        'periodEnd',
                        period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('periodEnd', period_end))
            
        if credit_type is not None:
            
            _query_params.append(('creditType', credit_type.value))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/credit-cover',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_credit_limit_report(
        self,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_credit_limit_report

        Fetch Finance Credit Limit Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_limit_report_serialize(
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_credit_limit_report_with_http_info(
        self,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_credit_limit_report

        Fetch Finance Credit Limit Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_limit_report_serialize(
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_credit_limit_report_without_preload_content(
        self,
        x_participant_id: Annotated[Optional[StrictStr], Field(description="Internal ID of a Participant-type Organisation (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_credit_limit_report

        Fetch Finance Credit Limit Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_FINANCE_REPORTS`   * `VIEW_ANY_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (optional)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_credit_limit_report_serialize(
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_credit_limit_report_serialize(
        self,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/credit-limit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_invoice_details_report(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        generation_month: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_invoice_details_report

        Fetch Finance Invoice Details Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param generation_month: (required)
        :type generation_month: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_details_report_serialize(
            x_participant_id=x_participant_id,
            generation_month=generation_month,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_invoice_details_report_with_http_info(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        generation_month: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_invoice_details_report

        Fetch Finance Invoice Details Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param generation_month: (required)
        :type generation_month: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_details_report_serialize(
            x_participant_id=x_participant_id,
            generation_month=generation_month,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_invoice_details_report_without_preload_content(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        generation_month: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_invoice_details_report

        Fetch Finance Invoice Details Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param generation_month: (required)
        :type generation_month: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_details_report_serialize(
            x_participant_id=x_participant_id,
            generation_month=generation_month,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_invoice_details_report_serialize(
        self,
        x_participant_id,
        generation_month,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if generation_month is not None:
            if isinstance(generation_month, date):
                _query_params.append(
                    (
                        'generationMonth',
                        generation_month.isoformat()
                    )
                )
            else:
                _query_params.append(('generationMonth', generation_month))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/invoice-details',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_invoice_pdfs(
        self,
        invoice_period_from: date,
        invoice_period_to: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        invoice_types: Optional[List[InvoiceTypeWithNettingStatement]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_invoice_pdfs

        Fetch Invoice PDFs packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param invoice_types:
        :type invoice_types: List[InvoiceTypeWithNettingStatement]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_pdfs_serialize(
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            x_participant_id=x_participant_id,
            invoice_types=invoice_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_invoice_pdfs_with_http_info(
        self,
        invoice_period_from: date,
        invoice_period_to: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        invoice_types: Optional[List[InvoiceTypeWithNettingStatement]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_invoice_pdfs

        Fetch Invoice PDFs packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param invoice_types:
        :type invoice_types: List[InvoiceTypeWithNettingStatement]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_pdfs_serialize(
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            x_participant_id=x_participant_id,
            invoice_types=invoice_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_invoice_pdfs_without_preload_content(
        self,
        invoice_period_from: date,
        invoice_period_to: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        invoice_types: Optional[List[InvoiceTypeWithNettingStatement]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_invoice_pdfs

        Fetch Invoice PDFs packaged in a ZIP archive  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param invoice_types:
        :type invoice_types: List[InvoiceTypeWithNettingStatement]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_pdfs_serialize(
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            x_participant_id=x_participant_id,
            invoice_types=invoice_types,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_invoice_pdfs_serialize(
        self,
        invoice_period_from,
        invoice_period_to,
        x_participant_id,
        invoice_types,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'invoiceTypes': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if invoice_period_from is not None:
            if isinstance(invoice_period_from, date):
                _query_params.append(
                    (
                        'invoicePeriodFrom',
                        invoice_period_from.isoformat()
                    )
                )
            else:
                _query_params.append(('invoicePeriodFrom', invoice_period_from))
            
        if invoice_period_to is not None:
            if isinstance(invoice_period_to, date):
                _query_params.append(
                    (
                        'invoicePeriodTo',
                        invoice_period_to.isoformat()
                    )
                )
            else:
                _query_params.append(('invoicePeriodTo', invoice_period_to))
            
        if invoice_types is not None:
            
            _query_params.append(('invoiceTypes', invoice_types))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/octet-stream', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/invoice-pdfs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_invoice_status_report(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        invoice_period_from: date,
        invoice_period_to: date,
        statuses: List[InvoiceStatus],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_invoice_status_report

        Fetch Finance Invoice Status Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_status_report_serialize(
            x_participant_ids=x_participant_ids,
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            statuses=statuses,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_invoice_status_report_with_http_info(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        invoice_period_from: date,
        invoice_period_to: date,
        statuses: List[InvoiceStatus],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_invoice_status_report

        Fetch Finance Invoice Status Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_status_report_serialize(
            x_participant_ids=x_participant_ids,
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            statuses=statuses,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_invoice_status_report_without_preload_content(
        self,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        invoice_period_from: date,
        invoice_period_to: date,
        statuses: List[InvoiceStatus],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_invoice_status_report

        Fetch Finance Invoice Status Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param invoice_period_from: (required)
        :type invoice_period_from: date
        :param invoice_period_to: (required)
        :type invoice_period_to: date
        :param statuses: (required)
        :type statuses: List[InvoiceStatus]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_invoice_status_report_serialize(
            x_participant_ids=x_participant_ids,
            invoice_period_from=invoice_period_from,
            invoice_period_to=invoice_period_to,
            statuses=statuses,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_invoice_status_report_serialize(
        self,
        x_participant_ids,
        invoice_period_from,
        invoice_period_to,
        statuses,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if invoice_period_from is not None:
            if isinstance(invoice_period_from, date):
                _query_params.append(
                    (
                        'invoicePeriodFrom',
                        invoice_period_from.isoformat()
                    )
                )
            else:
                _query_params.append(('invoicePeriodFrom', invoice_period_from))
            
        if invoice_period_to is not None:
            if isinstance(invoice_period_to, date):
                _query_params.append(
                    (
                        'invoicePeriodTo',
                        invoice_period_to.isoformat()
                    )
                )
            else:
                _query_params.append(('invoicePeriodTo', invoice_period_to))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/invoice-status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_single_invoice_details_report(
        self,
        invoice_display_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_single_invoice_details_report

        Fetch Finance Single Invoice Details  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_display_id: (required)
        :type invoice_display_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_single_invoice_details_report_serialize(
            invoice_display_id=invoice_display_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_single_invoice_details_report_with_http_info(
        self,
        invoice_display_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_single_invoice_details_report

        Fetch Finance Single Invoice Details  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_display_id: (required)
        :type invoice_display_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_single_invoice_details_report_serialize(
            invoice_display_id=invoice_display_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_single_invoice_details_report_without_preload_content(
        self,
        invoice_display_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_single_invoice_details_report

        Fetch Finance Single Invoice Details  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param invoice_display_id: (required)
        :type invoice_display_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_single_invoice_details_report_serialize(
            invoice_display_id=invoice_display_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_single_invoice_details_report_serialize(
        self,
        invoice_display_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if invoice_display_id is not None:
            
            _query_params.append(('invoiceDisplayId', invoice_display_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/single-invoice-details',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_uiosi_hourly_report(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_uiosi_hourly_report

        Fetch Finance UIoSI Hourly Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_hourly_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_uiosi_hourly_report_with_http_info(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_uiosi_hourly_report

        Fetch Finance UIoSI Hourly Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_hourly_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_uiosi_hourly_report_without_preload_content(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_uiosi_hourly_report

        Fetch Finance UIoSI Hourly Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_hourly_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_uiosi_hourly_report_serialize(
        self,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        x_participant_ids,
        timescale,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if timescale is not None:
            
            _query_params.append(('timescale', timescale.value))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/uiosi-hourly',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_finance_uiosi_report(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_finance_uiosi_report

        Fetch Finance UIoSI Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_finance_uiosi_report_with_http_info(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_finance_uiosi_report

        Fetch Finance UIoSI Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_finance_uiosi_report_without_preload_content(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        timescale: Annotated[AuctionTimescale, Field(description="Auction Timescale")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_finance_uiosi_report

        Fetch Finance UIoSI Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_FINANCE_REPORTS`   * `VIEW_OWN_FINANCE_REPORTS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param timescale: Auction Timescale (required)
        :type timescale: AuctionTimescale
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_finance_uiosi_report_serialize(
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            timescale=timescale,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_finance_uiosi_report_serialize(
        self,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        x_participant_ids,
        timescale,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if timescale is not None:
            
            _query_params.append(('timescale', timescale.value))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/finance/uiosi',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_organisations_audit_logs_report(
        self,
        period_start: date,
        period_end: date,
        x_organisation_id: Annotated[Optional[StrictStr], Field(description="Internal ID of an Organisation (optional)")] = None,
        domains: Optional[List[AuditLogDomain]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_organisations_audit_logs_report

        Fetch Audit Logs Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`

        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param x_organisation_id: Internal ID of an Organisation (optional)
        :type x_organisation_id: str
        :param domains:
        :type domains: List[AuditLogDomain]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_audit_logs_report_serialize(
            period_start=period_start,
            period_end=period_end,
            x_organisation_id=x_organisation_id,
            domains=domains,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_organisations_audit_logs_report_with_http_info(
        self,
        period_start: date,
        period_end: date,
        x_organisation_id: Annotated[Optional[StrictStr], Field(description="Internal ID of an Organisation (optional)")] = None,
        domains: Optional[List[AuditLogDomain]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_organisations_audit_logs_report

        Fetch Audit Logs Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`

        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param x_organisation_id: Internal ID of an Organisation (optional)
        :type x_organisation_id: str
        :param domains:
        :type domains: List[AuditLogDomain]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_audit_logs_report_serialize(
            period_start=period_start,
            period_end=period_end,
            x_organisation_id=x_organisation_id,
            domains=domains,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_organisations_audit_logs_report_without_preload_content(
        self,
        period_start: date,
        period_end: date,
        x_organisation_id: Annotated[Optional[StrictStr], Field(description="Internal ID of an Organisation (optional)")] = None,
        domains: Optional[List[AuditLogDomain]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_organisations_audit_logs_report

        Fetch Audit Logs Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_AUDIT_LOGS`   * `VIEW_ANY_AUDIT_LOGS`

        :param period_start: (required)
        :type period_start: date
        :param period_end: (required)
        :type period_end: date
        :param x_organisation_id: Internal ID of an Organisation (optional)
        :type x_organisation_id: str
        :param domains:
        :type domains: List[AuditLogDomain]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_audit_logs_report_serialize(
            period_start=period_start,
            period_end=period_end,
            x_organisation_id=x_organisation_id,
            domains=domains,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_organisations_audit_logs_report_serialize(
        self,
        period_start,
        period_end,
        x_organisation_id,
        domains,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'domains': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if period_start is not None:
            if isinstance(period_start, date):
                _query_params.append(
                    (
                        'periodStart',
                        period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('periodStart', period_start))
            
        if period_end is not None:
            if isinstance(period_end, date):
                _query_params.append(
                    (
                        'periodEnd',
                        period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('periodEnd', period_end))
            
        if domains is not None:
            
            _query_params.append(('domains', domains))
            
        # process the header parameters
        if x_organisation_id is not None:
            _header_params['X-Organisation-Id'] = x_organisation_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/organisations/audit-logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_organisations_users_report(
        self,
        x_organisation_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Organisations")],
        statuses: Optional[List[UserStatus]] = None,
        roles: Optional[List[UserRole]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_organisations_users_report

        Fetch Users Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_USERS`   * `VIEW_ANY_USERS`

        :param x_organisation_ids: List of internal IDs of Organisations (required)
        :type x_organisation_ids: List[str]
        :param statuses:
        :type statuses: List[UserStatus]
        :param roles:
        :type roles: List[UserRole]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_users_report_serialize(
            x_organisation_ids=x_organisation_ids,
            statuses=statuses,
            roles=roles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_organisations_users_report_with_http_info(
        self,
        x_organisation_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Organisations")],
        statuses: Optional[List[UserStatus]] = None,
        roles: Optional[List[UserRole]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_organisations_users_report

        Fetch Users Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_USERS`   * `VIEW_ANY_USERS`

        :param x_organisation_ids: List of internal IDs of Organisations (required)
        :type x_organisation_ids: List[str]
        :param statuses:
        :type statuses: List[UserStatus]
        :param roles:
        :type roles: List[UserRole]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_users_report_serialize(
            x_organisation_ids=x_organisation_ids,
            statuses=statuses,
            roles=roles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_organisations_users_report_without_preload_content(
        self,
        x_organisation_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Organisations")],
        statuses: Optional[List[UserStatus]] = None,
        roles: Optional[List[UserRole]] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_organisations_users_report

        Fetch Users Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_USERS`   * `VIEW_ANY_USERS`

        :param x_organisation_ids: List of internal IDs of Organisations (required)
        :type x_organisation_ids: List[str]
        :param statuses:
        :type statuses: List[UserStatus]
        :param roles:
        :type roles: List[UserRole]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_organisations_users_report_serialize(
            x_organisation_ids=x_organisation_ids,
            statuses=statuses,
            roles=roles,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_organisations_users_report_serialize(
        self,
        x_organisation_ids,
        statuses,
        roles,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Organisation-Ids': 'csv',
            'statuses': 'multi',
            'roles': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        if roles is not None:
            
            _query_params.append(('roles', roles))
            
        # process the header parameters
        if x_organisation_ids is not None:
            _header_params['X-Organisation-Ids'] = x_organisation_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/organisations/users',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_outages_curtailment_report(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_outages_curtailment_report

        Fetch Curtailment Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`   * `VIEW_CRISIS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_outages_curtailment_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_outages_curtailment_report_with_http_info(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_outages_curtailment_report

        Fetch Curtailment Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`   * `VIEW_CRISIS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_outages_curtailment_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_outages_curtailment_report_without_preload_content(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[List[StrictStr], Field(description="List of internal IDs of Participant-type Organisations")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_outages_curtailment_report

        Fetch Curtailment Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`   * `VIEW_CRISIS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (required)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_outages_curtailment_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_outages_curtailment_report_serialize(
        self,
        delivery_period_start,
        delivery_period_end,
        x_participant_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/outages/curtailment',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_trs_and_nominations_buy_now_report(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        statuses: List[BuyNowOfferStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        validity_period_start: Optional[date] = None,
        validity_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_trs_and_nominations_buy_now_report

        Fetch Buy-Now Offers Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param validity_period_start:
        :type validity_period_start: date
        :param validity_period_end:
        :type validity_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_buy_now_report_serialize(
            border_direction=border_direction,
            timescales=timescales,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_trs_and_nominations_buy_now_report_with_http_info(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        statuses: List[BuyNowOfferStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        validity_period_start: Optional[date] = None,
        validity_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_trs_and_nominations_buy_now_report

        Fetch Buy-Now Offers Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param validity_period_start:
        :type validity_period_start: date
        :param validity_period_end:
        :type validity_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_buy_now_report_serialize(
            border_direction=border_direction,
            timescales=timescales,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_trs_and_nominations_buy_now_report_without_preload_content(
        self,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        timescales: Annotated[List[AuctionTimescale], Field(description="List of Auction Timescales")],
        statuses: List[BuyNowOfferStatus],
        delivery_period_start: date,
        delivery_period_end: date,
        validity_period_start: Optional[date] = None,
        validity_period_end: Optional[date] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_trs_and_nominations_buy_now_report

        Fetch Buy-Now Offers Report  ---  __Requires Permission:__ (at least one)   * `VIEW_ANY_BUY_NOW_OFFERS`   * `VIEW_OWN_BUY_NOW_OFFERS`

        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param timescales: List of Auction Timescales (required)
        :type timescales: List[AuctionTimescale]
        :param statuses: (required)
        :type statuses: List[BuyNowOfferStatus]
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param validity_period_start:
        :type validity_period_start: date
        :param validity_period_end:
        :type validity_period_end: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_buy_now_report_serialize(
            border_direction=border_direction,
            timescales=timescales,
            statuses=statuses,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            validity_period_start=validity_period_start,
            validity_period_end=validity_period_end,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trs_and_nominations_buy_now_report_serialize(
        self,
        border_direction,
        timescales,
        statuses,
        delivery_period_start,
        delivery_period_end,
        validity_period_start,
        validity_period_end,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'timescales': 'multi',
            'statuses': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if timescales is not None:
            
            _query_params.append(('timescales', timescales))
            
        if statuses is not None:
            
            _query_params.append(('statuses', statuses))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        if validity_period_start is not None:
            if isinstance(validity_period_start, date):
                _query_params.append(
                    (
                        'validityPeriodStart',
                        validity_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('validityPeriodStart', validity_period_start))
            
        if validity_period_end is not None:
            if isinstance(validity_period_end, date):
                _query_params.append(
                    (
                        'validityPeriodEnd',
                        validity_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('validityPeriodEnd', validity_period_end))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/trs-and-nominations/buy-now',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_trs_and_nominations_overview_report(
        self,
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        type: AggregatedNominationType,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_trs_and_nominations_overview_report

        Fetch Transmission Rights & Nominations Overview Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param type: (required)
        :type type: AggregatedNominationType
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_overview_report_serialize(
            mtu_size=mtu_size,
            type=type,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_trs_and_nominations_overview_report_with_http_info(
        self,
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        type: AggregatedNominationType,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_trs_and_nominations_overview_report

        Fetch Transmission Rights & Nominations Overview Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param type: (required)
        :type type: AggregatedNominationType
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_overview_report_serialize(
            mtu_size=mtu_size,
            type=type,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_trs_and_nominations_overview_report_without_preload_content(
        self,
        mtu_size: Annotated[MtuSize, Field(description="MTU Size definition")],
        type: AggregatedNominationType,
        border_direction: Annotated[BorderDirectionWithBoth, Field(description="Border Direction with additional 'BOTH' option")],
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_trs_and_nominations_overview_report

        Fetch Transmission Rights & Nominations Overview Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TRANSMISSION_RIGHTS`   * `VIEW_ANY_TRANSMISSION_RIGHTS`   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param mtu_size: MTU Size definition (required)
        :type mtu_size: MtuSize
        :param type: (required)
        :type type: AggregatedNominationType
        :param border_direction: Border Direction with additional 'BOTH' option (required)
        :type border_direction: BorderDirectionWithBoth
        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_overview_report_serialize(
            mtu_size=mtu_size,
            type=type,
            border_direction=border_direction,
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trs_and_nominations_overview_report_serialize(
        self,
        mtu_size,
        type,
        border_direction,
        delivery_period_start,
        delivery_period_end,
        x_participant_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if mtu_size is not None:
            
            _query_params.append(('mtuSize', mtu_size.value))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/trs-and-nominations/overview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_trs_and_nominations_proof_report(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """get_trs_and_nominations_proof_report

        Fetch Transmission Rights & Nominations Proof Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_proof_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_trs_and_nominations_proof_report_with_http_info(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """get_trs_and_nominations_proof_report

        Fetch Transmission Rights & Nominations Proof Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_proof_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_trs_and_nominations_proof_report_without_preload_content(
        self,
        delivery_period_start: date,
        delivery_period_end: date,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_trs_and_nominations_proof_report

        Fetch Transmission Rights & Nominations Proof Report  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_period_start: (required)
        :type delivery_period_start: date
        :param delivery_period_end: (required)
        :type delivery_period_end: date
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_trs_and_nominations_proof_report_serialize(
            delivery_period_start=delivery_period_start,
            delivery_period_end=delivery_period_end,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "bytearray",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_trs_and_nominations_proof_report_serialize(
        self,
        delivery_period_start,
        delivery_period_end,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_period_start is not None:
            if isinstance(delivery_period_start, date):
                _query_params.append(
                    (
                        'deliveryPeriodStart',
                        delivery_period_start.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodStart', delivery_period_start))
            
        if delivery_period_end is not None:
            if isinstance(delivery_period_end, date):
                _query_params.append(
                    (
                        'deliveryPeriodEnd',
                        delivery_period_end.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryPeriodEnd', delivery_period_end))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/pdf', 
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/reporting/trs-and-nominations/proof',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


