# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 6.0.4
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from empire_platform_api_public_client.models.aggregated_nomination_options import AggregatedNominationOptions
from empire_platform_api_public_client.models.aggregated_nomination_type import AggregatedNominationType
from empire_platform_api_public_client.models.aggregated_nominations import AggregatedNominations
from empire_platform_api_public_client.models.aggregated_pre_nomination_options import AggregatedPreNominationOptions
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.submit_timescale_nominations_request import SubmitTimescaleNominationsRequest
from empire_platform_api_public_client.models.timescale_nomination_options import TimescaleNominationOptions
from empire_platform_api_public_client.models.timescale_nomination_type import TimescaleNominationType
from empire_platform_api_public_client.models.timescale_nominations import TimescaleNominations

from empire_platform_api_public_client.api_client import ApiClient, RequestSerialized
from empire_platform_api_public_client.api_response import ApiResponse
from empire_platform_api_public_client.rest import RESTResponseType


class NominationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_aggregated_nomination_options(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AggregatedNominationOptions:
        """get_aggregated_nomination_options

        Fetch options for Aggregated Nominations  Returns if the current Participant organisation is configured as \"nomination on behalf\" for any Markets. If yes, the list of \"nominees\" returned.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nomination_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_aggregated_nomination_options_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AggregatedNominationOptions]:
        """get_aggregated_nomination_options

        Fetch options for Aggregated Nominations  Returns if the current Participant organisation is configured as \"nomination on behalf\" for any Markets. If yes, the list of \"nominees\" returned.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nomination_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_aggregated_nomination_options_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_aggregated_nomination_options

        Fetch options for Aggregated Nominations  Returns if the current Participant organisation is configured as \"nomination on behalf\" for any Markets. If yes, the list of \"nominees\" returned.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nomination_options_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_aggregated_nomination_options_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/nominations/aggregated/options',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_aggregated_nominations(
        self,
        delivery_day: date,
        type: AggregatedNominationType,
        timescale_types: Optional[List[TimescaleNominationType]] = None,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AggregatedNominations:
        """get_aggregated_nominations

        Fetch aggregated Nominations for a given:   - delivery day   - type of aggregated nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: AggregatedNominationType
        :param timescale_types:
        :type timescale_types: List[TimescaleNominationType]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            timescale_types=timescale_types,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_aggregated_nominations_with_http_info(
        self,
        delivery_day: date,
        type: AggregatedNominationType,
        timescale_types: Optional[List[TimescaleNominationType]] = None,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AggregatedNominations]:
        """get_aggregated_nominations

        Fetch aggregated Nominations for a given:   - delivery day   - type of aggregated nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: AggregatedNominationType
        :param timescale_types:
        :type timescale_types: List[TimescaleNominationType]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            timescale_types=timescale_types,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_aggregated_nominations_without_preload_content(
        self,
        delivery_day: date,
        type: AggregatedNominationType,
        timescale_types: Optional[List[TimescaleNominationType]] = None,
        x_participant_ids: Annotated[Optional[List[StrictStr]], Field(description="List of internal IDs of Participant-type Organisations (optional)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_aggregated_nominations

        Fetch aggregated Nominations for a given:   - delivery day   - type of aggregated nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_SOSO_AGGREGATED_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: AggregatedNominationType
        :param timescale_types:
        :type timescale_types: List[TimescaleNominationType]
        :param x_participant_ids: List of internal IDs of Participant-type Organisations (optional)
        :type x_participant_ids: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            timescale_types=timescale_types,
            x_participant_ids=x_participant_ids,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_aggregated_nominations_serialize(
        self,
        delivery_day,
        type,
        timescale_types,
        x_participant_ids,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'timescaleTypes': 'multi',
            'X-Participant-Ids': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        if timescale_types is not None:
            
            _query_params.append(('timescaleTypes', timescale_types))
            
        # process the header parameters
        if x_participant_ids is not None:
            _header_params['X-Participant-Ids'] = x_participant_ids
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/nominations/aggregated',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_aggregated_pre_nomination_options(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        delivery_day: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AggregatedPreNominationOptions:
        """get_aggregated_pre_nomination_options

        Fetch pre-nomination options for Aggregated Nominations  Returns if the selected Participant organisation has pre-nominations defined for all the timescales for the given delivery day.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param delivery_day: (required)
        :type delivery_day: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_pre_nomination_options_serialize(
            x_participant_id=x_participant_id,
            delivery_day=delivery_day,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedPreNominationOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_aggregated_pre_nomination_options_with_http_info(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        delivery_day: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AggregatedPreNominationOptions]:
        """get_aggregated_pre_nomination_options

        Fetch pre-nomination options for Aggregated Nominations  Returns if the selected Participant organisation has pre-nominations defined for all the timescales for the given delivery day.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param delivery_day: (required)
        :type delivery_day: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_pre_nomination_options_serialize(
            x_participant_id=x_participant_id,
            delivery_day=delivery_day,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedPreNominationOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_aggregated_pre_nomination_options_without_preload_content(
        self,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        delivery_day: date,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_aggregated_pre_nomination_options

        Fetch pre-nomination options for Aggregated Nominations  Returns if the selected Participant organisation has pre-nominations defined for all the timescales for the given delivery day.  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_OR_BPP_AGGREGATED_NOMINATIONS`

        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param delivery_day: (required)
        :type delivery_day: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_aggregated_pre_nomination_options_serialize(
            x_participant_id=x_participant_id,
            delivery_day=delivery_day,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "AggregatedPreNominationOptions",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_aggregated_pre_nomination_options_serialize(
        self,
        x_participant_id,
        delivery_day,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/nominations/aggregated/options/pre-nominations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_timescale_nomination_options(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TimescaleNominationOptions:
        """get_timescale_nomination_options

        Fetch options for getting Timescale Nomination  Used to determine which are the available directions for which a given Participant has rights to nominate for a given:   - delivery day   - type of nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nomination_options_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_timescale_nomination_options_with_http_info(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TimescaleNominationOptions]:
        """get_timescale_nomination_options

        Fetch options for getting Timescale Nomination  Used to determine which are the available directions for which a given Participant has rights to nominate for a given:   - delivery day   - type of nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nomination_options_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_timescale_nomination_options_without_preload_content(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_timescale_nomination_options

        Fetch options for getting Timescale Nomination  Used to determine which are the available directions for which a given Participant has rights to nominate for a given:   - delivery day   - type of nomination  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nomination_options_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominationOptions",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_timescale_nomination_options_serialize(
        self,
        delivery_day,
        type,
        x_participant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/nominations/timescale/options',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_timescale_nominations(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TimescaleNominations:
        """get_timescale_nominations

        Fetch current Timescale Nominations for a given:   - delivery day   - type of nomination   - particpant   - border direction  MTUs are returned in the timescale's \"Nomination MTU Size\" resolution  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_timescale_nominations_with_http_info(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TimescaleNominations]:
        """get_timescale_nominations

        Fetch current Timescale Nominations for a given:   - delivery day   - type of nomination   - particpant   - border direction  MTUs are returned in the timescale's \"Nomination MTU Size\" resolution  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_timescale_nominations_without_preload_content(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_timescale_nominations

        Fetch current Timescale Nominations for a given:   - delivery day   - type of nomination   - particpant   - border direction  MTUs are returned in the timescale's \"Nomination MTU Size\" resolution  ---  __Requires Permission:__ (at least one)   * `VIEW_OWN_TIMESCALE_NOMINATIONS`   * `VIEW_ANY_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TimescaleNominations",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_timescale_nominations_serialize(
        self,
        delivery_day,
        type,
        x_participant_id,
        border_direction,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/nominations/timescale',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def submit_timescale_nominations(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        submit_timescale_nominations_request: SubmitTimescaleNominationsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """submit_timescale_nominations

        Submit Timescale Nominations for the given:   - delivery day   - type of nomination   - particpant   - border direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_TIMESCALE_NOMINATIONS`   * `MANAGE_ANY_TIMESCALE_NOMINATIONS`  __Generates Audit Log Entry:__ `SUBMIT_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param submit_timescale_nominations_request: (required)
        :type submit_timescale_nominations_request: SubmitTimescaleNominationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._submit_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            submit_timescale_nominations_request=submit_timescale_nominations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def submit_timescale_nominations_with_http_info(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        submit_timescale_nominations_request: SubmitTimescaleNominationsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """submit_timescale_nominations

        Submit Timescale Nominations for the given:   - delivery day   - type of nomination   - particpant   - border direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_TIMESCALE_NOMINATIONS`   * `MANAGE_ANY_TIMESCALE_NOMINATIONS`  __Generates Audit Log Entry:__ `SUBMIT_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param submit_timescale_nominations_request: (required)
        :type submit_timescale_nominations_request: SubmitTimescaleNominationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._submit_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            submit_timescale_nominations_request=submit_timescale_nominations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def submit_timescale_nominations_without_preload_content(
        self,
        delivery_day: date,
        type: TimescaleNominationType,
        x_participant_id: Annotated[StrictStr, Field(description="Internal ID of a Participant-type Organisation")],
        border_direction: Annotated[BorderDirection, Field(description="Border Direction")],
        submit_timescale_nominations_request: SubmitTimescaleNominationsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """submit_timescale_nominations

        Submit Timescale Nominations for the given:   - delivery day   - type of nomination   - particpant   - border direction  ---  __Requires Permission:__ (at least one)   * `MANAGE_OWN_TIMESCALE_NOMINATIONS`   * `MANAGE_ANY_TIMESCALE_NOMINATIONS`  __Generates Audit Log Entry:__ `SUBMIT_TIMESCALE_NOMINATIONS`

        :param delivery_day: (required)
        :type delivery_day: date
        :param type: (required)
        :type type: TimescaleNominationType
        :param x_participant_id: Internal ID of a Participant-type Organisation (required)
        :type x_participant_id: str
        :param border_direction: Border Direction (required)
        :type border_direction: BorderDirection
        :param submit_timescale_nominations_request: (required)
        :type submit_timescale_nominations_request: SubmitTimescaleNominationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._submit_timescale_nominations_serialize(
            delivery_day=delivery_day,
            type=type,
            x_participant_id=x_participant_id,
            border_direction=border_direction,
            submit_timescale_nominations_request=submit_timescale_nominations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '422': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _submit_timescale_nominations_serialize(
        self,
        delivery_day,
        type,
        x_participant_id,
        border_direction,
        submit_timescale_nominations_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if delivery_day is not None:
            if isinstance(delivery_day, date):
                _query_params.append(
                    (
                        'deliveryDay',
                        delivery_day.isoformat()
                    )
                )
            else:
                _query_params.append(('deliveryDay', delivery_day))
            
        if type is not None:
            
            _query_params.append(('type', type.value))
            
        if border_direction is not None:
            
            _query_params.append(('borderDirection', border_direction.value))
            
        # process the header parameters
        if x_participant_id is not None:
            _header_params['X-Participant-Id'] = x_participant_id
        # process the form parameters
        # process the body parameter
        if submit_timescale_nominations_request is not None:
            _body_params = submit_timescale_nominations_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKey'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v1/nominations/timescale',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


